/*
 * @(#)BevelGLP.h
 *
 * Copyright 2023  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for BevelGL */

#ifndef _BevelGLP_h
#define _BevelGLP_h

#include "BevelGL.h"
#include <GL/gl.h>
#include <GL/glu.h>
#ifndef WINVER
#include <GL/glx.h>

/* This gets around C's inability to do inheritance */
typedef struct _BevelGLClassPart {
	int ignore;
} BevelGLClassPart;

typedef struct _BevelGLClassRec {
	CoreClassPart coreClass;
	BevelClassPart bevelClass;
	BevelGLClassPart bevelGLClass;
} BevelGLClassRec;

extern BevelGLClassRec bevelGLClassRec;
#endif

#define TOP_FACE 0
#define LEFT_FACE 1
#define FRONT_FACE 2
#define RIGHT_FACE 3
#define BOTTOM_FACE 4
#define BACK_FACE 5
#define BORDER_FACE (MAX_FACES)
#define NO_FACE (MAX_FACES+1)
#define NO_EDGE 24
#define NO_POSITION (IGNORE_DIR)
#define NO_ROTATION (2*MAX_ORIENT)
#define NO_DEPTH (IGNORE_DIR)
#define MAX_TURN_INC 10

#define CUBE_LENGTH (float) 0.5
#define CUBE_ROUND2 (float) 0.61
#define CUBE_ROUND (CUBE_LENGTH-(float) 0.02)
#define STICKER_LONG (CUBE_ROUND-(float) 0.05)
#define STICKER_SHORT (STICKER_LONG-(float) 0.05)
#define STICKER_HALF ((STICKER_SHORT)*(float) 0.5)
#define STICKER_DEPTH (CUBE_LENGTH+(float) 0.01)
#define SELECT_LONG (float) (4.5*CUBE_ROUND/5.0-0.05)
#define SELECT_SHORT (float) (3.5*STICKER_LONG/5.0-0.05)
#define FACELEN (float) (2.0*CUBE_LENGTH)
#define FACEROUND (float) (2.0*CUBE_LENGTH-0.06)
#define FSTICKER_LONG (FACEROUND-(float) 0.05)
#define FSTICKER_SHORT (FSTICKER_LONG-(float) 0.05)
#define FSTICKER_HALF ((FSTICKER_SHORT)*(float) 0.4)
#define FSTICKER_DEPTH (FACELEN+(float) 0.01)
#define FSELECT_LONG (float) (4.0*FACEROUND/5.0-0.05)
#define FSELECT_SHORT (float) (4.0*FSTICKER_LONG/5.0-0.05)
#define CUT (float) 0.04
#define CUT2 (float) 0.02
#define CUT_DEPTH (STICKER_DEPTH+(float) 0.001)
#define FCUT_DEPTH (FSTICKER_DEPTH+(float) 0.001)
#define SELECT_DEPTH (STICKER_DEPTH+(float) 0.002)
#define FSELECT_DEPTH (FSTICKER_DEPTH+(float) 0.002)
#define TENTH (float) 0.2
#define FTENTH (float) 0.3

#define SCALE (float) 1.1

typedef struct _BevelMove {
	int         face, direction;
	int         position;
	Boolean     control;
} BevelMove;

typedef struct _BevelSlice {
	int         edge, rotation;
} BevelSlice;

typedef struct _BevelGLPart {
	double      angleStep;
	double      rotateStep;
	int         numTurnInc;
	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
	/*Point       cubeSizex, cubeSizey, cubeSizez;*/
	Point       faceSize, viewSize;
	Point       viewMiddle;
	BevelMove   movement;
	int         step;
} BevelGLPart;

typedef struct _BevelGLRec {
	CorePart    core;
	BevelPart   bevel;
	BevelGLPart bevelGL;
} BevelGLRec;

extern Boolean selectPiecesGL(BevelGLWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelectionGL(BevelGLWidget w,
	int *face, int *direction);
/*extern void drawFrameGL(BevelGLWidget w, Boolean focus);*/
extern void drawAllPiecesGL(BevelGLWidget w);
/*extern void moveAllPiecesGL(BevelGLWidget w, int face, int direction,
	int fast);*/
extern void movePiecesGL(BevelGLWidget w, int face, int position,
	int direction, Boolean control, int fast);
#ifdef WINVER
extern void resizePuzzleGL(BevelGLWidget w);
extern void exposePuzzleGL(BevelGLWidget w);
#endif

#endif /* _BevelGLP_h */
