/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1996
 * Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the default keymap of the Gateway 2000 keyboard for
 * Windows 95.  It is identical to the Microsoft "Natural" keyboard, except
 * without the ergonomic split down the middle.  
 * By Barry Warsaw <bwarsaw@cnri.reston.va.us>
 */

static const struct default_keycode_map gw2kn_map [] = {
  {   8, 0,		{ XK_grave,	XK_asciitilde }},
  {   9, 0,		{ XK_1,	XK_exclam }},
  {  10, 0,		{ XK_2,	XK_at }},
  {  11, 0,		{ XK_3,	XK_numbersign }},
  {  12, 0,		{ XK_4,	XK_dollar }},
  {  13, 0,		{ XK_5,	XK_percent }},
  {  14, 0,		{ XK_6,	XK_asciicircum }},
  {  15, 0,		{ XK_7,	XK_ampersand }},
  {  16, 0,		{ XK_8,	XK_asterisk }},
  {  17, 0,		{ XK_9,	XK_parenleft }},
  {  18, 0,		{ XK_0,	XK_parenright }},
  {  19, 0,		{ XK_minus,	XK_underscore }},
  {  20, 0,		{ XK_equal,	XK_plus }},
  {  22, 0,		{ XK_BackSpace }},
  {  23, 0,		{ XK_Tab }},
  {  24, 0,		{ XK_Q }},
  {  25, 0,		{ XK_W }},
  {  26, 0,		{ XK_E }},
  {  27, 0,		{ XK_R }},
  {  28, 0,		{ XK_T }},
  {  29, 0,		{ XK_Y }},
  {  30, 0,		{ XK_U }},
  {  31, 0,		{ XK_I }},
  {  32, 0,		{ XK_O }},
  {  33, 0,		{ XK_P }},
  {  34, 0,		{ XK_bracketleft,	XK_braceleft }},
  {  35, 0,		{ XK_bracketright,	XK_braceright }},
  {  36, 0,		{ XK_backslash,	XK_bar,
			XK_brokenbar }},
  {  37, LockMask,	{ XK_Caps_Lock }},
  {  38, 0,		{ XK_A }},
  {  39, 0,		{ XK_S }},
  {  40, 0,		{ XK_D }},
  {  41, 0,		{ XK_F }},
  {  42, 0,		{ XK_G }},
  {  43, 0,		{ XK_H }},
  {  44, 0,		{ XK_J }},
  {  45, 0,		{ XK_K }},
  {  46, 0,		{ XK_L }},
  {  47, 0,		{ XK_semicolon,	XK_colon }},
  {  48, 0,		{ XK_apostrophe,	XK_quotedbl }},
  {  50, 0,		{ XK_Return }},
  {  51, ShiftMask,	{ XK_Shift_L }},
  {  53, 0,		{ XK_Z }},
  {  54, 0,		{ XK_X }},
  {  55, 0,		{ XK_C }},
  {  56, 0,		{ XK_V }},
  {  57, 0,		{ XK_B }},
  {  58, 0,		{ XK_N }},
  {  59, 0,		{ XK_M }},
  {  60, 0,		{ XK_comma,	XK_less }},
  {  61, 0,		{ XK_period,	XK_greater }},
  {  62, 0,		{ XK_slash,	XK_question }},
  {  64, ShiftMask,	{ XK_Shift_R }},
  {  65, ControlMask,	{ XK_Control_L }},
  {  67, Mod4Mask,	{ XK_Alt_L }},
  {  68, 0,		{ XK_space }},
  {  69, Mod4Mask,	{ XK_Alt_R }},
  {  71, ControlMask,	{ XK_Control_R }},
  {  82, 0,		{ XK_Insert }},
  {  83, 0,		{ XK_Delete }},
  {  86, 0,		{ XK_Left }},
  {  87, 0,		{ XK_Home }},
  {  88, 0,		{ XK_End }},
  {  90, 0,		{ XK_Up }},
  {  91, 0,		{ XK_Down }},
  {  92, 0,		{ XK_Prior }},
  {  93, 0,		{ XK_Next }},
  {  96, 0,		{ XK_Right }},
  {  97, Mod3Mask,	{ XK_Num_Lock }},
  {  98, 0,		{ XK_Home,	XK_KP_7,
			XK_KP_7 }},
  {  99, 0,		{ XK_Left,	XK_KP_4,
			XK_KP_4 }},
  { 100, 0,		{ XK_End,	XK_KP_1,
			XK_KP_1 }},
  { 102, 0,		{ XK_KP_Divide }},
  { 103, 0,		{ XK_Up,	XK_KP_8,
			XK_KP_8 }},
  { 104, 0,		{ XK_KP_5,	XK_KP_5,
			XK_KP_5 }},
  { 105, 0,		{ XK_Down,	XK_KP_2,
			XK_KP_2 }},
  { 106, 0,		{ XK_KP_Insert,	XK_KP_0,
			XK_KP_0 }},
  { 107, 0,		{ XK_KP_Multiply }},
  { 108, 0,		{ XK_Prior,	XK_KP_9,
			XK_KP_9 }},
  { 109, 0,		{ XK_Right,	XK_KP_6,
			XK_KP_6 }},
  { 110, 0,		{ XK_Next,	XK_KP_3,
			XK_KP_3 }},
  { 111, 0,		{ XK_Delete,	XK_KP_Decimal,
			XK_KP_Decimal }},
  { 112, 0,		{ XK_KP_Subtract }},
  { 113, 0,		{ XK_KP_Add }},
  { 115, 0,		{ XK_KP_Enter }},
  { 117, 0,		{ XK_Escape }},
  { 119, 0,		{ XK_F1 }},
  { 120, 0,		{ XK_F2 }},
  { 121, 0,		{ XK_F3 }},
  { 122, 0,		{ XK_F4 }},
  { 123, 0,		{ XK_F5 }},
  { 124, 0,		{ XK_F6 }},
  { 125, 0,		{ XK_F7 }},
  { 126, 0,		{ XK_F8 }},
  { 127, 0,		{ XK_F9 }},
  { 128, 0,		{ XK_F10 }},
  { 129, 0,		{ SunXK_F36 }},
  { 130, 0,		{ SunXK_F37 }},
  { 131, 0,		{ XK_Print,	SunXK_Sys_Req }},
  { 132, 0,		{ XK_Scroll_Lock }},
  { 133, 0,		{ XK_Pause,	XK_Break }},
  { 135, 0,		{ XK_Multi_key }},
  { 136, 0,		{ XK_Mode_switch }}
  };
