/*******************************************************************************
* Copyright (c) 2014 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
*******************************************************************************/


#ifndef __XLPD_SLCR_H__
#define __XLPD_SLCR_H__


#ifdef __cplusplus
extern "C" {
#endif

/**
 * XlpdSlcr Base Address
 */
#define XLPD_SLCR_BASEADDR      0xFF410000UL

/**
 * Register: XlpdSlcrWprot0
 */
#define XLPD_SLCR_WPROT0    ( ( XLPD_SLCR_BASEADDR ) + 0x00000000UL )
#define XLPD_SLCR_WPROT0_RSTVAL   0x00000001UL

#define XLPD_SLCR_WPROT0_ACT_SHIFT   0UL
#define XLPD_SLCR_WPROT0_ACT_WIDTH   1UL
#define XLPD_SLCR_WPROT0_ACT_MASK    0x00000001UL
#define XLPD_SLCR_WPROT0_ACT_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrCtrl
 */
#define XLPD_SLCR_CTRL    ( ( XLPD_SLCR_BASEADDR ) + 0x00000004UL )
#define XLPD_SLCR_CTRL_RSTVAL   0x00000000UL

#define XLPD_SLCR_CTRL_SLVERR_EN_SHIFT   0UL
#define XLPD_SLCR_CTRL_SLVERR_EN_WIDTH   1UL
#define XLPD_SLCR_CTRL_SLVERR_EN_MASK    0x00000001UL
#define XLPD_SLCR_CTRL_SLVERR_EN_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrIsr
 */
#define XLPD_SLCR_ISR    ( ( XLPD_SLCR_BASEADDR ) + 0x00000008UL )
#define XLPD_SLCR_ISR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ISR_ADDR_DECD_ERR_SHIFT   0UL
#define XLPD_SLCR_ISR_ADDR_DECD_ERR_WIDTH   1UL
#define XLPD_SLCR_ISR_ADDR_DECD_ERR_MASK    0x00000001UL
#define XLPD_SLCR_ISR_ADDR_DECD_ERR_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrImr
 */
#define XLPD_SLCR_IMR    ( ( XLPD_SLCR_BASEADDR ) + 0x0000000CUL )
#define XLPD_SLCR_IMR_RSTVAL   0x00000001UL

#define XLPD_SLCR_IMR_ADDR_DECD_ERR_SHIFT   0UL
#define XLPD_SLCR_IMR_ADDR_DECD_ERR_WIDTH   1UL
#define XLPD_SLCR_IMR_ADDR_DECD_ERR_MASK    0x00000001UL
#define XLPD_SLCR_IMR_ADDR_DECD_ERR_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrIer
 */
#define XLPD_SLCR_IER    ( ( XLPD_SLCR_BASEADDR ) + 0x00000010UL )
#define XLPD_SLCR_IER_RSTVAL   0x00000000UL

#define XLPD_SLCR_IER_ADDR_DECD_ERR_SHIFT   0UL
#define XLPD_SLCR_IER_ADDR_DECD_ERR_WIDTH   1UL
#define XLPD_SLCR_IER_ADDR_DECD_ERR_MASK    0x00000001UL
#define XLPD_SLCR_IER_ADDR_DECD_ERR_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrIdr
 */
#define XLPD_SLCR_IDR    ( ( XLPD_SLCR_BASEADDR ) + 0x00000014UL )
#define XLPD_SLCR_IDR_RSTVAL   0x00000000UL

#define XLPD_SLCR_IDR_ADDR_DECD_ERR_SHIFT   0UL
#define XLPD_SLCR_IDR_ADDR_DECD_ERR_WIDTH   1UL
#define XLPD_SLCR_IDR_ADDR_DECD_ERR_MASK    0x00000001UL
#define XLPD_SLCR_IDR_ADDR_DECD_ERR_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrItr
 */
#define XLPD_SLCR_ITR    ( ( XLPD_SLCR_BASEADDR ) + 0x00000018UL )
#define XLPD_SLCR_ITR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ITR_ADDR_DECD_ERR_SHIFT   0UL
#define XLPD_SLCR_ITR_ADDR_DECD_ERR_WIDTH   1UL
#define XLPD_SLCR_ITR_ADDR_DECD_ERR_MASK    0x00000001UL
#define XLPD_SLCR_ITR_ADDR_DECD_ERR_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrSafetyChk0
 */
#define XLPD_SLCR_SAFETY_CHK0    ( ( XLPD_SLCR_BASEADDR ) + 0x00000040UL )
#define XLPD_SLCR_SAFETY_CHK0_RSTVAL   0x00000000UL

#define XLPD_SLCR_SAFETY_CHK0_VAL_SHIFT   0UL
#define XLPD_SLCR_SAFETY_CHK0_VAL_WIDTH   32UL
#define XLPD_SLCR_SAFETY_CHK0_VAL_MASK    0xffffffffUL
#define XLPD_SLCR_SAFETY_CHK0_VAL_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrSafetyChk1
 */
#define XLPD_SLCR_SAFETY_CHK1    ( ( XLPD_SLCR_BASEADDR ) + 0x00000044UL )
#define XLPD_SLCR_SAFETY_CHK1_RSTVAL   0x00000000UL

#define XLPD_SLCR_SAFETY_CHK1_VAL_SHIFT   0UL
#define XLPD_SLCR_SAFETY_CHK1_VAL_WIDTH   32UL
#define XLPD_SLCR_SAFETY_CHK1_VAL_MASK    0xffffffffUL
#define XLPD_SLCR_SAFETY_CHK1_VAL_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrSafetyChk2
 */
#define XLPD_SLCR_SAFETY_CHK2    ( ( XLPD_SLCR_BASEADDR ) + 0x00000048UL )
#define XLPD_SLCR_SAFETY_CHK2_RSTVAL   0x00000000UL

#define XLPD_SLCR_SAFETY_CHK2_VAL_SHIFT   0UL
#define XLPD_SLCR_SAFETY_CHK2_VAL_WIDTH   32UL
#define XLPD_SLCR_SAFETY_CHK2_VAL_MASK    0xffffffffUL
#define XLPD_SLCR_SAFETY_CHK2_VAL_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrSafetyChk3
 */
#define XLPD_SLCR_SAFETY_CHK3    ( ( XLPD_SLCR_BASEADDR ) + 0x0000004CUL )
#define XLPD_SLCR_SAFETY_CHK3_RSTVAL   0x00000000UL

#define XLPD_SLCR_SAFETY_CHK3_VAL_SHIFT   0UL
#define XLPD_SLCR_SAFETY_CHK3_VAL_WIDTH   32UL
#define XLPD_SLCR_SAFETY_CHK3_VAL_MASK    0xffffffffUL
#define XLPD_SLCR_SAFETY_CHK3_VAL_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrXcsupmuWdtClkSel
 */
#define XLPD_SLCR_XCSUPMU_WDT_CLK_SEL    ( ( XLPD_SLCR_BASEADDR ) + 0x00000050UL )
#define XLPD_SLCR_XCSUPMU_WDT_CLK_SEL_RSTVAL   0x00000000UL

#define XLPD_SLCR_XCSUPMU_WDT_CLK_SEL_SHIFT   0UL
#define XLPD_SLCR_XCSUPMU_WDT_CLK_SEL_WIDTH   1UL
#define XLPD_SLCR_XCSUPMU_WDT_CLK_SEL_MASK    0x00000001UL
#define XLPD_SLCR_XCSUPMU_WDT_CLK_SEL_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrAdmaCfg
 */
#define XLPD_SLCR_ADMA_CFG    ( ( XLPD_SLCR_BASEADDR ) + 0x0000200CUL )
#define XLPD_SLCR_ADMA_CFG_RSTVAL   0x00000028UL

#define XLPD_SLCR_ADMA_CFG_BUSWID_SHIFT   5UL
#define XLPD_SLCR_ADMA_CFG_BUSWID_WIDTH   2UL
#define XLPD_SLCR_ADMA_CFG_BUSWID_MASK    0x00000060UL
#define XLPD_SLCR_ADMA_CFG_BUSWID_DEFVAL  0x1UL

#define XLPD_SLCR_ADMA_CFG_NUM_CH_SHIFT   0UL
#define XLPD_SLCR_ADMA_CFG_NUM_CH_WIDTH   5UL
#define XLPD_SLCR_ADMA_CFG_NUM_CH_MASK    0x0000001fUL
#define XLPD_SLCR_ADMA_CFG_NUM_CH_DEFVAL  0x8UL

/**
 * Register: XlpdSlcrAdmaRam
 */
#define XLPD_SLCR_ADMA_RAM    ( ( XLPD_SLCR_BASEADDR ) + 0x00002010UL )
#define XLPD_SLCR_ADMA_RAM_RSTVAL   0x00003b3bUL

#define XLPD_SLCR_ADMA_RAM1_EMAB_SHIFT   12UL
#define XLPD_SLCR_ADMA_RAM1_EMAB_WIDTH   3UL
#define XLPD_SLCR_ADMA_RAM1_EMAB_MASK    0x00007000UL
#define XLPD_SLCR_ADMA_RAM1_EMAB_DEFVAL  0x3UL

#define XLPD_SLCR_ADMA_RAM1_EMASA_SHIFT   11UL
#define XLPD_SLCR_ADMA_RAM1_EMASA_WIDTH   1UL
#define XLPD_SLCR_ADMA_RAM1_EMASA_MASK    0x00000800UL
#define XLPD_SLCR_ADMA_RAM1_EMASA_DEFVAL  0x1UL

#define XLPD_SLCR_ADMA_RAM1_EMAA_SHIFT   8UL
#define XLPD_SLCR_ADMA_RAM1_EMAA_WIDTH   3UL
#define XLPD_SLCR_ADMA_RAM1_EMAA_MASK    0x00000700UL
#define XLPD_SLCR_ADMA_RAM1_EMAA_DEFVAL  0x3UL

#define XLPD_SLCR_ADMA_RAM0_EMAB_SHIFT   4UL
#define XLPD_SLCR_ADMA_RAM0_EMAB_WIDTH   3UL
#define XLPD_SLCR_ADMA_RAM0_EMAB_MASK    0x00000070UL
#define XLPD_SLCR_ADMA_RAM0_EMAB_DEFVAL  0x3UL

#define XLPD_SLCR_ADMA_RAM0_EMASA_SHIFT   3UL
#define XLPD_SLCR_ADMA_RAM0_EMASA_WIDTH   1UL
#define XLPD_SLCR_ADMA_RAM0_EMASA_MASK    0x00000008UL
#define XLPD_SLCR_ADMA_RAM0_EMASA_DEFVAL  0x1UL

#define XLPD_SLCR_ADMA_RAM0_EMAA_SHIFT   0UL
#define XLPD_SLCR_ADMA_RAM0_EMAA_WIDTH   3UL
#define XLPD_SLCR_ADMA_RAM0_EMAA_MASK    0x00000007UL
#define XLPD_SLCR_ADMA_RAM0_EMAA_DEFVAL  0x3UL

/**
 * Register: XlpdSlcrErrAibaxiIsr
 */
#define XLPD_SLCR_ERR_AIBAXI_ISR    ( ( XLPD_SLCR_BASEADDR ) + 0x00003000UL )
#define XLPD_SLCR_ERR_AIBAXI_ISR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS2_SHIFT   28UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS2_MASK    0x10000000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_DDR_SHIFT   27UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_DDR_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_DDR_MASK    0x08000000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_DDR_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_OCMS_SHIFT   26UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_OCMS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_OCMS_MASK    0x04000000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_OCMS_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_MAIN_SHIFT   24UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_MAIN_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_MAIN_MASK    0x01000000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_MAIN_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_USB1S_SHIFT   23UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_USB1S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_USB1S_MASK    0x00800000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_USB1S_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_USB0S_SHIFT   22UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_USB0S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_USB0S_MASK    0x00400000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_USB0S_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS1_SHIFT   19UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS1_MASK    0x00080000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS0_SHIFT   18UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS0_MASK    0x00040000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUS0_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM1_SHIFT   17UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM1_MASK    0x00020000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM0_SHIFT   16UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM0_MASK    0x00010000UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_RPUM0_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_OCM_SHIFT   3UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_OCM_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_OCM_MASK    0x00000008UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_OCM_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_LPDIBS_SHIFT   2UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_LPDIBS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_LPDIBS_MASK    0x00000004UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_FPD_LPDIBS_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS1_SHIFT   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS1_MASK    0x00000002UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS0_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS0_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAXI_ISR_AFIFS0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAibaxiImr
 */
#define XLPD_SLCR_ERR_AIBAXI_IMR    ( ( XLPD_SLCR_BASEADDR ) + 0x00003008UL )
#define XLPD_SLCR_ERR_AIBAXI_IMR_RSTVAL   0x1dcf000fUL

#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS2_SHIFT   28UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS2_MASK    0x10000000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS2_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_DDR_SHIFT   27UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_DDR_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_DDR_MASK    0x08000000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_DDR_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_OCMS_SHIFT   26UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_OCMS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_OCMS_MASK    0x04000000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_OCMS_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_MAIN_SHIFT   24UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_MAIN_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_MAIN_MASK    0x01000000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_MAIN_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_USB1S_SHIFT   23UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_USB1S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_USB1S_MASK    0x00800000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_USB1S_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_USB0S_SHIFT   22UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_USB0S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_USB0S_MASK    0x00400000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_USB0S_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS1_SHIFT   19UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS1_MASK    0x00080000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS1_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS0_SHIFT   18UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS0_MASK    0x00040000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUS0_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM1_SHIFT   17UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM1_MASK    0x00020000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM1_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM0_SHIFT   16UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM0_MASK    0x00010000UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_RPUM0_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_OCM_SHIFT   3UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_OCM_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_OCM_MASK    0x00000008UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_OCM_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_LPDIBS_SHIFT   2UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_LPDIBS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_LPDIBS_MASK    0x00000004UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_FPD_LPDIBS_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS1_SHIFT   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS1_MASK    0x00000002UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS1_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS0_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS0_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAXI_IMR_AFIFS0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrErrAibaxiIer
 */
#define XLPD_SLCR_ERR_AIBAXI_IER    ( ( XLPD_SLCR_BASEADDR ) + 0x00003010UL )
#define XLPD_SLCR_ERR_AIBAXI_IER_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS2_SHIFT   28UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS2_MASK    0x10000000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_DDR_SHIFT   27UL
#define XLPD_SLCR_ERR_AIBAXI_IER_DDR_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_DDR_MASK    0x08000000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_DDR_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_OCMS_SHIFT   26UL
#define XLPD_SLCR_ERR_AIBAXI_IER_OCMS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_OCMS_MASK    0x04000000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_OCMS_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_MAIN_SHIFT   24UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_MAIN_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_MAIN_MASK    0x01000000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_MAIN_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_USB1S_SHIFT   23UL
#define XLPD_SLCR_ERR_AIBAXI_IER_USB1S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_USB1S_MASK    0x00800000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_USB1S_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_USB0S_SHIFT   22UL
#define XLPD_SLCR_ERR_AIBAXI_IER_USB0S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_USB0S_MASK    0x00400000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_USB0S_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS1_SHIFT   19UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS1_MASK    0x00080000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS0_SHIFT   18UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS0_MASK    0x00040000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUS0_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM1_SHIFT   17UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM1_MASK    0x00020000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM0_SHIFT   16UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM0_MASK    0x00010000UL
#define XLPD_SLCR_ERR_AIBAXI_IER_RPUM0_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_OCM_SHIFT   3UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_OCM_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_OCM_MASK    0x00000008UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_OCM_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_LPDIBS_SHIFT   2UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_LPDIBS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_LPDIBS_MASK    0x00000004UL
#define XLPD_SLCR_ERR_AIBAXI_IER_FPD_LPDIBS_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS1_SHIFT   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS1_MASK    0x00000002UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS0_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS0_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAXI_IER_AFIFS0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAibaxiIdr
 */
#define XLPD_SLCR_ERR_AIBAXI_IDR    ( ( XLPD_SLCR_BASEADDR ) + 0x00003018UL )
#define XLPD_SLCR_ERR_AIBAXI_IDR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS2_SHIFT   28UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS2_MASK    0x10000000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_DDR_SHIFT   27UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_DDR_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_DDR_MASK    0x08000000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_DDR_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_OCMS_SHIFT   26UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_OCMS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_OCMS_MASK    0x04000000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_OCMS_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_MAIN_SHIFT   24UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_MAIN_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_MAIN_MASK    0x01000000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_MAIN_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_USB1S_SHIFT   23UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_USB1S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_USB1S_MASK    0x00800000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_USB1S_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_USB0S_SHIFT   22UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_USB0S_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_USB0S_MASK    0x00400000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_USB0S_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS1_SHIFT   19UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS1_MASK    0x00080000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS0_SHIFT   18UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS0_MASK    0x00040000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUS0_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM1_SHIFT   17UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM1_MASK    0x00020000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM0_SHIFT   16UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM0_MASK    0x00010000UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_RPUM0_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_OCM_SHIFT   3UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_OCM_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_OCM_MASK    0x00000008UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_OCM_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_LPDIBS_SHIFT   2UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_LPDIBS_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_LPDIBS_MASK    0x00000004UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_FPD_LPDIBS_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS1_SHIFT   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS1_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS1_MASK    0x00000002UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS1_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS0_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS0_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS0_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAXI_IDR_AFIFS0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAibapbIsr
 */
#define XLPD_SLCR_ERR_AIBAPB_ISR    ( ( XLPD_SLCR_BASEADDR ) + 0x00003020UL )
#define XLPD_SLCR_ERR_AIBAPB_ISR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_AIBAPB_ISR_GPU_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAPB_ISR_GPU_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAPB_ISR_GPU_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAPB_ISR_GPU_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAibapbImr
 */
#define XLPD_SLCR_ERR_AIBAPB_IMR    ( ( XLPD_SLCR_BASEADDR ) + 0x00003024UL )
#define XLPD_SLCR_ERR_AIBAPB_IMR_RSTVAL   0x00000001UL

#define XLPD_SLCR_ERR_AIBAPB_IMR_GPU_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAPB_IMR_GPU_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAPB_IMR_GPU_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAPB_IMR_GPU_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrErrAibapbIer
 */
#define XLPD_SLCR_ERR_AIBAPB_IER    ( ( XLPD_SLCR_BASEADDR ) + 0x00003028UL )
#define XLPD_SLCR_ERR_AIBAPB_IER_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_AIBAPB_IER_GPU_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAPB_IER_GPU_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAPB_IER_GPU_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAPB_IER_GPU_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAibapbIdr
 */
#define XLPD_SLCR_ERR_AIBAPB_IDR    ( ( XLPD_SLCR_BASEADDR ) + 0x0000302CUL )
#define XLPD_SLCR_ERR_AIBAPB_IDR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_AIBAPB_IDR_GPU_SHIFT   0UL
#define XLPD_SLCR_ERR_AIBAPB_IDR_GPU_WIDTH   1UL
#define XLPD_SLCR_ERR_AIBAPB_IDR_GPU_MASK    0x00000001UL
#define XLPD_SLCR_ERR_AIBAPB_IDR_GPU_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrIsoAibaxiReq
 */
#define XLPD_SLCR_ISO_AIBAXI_REQ    ( ( XLPD_SLCR_BASEADDR ) + 0x00003030UL )
#define XLPD_SLCR_ISO_AIBAXI_REQ_RSTVAL   0x00000000UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS2_SHIFT   28UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS2_MASK    0x10000000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_DDR_SHIFT   27UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_DDR_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_DDR_MASK    0x08000000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_DDR_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_OCMS_SHIFT   26UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_OCMS_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_OCMS_MASK    0x04000000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_OCMS_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_MAIN_SHIFT   24UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_MAIN_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_MAIN_MASK    0x01000000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_MAIN_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_USB1S_SHIFT   23UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_USB1S_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_USB1S_MASK    0x00800000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_USB1S_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_USB0S_SHIFT   22UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_USB0S_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_USB0S_MASK    0x00400000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_USB0S_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS1_SHIFT   19UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS1_MASK    0x00080000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS1_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS0_SHIFT   18UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS0_MASK    0x00040000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUS0_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM1_SHIFT   17UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM1_MASK    0x00020000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM1_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM0_SHIFT   16UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM0_MASK    0x00010000UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_RPUM0_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_OCM_SHIFT   3UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_OCM_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_OCM_MASK    0x00000008UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_OCM_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_LPDIBS_SHIFT   2UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_LPDIBS_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_LPDIBS_MASK    0x00000004UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_FPD_LPDIBS_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS1_SHIFT   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS1_MASK    0x00000002UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS1_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS0_SHIFT   0UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS0_MASK    0x00000001UL
#define XLPD_SLCR_ISO_AIBAXI_REQ_AFIFS0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrIsoAibaxiType
 */
#define XLPD_SLCR_ISO_AIBAXI_TYPE    ( ( XLPD_SLCR_BASEADDR ) + 0x00003038UL )
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RSTVAL   0x19cf000fUL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS2_SHIFT   28UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS2_MASK    0x10000000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS2_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_DDR_SHIFT   27UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_DDR_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_DDR_MASK    0x08000000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_DDR_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_OCMS_SHIFT   26UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_OCMS_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_OCMS_MASK    0x04000000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_OCMS_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_MAIN_SHIFT   24UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_MAIN_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_MAIN_MASK    0x01000000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_MAIN_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB1S_SHIFT   23UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB1S_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB1S_MASK    0x00800000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB1S_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB0S_SHIFT   22UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB0S_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB0S_MASK    0x00400000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_USB0S_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS1_SHIFT   19UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS1_MASK    0x00080000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS1_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS0_SHIFT   18UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS0_MASK    0x00040000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUS0_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM1_SHIFT   17UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM1_MASK    0x00020000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM1_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM0_SHIFT   16UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM0_MASK    0x00010000UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_RPUM0_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_OCM_SHIFT   3UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_OCM_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_OCM_MASK    0x00000008UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_OCM_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_LPDIBS_SHIFT   2UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_LPDIBS_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_LPDIBS_MASK    0x00000004UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_FPD_LPDIBS_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS1_SHIFT   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS1_MASK    0x00000002UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS1_DEFVAL  0x1UL

#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS0_SHIFT   0UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS0_MASK    0x00000001UL
#define XLPD_SLCR_ISO_AIBAXI_TYPE_AFIFS0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrIsoAibaxiAck
 */
#define XLPD_SLCR_ISO_AIBAXI_ACK    ( ( XLPD_SLCR_BASEADDR ) + 0x00003040UL )
#define XLPD_SLCR_ISO_AIBAXI_ACK_RSTVAL   0x00000000UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS2_SHIFT   28UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS2_MASK    0x10000000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_DDR_SHIFT   27UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_DDR_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_DDR_MASK    0x08000000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_DDR_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_OCMS_SHIFT   26UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_OCMS_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_OCMS_MASK    0x04000000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_OCMS_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_MAIN_SHIFT   24UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_MAIN_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_MAIN_MASK    0x01000000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_MAIN_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_USB1S_SHIFT   23UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_USB1S_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_USB1S_MASK    0x00800000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_USB1S_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_USB0S_SHIFT   22UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_USB0S_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_USB0S_MASK    0x00400000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_USB0S_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS1_SHIFT   19UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS1_MASK    0x00080000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS1_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS0_SHIFT   18UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS0_MASK    0x00040000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUS0_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM1_SHIFT   17UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM1_MASK    0x00020000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM1_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM0_SHIFT   16UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM0_MASK    0x00010000UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_RPUM0_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_OCM_SHIFT   3UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_OCM_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_OCM_MASK    0x00000008UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_OCM_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_LPDIBS_SHIFT   2UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_LPDIBS_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_LPDIBS_MASK    0x00000004UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_FPD_LPDIBS_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS1_SHIFT   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS1_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS1_MASK    0x00000002UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS1_DEFVAL  0x0UL

#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS0_SHIFT   0UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS0_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS0_MASK    0x00000001UL
#define XLPD_SLCR_ISO_AIBAXI_ACK_AFIFS0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrIsoAibapbReq
 */
#define XLPD_SLCR_ISO_AIBAPB_REQ    ( ( XLPD_SLCR_BASEADDR ) + 0x00003048UL )
#define XLPD_SLCR_ISO_AIBAPB_REQ_RSTVAL   0x00000000UL

#define XLPD_SLCR_ISO_AIBAPB_REQ_GPU_SHIFT   0UL
#define XLPD_SLCR_ISO_AIBAPB_REQ_GPU_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAPB_REQ_GPU_MASK    0x00000001UL
#define XLPD_SLCR_ISO_AIBAPB_REQ_GPU_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrIsoAibapbType
 */
#define XLPD_SLCR_ISO_AIBAPB_TYPE    ( ( XLPD_SLCR_BASEADDR ) + 0x0000304CUL )
#define XLPD_SLCR_ISO_AIBAPB_TYPE_RSTVAL   0x00000001UL

#define XLPD_SLCR_ISO_AIBAPB_TYPE_GPU_SHIFT   0UL
#define XLPD_SLCR_ISO_AIBAPB_TYPE_GPU_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAPB_TYPE_GPU_MASK    0x00000001UL
#define XLPD_SLCR_ISO_AIBAPB_TYPE_GPU_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrIsoAibapbAck
 */
#define XLPD_SLCR_ISO_AIBAPB_ACK    ( ( XLPD_SLCR_BASEADDR ) + 0x00003050UL )
#define XLPD_SLCR_ISO_AIBAPB_ACK_RSTVAL   0x00000000UL

#define XLPD_SLCR_ISO_AIBAPB_ACK_GPU_SHIFT   0UL
#define XLPD_SLCR_ISO_AIBAPB_ACK_GPU_WIDTH   1UL
#define XLPD_SLCR_ISO_AIBAPB_ACK_GPU_MASK    0x00000001UL
#define XLPD_SLCR_ISO_AIBAPB_ACK_GPU_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAtbIsr
 */
#define XLPD_SLCR_ERR_ATB_ISR    ( ( XLPD_SLCR_BASEADDR ) + 0x00006000UL )
#define XLPD_SLCR_ERR_ATB_ISR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_ATB_ISR_AFIFS2_SHIFT   1UL
#define XLPD_SLCR_ERR_ATB_ISR_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_ISR_AFIFS2_MASK    0x00000002UL
#define XLPD_SLCR_ERR_ATB_ISR_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_ATB_ISR_LPDM_SHIFT   0UL
#define XLPD_SLCR_ERR_ATB_ISR_LPDM_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_ISR_LPDM_MASK    0x00000001UL
#define XLPD_SLCR_ERR_ATB_ISR_LPDM_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAtbImr
 */
#define XLPD_SLCR_ERR_ATB_IMR    ( ( XLPD_SLCR_BASEADDR ) + 0x00006004UL )
#define XLPD_SLCR_ERR_ATB_IMR_RSTVAL   0x00000003UL

#define XLPD_SLCR_ERR_ATB_IMR_AFIFS2_SHIFT   1UL
#define XLPD_SLCR_ERR_ATB_IMR_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_IMR_AFIFS2_MASK    0x00000002UL
#define XLPD_SLCR_ERR_ATB_IMR_AFIFS2_DEFVAL  0x1UL

#define XLPD_SLCR_ERR_ATB_IMR_LPDM_SHIFT   0UL
#define XLPD_SLCR_ERR_ATB_IMR_LPDM_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_IMR_LPDM_MASK    0x00000001UL
#define XLPD_SLCR_ERR_ATB_IMR_LPDM_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrErrAtbIer
 */
#define XLPD_SLCR_ERR_ATB_IER    ( ( XLPD_SLCR_BASEADDR ) + 0x00006008UL )
#define XLPD_SLCR_ERR_ATB_IER_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_ATB_IER_AFIFS2_SHIFT   1UL
#define XLPD_SLCR_ERR_ATB_IER_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_IER_AFIFS2_MASK    0x00000002UL
#define XLPD_SLCR_ERR_ATB_IER_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_ATB_IER_LPDM_SHIFT   0UL
#define XLPD_SLCR_ERR_ATB_IER_LPDM_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_IER_LPDM_MASK    0x00000001UL
#define XLPD_SLCR_ERR_ATB_IER_LPDM_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrErrAtbIdr
 */
#define XLPD_SLCR_ERR_ATB_IDR    ( ( XLPD_SLCR_BASEADDR ) + 0x0000600CUL )
#define XLPD_SLCR_ERR_ATB_IDR_RSTVAL   0x00000000UL

#define XLPD_SLCR_ERR_ATB_IDR_AFIFS2_SHIFT   1UL
#define XLPD_SLCR_ERR_ATB_IDR_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_IDR_AFIFS2_MASK    0x00000002UL
#define XLPD_SLCR_ERR_ATB_IDR_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ERR_ATB_IDR_LPDM_SHIFT   0UL
#define XLPD_SLCR_ERR_ATB_IDR_LPDM_WIDTH   1UL
#define XLPD_SLCR_ERR_ATB_IDR_LPDM_MASK    0x00000001UL
#define XLPD_SLCR_ERR_ATB_IDR_LPDM_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrAtbCmdStoreEn
 */
#define XLPD_SLCR_ATB_CMD_STORE_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x00006010UL )
#define XLPD_SLCR_ATB_CMD_STORE_EN_RSTVAL   0x00000003UL

#define XLPD_SLCR_ATB_CMD_STORE_EN_AFIFS2_SHIFT   1UL
#define XLPD_SLCR_ATB_CMD_STORE_EN_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ATB_CMD_STORE_EN_AFIFS2_MASK    0x00000002UL
#define XLPD_SLCR_ATB_CMD_STORE_EN_AFIFS2_DEFVAL  0x1UL

#define XLPD_SLCR_ATB_CMD_STORE_EN_LPDM_SHIFT   0UL
#define XLPD_SLCR_ATB_CMD_STORE_EN_LPDM_WIDTH   1UL
#define XLPD_SLCR_ATB_CMD_STORE_EN_LPDM_MASK    0x00000001UL
#define XLPD_SLCR_ATB_CMD_STORE_EN_LPDM_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrAtbRespEn
 */
#define XLPD_SLCR_ATB_RESP_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x00006014UL )
#define XLPD_SLCR_ATB_RESP_EN_RSTVAL   0x00000000UL

#define XLPD_SLCR_ATB_RESP_EN_AFIFS2_SHIFT   1UL
#define XLPD_SLCR_ATB_RESP_EN_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ATB_RESP_EN_AFIFS2_MASK    0x00000002UL
#define XLPD_SLCR_ATB_RESP_EN_AFIFS2_DEFVAL  0x0UL

#define XLPD_SLCR_ATB_RESP_EN_LPDM_SHIFT   0UL
#define XLPD_SLCR_ATB_RESP_EN_LPDM_WIDTH   1UL
#define XLPD_SLCR_ATB_RESP_EN_LPDM_MASK    0x00000001UL
#define XLPD_SLCR_ATB_RESP_EN_LPDM_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrAtbRespType
 */
#define XLPD_SLCR_ATB_RESP_TYPE    ( ( XLPD_SLCR_BASEADDR ) + 0x00006018UL )
#define XLPD_SLCR_ATB_RESP_TYPE_RSTVAL   0x00000003UL

#define XLPD_SLCR_ATB_RESP_TYPE_AFIFS2_SHIFT   1UL
#define XLPD_SLCR_ATB_RESP_TYPE_AFIFS2_WIDTH   1UL
#define XLPD_SLCR_ATB_RESP_TYPE_AFIFS2_MASK    0x00000002UL
#define XLPD_SLCR_ATB_RESP_TYPE_AFIFS2_DEFVAL  0x1UL

#define XLPD_SLCR_ATB_RESP_TYPE_LPDM_SHIFT   0UL
#define XLPD_SLCR_ATB_RESP_TYPE_LPDM_WIDTH   1UL
#define XLPD_SLCR_ATB_RESP_TYPE_LPDM_MASK    0x00000001UL
#define XLPD_SLCR_ATB_RESP_TYPE_LPDM_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrAtbPrescale
 */
#define XLPD_SLCR_ATB_PRESCALE    ( ( XLPD_SLCR_BASEADDR ) + 0x00006020UL )
#define XLPD_SLCR_ATB_PRESCALE_RSTVAL   0x0000ffffUL

#define XLPD_SLCR_ATB_PRESCALE_EN_SHIFT   16UL
#define XLPD_SLCR_ATB_PRESCALE_EN_WIDTH   1UL
#define XLPD_SLCR_ATB_PRESCALE_EN_MASK    0x00010000UL
#define XLPD_SLCR_ATB_PRESCALE_EN_DEFVAL  0x0UL

#define XLPD_SLCR_ATB_PRESCALE_VAL_SHIFT   0UL
#define XLPD_SLCR_ATB_PRESCALE_VAL_WIDTH   16UL
#define XLPD_SLCR_ATB_PRESCALE_VAL_MASK    0x0000ffffUL
#define XLPD_SLCR_ATB_PRESCALE_VAL_DEFVAL  0xffffUL

/**
 * Register: XlpdSlcrMutex0
 */
#define XLPD_SLCR_MUTEX0    ( ( XLPD_SLCR_BASEADDR ) + 0x00007000UL )
#define XLPD_SLCR_MUTEX0_RSTVAL   0x00000000UL

#define XLPD_SLCR_MUTEX0_ID_SHIFT   0UL
#define XLPD_SLCR_MUTEX0_ID_WIDTH   32UL
#define XLPD_SLCR_MUTEX0_ID_MASK    0xffffffffUL
#define XLPD_SLCR_MUTEX0_ID_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrMutex1
 */
#define XLPD_SLCR_MUTEX1    ( ( XLPD_SLCR_BASEADDR ) + 0x00007004UL )
#define XLPD_SLCR_MUTEX1_RSTVAL   0x00000000UL

#define XLPD_SLCR_MUTEX1_ID_SHIFT   0UL
#define XLPD_SLCR_MUTEX1_ID_WIDTH   32UL
#define XLPD_SLCR_MUTEX1_ID_MASK    0xffffffffUL
#define XLPD_SLCR_MUTEX1_ID_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrMutex2
 */
#define XLPD_SLCR_MUTEX2    ( ( XLPD_SLCR_BASEADDR ) + 0x00007008UL )
#define XLPD_SLCR_MUTEX2_RSTVAL   0x00000000UL

#define XLPD_SLCR_MUTEX2_ID_SHIFT   0UL
#define XLPD_SLCR_MUTEX2_ID_WIDTH   32UL
#define XLPD_SLCR_MUTEX2_ID_MASK    0xffffffffUL
#define XLPD_SLCR_MUTEX2_ID_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrMutex3
 */
#define XLPD_SLCR_MUTEX3    ( ( XLPD_SLCR_BASEADDR ) + 0x0000700CUL )
#define XLPD_SLCR_MUTEX3_RSTVAL   0x00000000UL

#define XLPD_SLCR_MUTEX3_ID_SHIFT   0UL
#define XLPD_SLCR_MUTEX3_ID_WIDTH   32UL
#define XLPD_SLCR_MUTEX3_ID_MASK    0xffffffffUL
#define XLPD_SLCR_MUTEX3_ID_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp0IrqSts
 */
#define XLPD_SLCR_GICP0_IRQ_STS    ( ( XLPD_SLCR_BASEADDR ) + 0x00008000UL )
#define XLPD_SLCR_GICP0_IRQ_STS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_STS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP0_IRQ_STS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp0IrqMsk
 */
#define XLPD_SLCR_GICP0_IRQ_MSK    ( ( XLPD_SLCR_BASEADDR ) + 0x00008004UL )
#define XLPD_SLCR_GICP0_IRQ_MSK_RSTVAL   0xffffffffUL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC31_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC30_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC29_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC28_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC27_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC26_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC25_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC24_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC23_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC22_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC21_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC20_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC19_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC18_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC17_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC16_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC15_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC14_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC13_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC12_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC11_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC10_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC9_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC8_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC7_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC6_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC5_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC4_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC3_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC2_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC1_DEFVAL  0x1UL

#define XLPD_SLCR_GICP0_IRQ_MSK_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP0_IRQ_MSK_SRC0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrGicp0IrqEn
 */
#define XLPD_SLCR_GICP0_IRQ_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x00008008UL )
#define XLPD_SLCR_GICP0_IRQ_EN_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_EN_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP0_IRQ_EN_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp0IrqDis
 */
#define XLPD_SLCR_GICP0_IRQ_DIS    ( ( XLPD_SLCR_BASEADDR ) + 0x0000800CUL )
#define XLPD_SLCR_GICP0_IRQ_DIS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_DIS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP0_IRQ_DIS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp0IrqTrig
 */
#define XLPD_SLCR_GICP0_IRQ_TRIG    ( ( XLPD_SLCR_BASEADDR ) + 0x00008010UL )
#define XLPD_SLCR_GICP0_IRQ_TRIG_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP0_IRQ_TRIG_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp1IrqSts
 */
#define XLPD_SLCR_GICP1_IRQ_STS    ( ( XLPD_SLCR_BASEADDR ) + 0x00008014UL )
#define XLPD_SLCR_GICP1_IRQ_STS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_STS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP1_IRQ_STS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp1IrqMsk
 */
#define XLPD_SLCR_GICP1_IRQ_MSK    ( ( XLPD_SLCR_BASEADDR ) + 0x00008018UL )
#define XLPD_SLCR_GICP1_IRQ_MSK_RSTVAL   0xffffffffUL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC31_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC30_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC29_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC28_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC27_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC26_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC25_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC24_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC23_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC22_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC21_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC20_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC19_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC18_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC17_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC16_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC15_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC14_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC13_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC12_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC11_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC10_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC9_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC8_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC7_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC6_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC5_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC4_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC3_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC2_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC1_DEFVAL  0x1UL

#define XLPD_SLCR_GICP1_IRQ_MSK_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP1_IRQ_MSK_SRC0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrGicp1IrqEn
 */
#define XLPD_SLCR_GICP1_IRQ_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x0000801CUL )
#define XLPD_SLCR_GICP1_IRQ_EN_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_EN_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP1_IRQ_EN_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp1IrqDis
 */
#define XLPD_SLCR_GICP1_IRQ_DIS    ( ( XLPD_SLCR_BASEADDR ) + 0x00008020UL )
#define XLPD_SLCR_GICP1_IRQ_DIS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_DIS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP1_IRQ_DIS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp1IrqTrig
 */
#define XLPD_SLCR_GICP1_IRQ_TRIG    ( ( XLPD_SLCR_BASEADDR ) + 0x00008024UL )
#define XLPD_SLCR_GICP1_IRQ_TRIG_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP1_IRQ_TRIG_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp2IrqSts
 */
#define XLPD_SLCR_GICP2_IRQ_STS    ( ( XLPD_SLCR_BASEADDR ) + 0x00008028UL )
#define XLPD_SLCR_GICP2_IRQ_STS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_STS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP2_IRQ_STS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp2IrqMsk
 */
#define XLPD_SLCR_GICP2_IRQ_MSK    ( ( XLPD_SLCR_BASEADDR ) + 0x0000802CUL )
#define XLPD_SLCR_GICP2_IRQ_MSK_RSTVAL   0xffffffffUL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC31_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC30_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC29_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC28_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC27_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC26_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC25_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC24_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC23_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC22_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC21_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC20_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC19_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC18_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC17_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC16_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC15_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC14_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC13_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC12_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC11_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC10_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC9_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC8_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC7_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC6_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC5_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC4_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC3_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC2_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC1_DEFVAL  0x1UL

#define XLPD_SLCR_GICP2_IRQ_MSK_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP2_IRQ_MSK_SRC0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrGicp2IrqEn
 */
#define XLPD_SLCR_GICP2_IRQ_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x00008030UL )
#define XLPD_SLCR_GICP2_IRQ_EN_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_EN_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP2_IRQ_EN_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp2IrqDis
 */
#define XLPD_SLCR_GICP2_IRQ_DIS    ( ( XLPD_SLCR_BASEADDR ) + 0x00008034UL )
#define XLPD_SLCR_GICP2_IRQ_DIS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_DIS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP2_IRQ_DIS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp2IrqTrig
 */
#define XLPD_SLCR_GICP2_IRQ_TRIG    ( ( XLPD_SLCR_BASEADDR ) + 0x00008038UL )
#define XLPD_SLCR_GICP2_IRQ_TRIG_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP2_IRQ_TRIG_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp3IrqSts
 */
#define XLPD_SLCR_GICP3_IRQ_STS    ( ( XLPD_SLCR_BASEADDR ) + 0x0000803CUL )
#define XLPD_SLCR_GICP3_IRQ_STS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_STS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP3_IRQ_STS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp3IrqMsk
 */
#define XLPD_SLCR_GICP3_IRQ_MSK    ( ( XLPD_SLCR_BASEADDR ) + 0x00008040UL )
#define XLPD_SLCR_GICP3_IRQ_MSK_RSTVAL   0xffffffffUL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC31_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC30_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC29_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC28_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC27_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC26_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC25_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC24_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC23_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC22_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC21_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC20_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC19_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC18_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC17_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC16_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC15_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC14_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC13_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC12_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC11_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC10_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC9_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC8_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC7_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC6_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC5_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC4_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC3_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC2_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC1_DEFVAL  0x1UL

#define XLPD_SLCR_GICP3_IRQ_MSK_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP3_IRQ_MSK_SRC0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrGicp3IrqEn
 */
#define XLPD_SLCR_GICP3_IRQ_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x00008044UL )
#define XLPD_SLCR_GICP3_IRQ_EN_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_EN_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP3_IRQ_EN_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp3IrqDis
 */
#define XLPD_SLCR_GICP3_IRQ_DIS    ( ( XLPD_SLCR_BASEADDR ) + 0x00008048UL )
#define XLPD_SLCR_GICP3_IRQ_DIS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_DIS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP3_IRQ_DIS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp3IrqTrig
 */
#define XLPD_SLCR_GICP3_IRQ_TRIG    ( ( XLPD_SLCR_BASEADDR ) + 0x0000804CUL )
#define XLPD_SLCR_GICP3_IRQ_TRIG_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP3_IRQ_TRIG_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp4IrqSts
 */
#define XLPD_SLCR_GICP4_IRQ_STS    ( ( XLPD_SLCR_BASEADDR ) + 0x00008050UL )
#define XLPD_SLCR_GICP4_IRQ_STS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_STS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP4_IRQ_STS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp4IrqMsk
 */
#define XLPD_SLCR_GICP4_IRQ_MSK    ( ( XLPD_SLCR_BASEADDR ) + 0x00008054UL )
#define XLPD_SLCR_GICP4_IRQ_MSK_RSTVAL   0xffffffffUL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC31_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC30_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC29_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC28_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC27_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC26_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC25_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC24_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC23_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC22_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC21_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC20_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC19_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC18_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC17_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC16_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC15_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC14_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC13_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC12_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC11_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC10_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC9_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC8_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC7_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC6_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC5_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC4_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC3_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC2_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC1_DEFVAL  0x1UL

#define XLPD_SLCR_GICP4_IRQ_MSK_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP4_IRQ_MSK_SRC0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrGicp4IrqEn
 */
#define XLPD_SLCR_GICP4_IRQ_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x00008058UL )
#define XLPD_SLCR_GICP4_IRQ_EN_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_EN_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP4_IRQ_EN_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp4IrqDis
 */
#define XLPD_SLCR_GICP4_IRQ_DIS    ( ( XLPD_SLCR_BASEADDR ) + 0x0000805CUL )
#define XLPD_SLCR_GICP4_IRQ_DIS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_DIS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP4_IRQ_DIS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicp4IrqTrig
 */
#define XLPD_SLCR_GICP4_IRQ_TRIG    ( ( XLPD_SLCR_BASEADDR ) + 0x00008060UL )
#define XLPD_SLCR_GICP4_IRQ_TRIG_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC31_SHIFT   31UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC31_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC31_MASK    0x80000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC31_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC30_SHIFT   30UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC30_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC30_MASK    0x40000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC30_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC29_SHIFT   29UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC29_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC29_MASK    0x20000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC29_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC28_SHIFT   28UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC28_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC28_MASK    0x10000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC28_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC27_SHIFT   27UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC27_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC27_MASK    0x08000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC27_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC26_SHIFT   26UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC26_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC26_MASK    0x04000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC26_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC25_SHIFT   25UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC25_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC25_MASK    0x02000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC25_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC24_SHIFT   24UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC24_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC24_MASK    0x01000000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC24_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC23_SHIFT   23UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC23_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC23_MASK    0x00800000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC23_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC22_SHIFT   22UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC22_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC22_MASK    0x00400000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC22_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC21_SHIFT   21UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC21_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC21_MASK    0x00200000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC21_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC20_SHIFT   20UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC20_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC20_MASK    0x00100000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC20_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC19_SHIFT   19UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC19_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC19_MASK    0x00080000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC19_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC18_SHIFT   18UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC18_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC18_MASK    0x00040000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC18_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC17_SHIFT   17UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC17_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC17_MASK    0x00020000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC17_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC16_SHIFT   16UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC16_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC16_MASK    0x00010000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC16_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC15_SHIFT   15UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC15_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC15_MASK    0x00008000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC15_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC14_SHIFT   14UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC14_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC14_MASK    0x00004000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC14_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC13_SHIFT   13UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC13_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC13_MASK    0x00002000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC13_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC12_SHIFT   12UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC12_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC12_MASK    0x00001000UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC12_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC11_SHIFT   11UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC11_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC11_MASK    0x00000800UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC11_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC10_SHIFT   10UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC10_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC10_MASK    0x00000400UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC10_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC9_SHIFT   9UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC9_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC9_MASK    0x00000200UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC9_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC8_SHIFT   8UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC8_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC8_MASK    0x00000100UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC8_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP4_IRQ_TRIG_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicpPmuIrqSts
 */
#define XLPD_SLCR_GICP_PMU_IRQ_STS    ( ( XLPD_SLCR_BASEADDR ) + 0x000080A0UL )
#define XLPD_SLCR_GICP_PMU_IRQ_STS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP_PMU_IRQ_STS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicpPmuIrqMsk
 */
#define XLPD_SLCR_GICP_PMU_IRQ_MSK    ( ( XLPD_SLCR_BASEADDR ) + 0x000080A4UL )
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_RSTVAL   0x000000ffUL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC7_DEFVAL  0x1UL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC6_DEFVAL  0x1UL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC5_DEFVAL  0x1UL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC4_DEFVAL  0x1UL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC3_DEFVAL  0x1UL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC2_DEFVAL  0x1UL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC1_DEFVAL  0x1UL

#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP_PMU_IRQ_MSK_SRC0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrGicpPmuIrqEn
 */
#define XLPD_SLCR_GICP_PMU_IRQ_EN    ( ( XLPD_SLCR_BASEADDR ) + 0x000080A8UL )
#define XLPD_SLCR_GICP_PMU_IRQ_EN_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP_PMU_IRQ_EN_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicpPmuIrqDis
 */
#define XLPD_SLCR_GICP_PMU_IRQ_DIS    ( ( XLPD_SLCR_BASEADDR ) + 0x000080ACUL )
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP_PMU_IRQ_DIS_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrGicpPmuIrqTrig
 */
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG    ( ( XLPD_SLCR_BASEADDR ) + 0x000080B0UL )
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_RSTVAL   0x00000000UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC7_SHIFT   7UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC7_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC7_MASK    0x00000080UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC7_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC6_SHIFT   6UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC6_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC6_MASK    0x00000040UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC6_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC5_SHIFT   5UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC5_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC5_MASK    0x00000020UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC5_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC4_SHIFT   4UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC4_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC4_MASK    0x00000010UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC4_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC3_SHIFT   3UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC3_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC3_MASK    0x00000008UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC3_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC2_SHIFT   2UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC2_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC2_MASK    0x00000004UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC2_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC1_SHIFT   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC1_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC1_MASK    0x00000002UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC1_DEFVAL  0x0UL

#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC0_SHIFT   0UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC0_WIDTH   1UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC0_MASK    0x00000001UL
#define XLPD_SLCR_GICP_PMU_IRQ_TRIG_SRC0_DEFVAL  0x0UL

/**
 * Register: XlpdSlcrAfiFs
 */
#define XLPD_SLCR_AFI_FS    ( ( XLPD_SLCR_BASEADDR ) + 0x00009000UL )
#define XLPD_SLCR_AFI_FS_RSTVAL   0x00000200UL

#define XLPD_SLCR_AFI_FS_DW_SS2_SEL_SHIFT   8UL
#define XLPD_SLCR_AFI_FS_DW_SS2_SEL_WIDTH   2UL
#define XLPD_SLCR_AFI_FS_DW_SS2_SEL_MASK    0x00000300UL
#define XLPD_SLCR_AFI_FS_DW_SS2_SEL_DEFVAL  0x2UL

/**
 * Register: XlpdSlcrCci
 */
#define XLPD_SLCR_CCI    ( ( XLPD_SLCR_BASEADDR ) + 0x0000A000UL )
#define XLPD_SLCR_CCI_RSTVAL   0x03801c07UL

#define XLPD_SLCR_CCI_SPR_SHIFT   28UL
#define XLPD_SLCR_CCI_SPR_WIDTH   4UL
#define XLPD_SLCR_CCI_SPR_MASK    0xf0000000UL
#define XLPD_SLCR_CCI_SPR_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_QVNVNETS4_SHIFT   27UL
#define XLPD_SLCR_CCI_QVNVNETS4_WIDTH   1UL
#define XLPD_SLCR_CCI_QVNVNETS4_MASK    0x08000000UL
#define XLPD_SLCR_CCI_QVNVNETS4_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_QVNVNETS3_SHIFT   26UL
#define XLPD_SLCR_CCI_QVNVNETS3_WIDTH   1UL
#define XLPD_SLCR_CCI_QVNVNETS3_MASK    0x04000000UL
#define XLPD_SLCR_CCI_QVNVNETS3_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_QVNVNETS2_SHIFT   25UL
#define XLPD_SLCR_CCI_QVNVNETS2_WIDTH   1UL
#define XLPD_SLCR_CCI_QVNVNETS2_MASK    0x02000000UL
#define XLPD_SLCR_CCI_QVNVNETS2_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_QVNVNETS1_SHIFT   24UL
#define XLPD_SLCR_CCI_QVNVNETS1_WIDTH   1UL
#define XLPD_SLCR_CCI_QVNVNETS1_MASK    0x01000000UL
#define XLPD_SLCR_CCI_QVNVNETS1_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_QVNVNETS0_SHIFT   23UL
#define XLPD_SLCR_CCI_QVNVNETS0_WIDTH   1UL
#define XLPD_SLCR_CCI_QVNVNETS0_MASK    0x00800000UL
#define XLPD_SLCR_CCI_QVNVNETS0_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_QOS_OVRRD_SHIFT   18UL
#define XLPD_SLCR_CCI_QOS_OVRRD_WIDTH   5UL
#define XLPD_SLCR_CCI_QOS_OVRRD_MASK    0x007c0000UL
#define XLPD_SLCR_CCI_QOS_OVRRD_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_QVN_EN_M2_SHIFT   17UL
#define XLPD_SLCR_CCI_QVN_EN_M2_WIDTH   1UL
#define XLPD_SLCR_CCI_QVN_EN_M2_MASK    0x00020000UL
#define XLPD_SLCR_CCI_QVN_EN_M2_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_QVN_EN_M1_SHIFT   16UL
#define XLPD_SLCR_CCI_QVN_EN_M1_WIDTH   1UL
#define XLPD_SLCR_CCI_QVN_EN_M1_MASK    0x00010000UL
#define XLPD_SLCR_CCI_QVN_EN_M1_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_STRPG_GRAN_SHIFT   13UL
#define XLPD_SLCR_CCI_STRPG_GRAN_WIDTH   3UL
#define XLPD_SLCR_CCI_STRPG_GRAN_MASK    0x0000e000UL
#define XLPD_SLCR_CCI_STRPG_GRAN_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ACCHNLLEN4_SHIFT   12UL
#define XLPD_SLCR_CCI_ACCHNLLEN4_WIDTH   1UL
#define XLPD_SLCR_CCI_ACCHNLLEN4_MASK    0x00001000UL
#define XLPD_SLCR_CCI_ACCHNLLEN4_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_ACCHNLLEN3_SHIFT   11UL
#define XLPD_SLCR_CCI_ACCHNLLEN3_WIDTH   1UL
#define XLPD_SLCR_CCI_ACCHNLLEN3_MASK    0x00000800UL
#define XLPD_SLCR_CCI_ACCHNLLEN3_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_ACCHNLLEN0_SHIFT   10UL
#define XLPD_SLCR_CCI_ACCHNLLEN0_WIDTH   1UL
#define XLPD_SLCR_CCI_ACCHNLLEN0_MASK    0x00000400UL
#define XLPD_SLCR_CCI_ACCHNLLEN0_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_ECOREVNUM_SHIFT   6UL
#define XLPD_SLCR_CCI_ECOREVNUM_WIDTH   4UL
#define XLPD_SLCR_CCI_ECOREVNUM_MASK    0x000003c0UL
#define XLPD_SLCR_CCI_ECOREVNUM_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ASA2_SHIFT   5UL
#define XLPD_SLCR_CCI_ASA2_WIDTH   1UL
#define XLPD_SLCR_CCI_ASA2_MASK    0x00000020UL
#define XLPD_SLCR_CCI_ASA2_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ASA1_SHIFT   4UL
#define XLPD_SLCR_CCI_ASA1_WIDTH   1UL
#define XLPD_SLCR_CCI_ASA1_MASK    0x00000010UL
#define XLPD_SLCR_CCI_ASA1_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ASA0_SHIFT   3UL
#define XLPD_SLCR_CCI_ASA0_WIDTH   1UL
#define XLPD_SLCR_CCI_ASA0_MASK    0x00000008UL
#define XLPD_SLCR_CCI_ASA0_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_OWO2_SHIFT   2UL
#define XLPD_SLCR_CCI_OWO2_WIDTH   1UL
#define XLPD_SLCR_CCI_OWO2_MASK    0x00000004UL
#define XLPD_SLCR_CCI_OWO2_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_OWO1_SHIFT   1UL
#define XLPD_SLCR_CCI_OWO1_WIDTH   1UL
#define XLPD_SLCR_CCI_OWO1_MASK    0x00000002UL
#define XLPD_SLCR_CCI_OWO1_DEFVAL  0x1UL

#define XLPD_SLCR_CCI_OWO0_SHIFT   0UL
#define XLPD_SLCR_CCI_OWO0_WIDTH   1UL
#define XLPD_SLCR_CCI_OWO0_MASK    0x00000001UL
#define XLPD_SLCR_CCI_OWO0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrCciAddrmap
 */
#define XLPD_SLCR_CCI_ADDRMAP    ( ( XLPD_SLCR_BASEADDR ) + 0x0000A004UL )
#define XLPD_SLCR_CCI_ADDRMAP_RSTVAL   0x00c000ffUL

#define XLPD_SLCR_CCI_ADDRMAP_15_SHIFT   30UL
#define XLPD_SLCR_CCI_ADDRMAP_15_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_15_MASK    0xc0000000UL
#define XLPD_SLCR_CCI_ADDRMAP_15_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_14_SHIFT   28UL
#define XLPD_SLCR_CCI_ADDRMAP_14_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_14_MASK    0x30000000UL
#define XLPD_SLCR_CCI_ADDRMAP_14_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_13_SHIFT   26UL
#define XLPD_SLCR_CCI_ADDRMAP_13_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_13_MASK    0x0c000000UL
#define XLPD_SLCR_CCI_ADDRMAP_13_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_12_SHIFT   24UL
#define XLPD_SLCR_CCI_ADDRMAP_12_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_12_MASK    0x03000000UL
#define XLPD_SLCR_CCI_ADDRMAP_12_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_11_SHIFT   22UL
#define XLPD_SLCR_CCI_ADDRMAP_11_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_11_MASK    0x00c00000UL
#define XLPD_SLCR_CCI_ADDRMAP_11_DEFVAL  0x3UL

#define XLPD_SLCR_CCI_ADDRMAP_10_SHIFT   20UL
#define XLPD_SLCR_CCI_ADDRMAP_10_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_10_MASK    0x00300000UL
#define XLPD_SLCR_CCI_ADDRMAP_10_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_9_SHIFT   18UL
#define XLPD_SLCR_CCI_ADDRMAP_9_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_9_MASK    0x000c0000UL
#define XLPD_SLCR_CCI_ADDRMAP_9_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_8_SHIFT   16UL
#define XLPD_SLCR_CCI_ADDRMAP_8_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_8_MASK    0x00030000UL
#define XLPD_SLCR_CCI_ADDRMAP_8_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_7_SHIFT   14UL
#define XLPD_SLCR_CCI_ADDRMAP_7_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_7_MASK    0x0000c000UL
#define XLPD_SLCR_CCI_ADDRMAP_7_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_6_SHIFT   12UL
#define XLPD_SLCR_CCI_ADDRMAP_6_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_6_MASK    0x00003000UL
#define XLPD_SLCR_CCI_ADDRMAP_6_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_5_SHIFT   10UL
#define XLPD_SLCR_CCI_ADDRMAP_5_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_5_MASK    0x00000c00UL
#define XLPD_SLCR_CCI_ADDRMAP_5_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_4_SHIFT   8UL
#define XLPD_SLCR_CCI_ADDRMAP_4_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_4_MASK    0x00000300UL
#define XLPD_SLCR_CCI_ADDRMAP_4_DEFVAL  0x0UL

#define XLPD_SLCR_CCI_ADDRMAP_3_SHIFT   6UL
#define XLPD_SLCR_CCI_ADDRMAP_3_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_3_MASK    0x000000c0UL
#define XLPD_SLCR_CCI_ADDRMAP_3_DEFVAL  0x3UL

#define XLPD_SLCR_CCI_ADDRMAP_2_SHIFT   4UL
#define XLPD_SLCR_CCI_ADDRMAP_2_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_2_MASK    0x00000030UL
#define XLPD_SLCR_CCI_ADDRMAP_2_DEFVAL  0x3UL

#define XLPD_SLCR_CCI_ADDRMAP_1_SHIFT   2UL
#define XLPD_SLCR_CCI_ADDRMAP_1_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_1_MASK    0x0000000cUL
#define XLPD_SLCR_CCI_ADDRMAP_1_DEFVAL  0x3UL

#define XLPD_SLCR_CCI_ADDRMAP_0_SHIFT   0UL
#define XLPD_SLCR_CCI_ADDRMAP_0_WIDTH   2UL
#define XLPD_SLCR_CCI_ADDRMAP_0_MASK    0x00000003UL
#define XLPD_SLCR_CCI_ADDRMAP_0_DEFVAL  0x3UL

/**
 * Register: XlpdSlcrCciQvnprealloc
 */
#define XLPD_SLCR_CCI_QVNPREALLOC    ( ( XLPD_SLCR_BASEADDR ) + 0x0000A008UL )
#define XLPD_SLCR_CCI_QVNPREALLOC_RSTVAL   0x00330330UL

#define XLPD_SLCR_CCI_QVNPREALLOC_WM2_SHIFT   20UL
#define XLPD_SLCR_CCI_QVNPREALLOC_WM2_WIDTH   4UL
#define XLPD_SLCR_CCI_QVNPREALLOC_WM2_MASK    0x00f00000UL
#define XLPD_SLCR_CCI_QVNPREALLOC_WM2_DEFVAL  0x3UL

#define XLPD_SLCR_CCI_QVNPREALLOC_WM1_SHIFT   16UL
#define XLPD_SLCR_CCI_QVNPREALLOC_WM1_WIDTH   4UL
#define XLPD_SLCR_CCI_QVNPREALLOC_WM1_MASK    0x000f0000UL
#define XLPD_SLCR_CCI_QVNPREALLOC_WM1_DEFVAL  0x3UL

#define XLPD_SLCR_CCI_QVNPREALLOC_RM2_SHIFT   8UL
#define XLPD_SLCR_CCI_QVNPREALLOC_RM2_WIDTH   4UL
#define XLPD_SLCR_CCI_QVNPREALLOC_RM2_MASK    0x00000f00UL
#define XLPD_SLCR_CCI_QVNPREALLOC_RM2_DEFVAL  0x3UL

#define XLPD_SLCR_CCI_QVNPREALLOC_RM1_SHIFT   4UL
#define XLPD_SLCR_CCI_QVNPREALLOC_RM1_WIDTH   4UL
#define XLPD_SLCR_CCI_QVNPREALLOC_RM1_MASK    0x000000f0UL
#define XLPD_SLCR_CCI_QVNPREALLOC_RM1_DEFVAL  0x3UL

/**
 * Register: XlpdSlcrSmmu
 */
#define XLPD_SLCR_SMMU    ( ( XLPD_SLCR_BASEADDR ) + 0x0000A020UL )
#define XLPD_SLCR_SMMU_RSTVAL   0x0000003fUL

#define XLPD_SLCR_SMMU_INTG_SEC_OVRRDE_SHIFT   7UL
#define XLPD_SLCR_SMMU_INTG_SEC_OVRRDE_WIDTH   1UL
#define XLPD_SLCR_SMMU_INTG_SEC_OVRRDE_MASK    0x00000080UL
#define XLPD_SLCR_SMMU_INTG_SEC_OVRRDE_DEFVAL  0x0UL

#define XLPD_SLCR_SMMU_CTTW_SHIFT   6UL
#define XLPD_SLCR_SMMU_CTTW_WIDTH   1UL
#define XLPD_SLCR_SMMU_CTTW_MASK    0x00000040UL
#define XLPD_SLCR_SMMU_CTTW_DEFVAL  0x0UL

#define XLPD_SLCR_SMMU_SYSBARDIS_TBU5_SHIFT   5UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU5_WIDTH   1UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU5_MASK    0x00000020UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU5_DEFVAL  0x1UL

#define XLPD_SLCR_SMMU_SYSBARDIS_TBU4_SHIFT   4UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU4_WIDTH   1UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU4_MASK    0x00000010UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU4_DEFVAL  0x1UL

#define XLPD_SLCR_SMMU_SYSBARDIS_TBU3_SHIFT   3UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU3_WIDTH   1UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU3_MASK    0x00000008UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU3_DEFVAL  0x1UL

#define XLPD_SLCR_SMMU_SYSBARDIS_TBU2_SHIFT   2UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU2_WIDTH   1UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU2_MASK    0x00000004UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU2_DEFVAL  0x1UL

#define XLPD_SLCR_SMMU_SYSBARDIS_TBU1_SHIFT   1UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU1_WIDTH   1UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU1_MASK    0x00000002UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU1_DEFVAL  0x1UL

#define XLPD_SLCR_SMMU_SYSBARDIS_TBU0_SHIFT   0UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU0_WIDTH   1UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU0_MASK    0x00000001UL
#define XLPD_SLCR_SMMU_SYSBARDIS_TBU0_DEFVAL  0x1UL

/**
 * Register: XlpdSlcrApu
 */
#define XLPD_SLCR_APU    ( ( XLPD_SLCR_BASEADDR ) + 0x0000A040UL )
#define XLPD_SLCR_APU_RSTVAL   0x00000001UL

#define XLPD_SLCR_APU_BRDC_BARRIER_SHIFT   3UL
#define XLPD_SLCR_APU_BRDC_BARRIER_WIDTH   1UL
#define XLPD_SLCR_APU_BRDC_BARRIER_MASK    0x00000008UL
#define XLPD_SLCR_APU_BRDC_BARRIER_DEFVAL  0x0UL

#define XLPD_SLCR_APU_BRDC_CMNT_SHIFT   2UL
#define XLPD_SLCR_APU_BRDC_CMNT_WIDTH   1UL
#define XLPD_SLCR_APU_BRDC_CMNT_MASK    0x00000004UL
#define XLPD_SLCR_APU_BRDC_CMNT_DEFVAL  0x0UL

#define XLPD_SLCR_APU_BRDC_INNER_SHIFT   1UL
#define XLPD_SLCR_APU_BRDC_INNER_WIDTH   1UL
#define XLPD_SLCR_APU_BRDC_INNER_MASK    0x00000002UL
#define XLPD_SLCR_APU_BRDC_INNER_DEFVAL  0x0UL

#define XLPD_SLCR_APU_BRDC_OUTER_SHIFT   0UL
#define XLPD_SLCR_APU_BRDC_OUTER_WIDTH   1UL
#define XLPD_SLCR_APU_BRDC_OUTER_MASK    0x00000001UL
#define XLPD_SLCR_APU_BRDC_OUTER_DEFVAL  0x1UL


#ifdef __cplusplus
}
#endif

#endif /* __XLPD_SLCR_H__ */
