
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         ce_exprparse
#define yylex           ce_exprlex
#define yyerror         ce_exprerror
#define yylval          ce_exprlval
#define yychar          ce_exprchar
#define yydebug         ce_exprdebug
#define yynerrs         ce_exprnerrs


/* Copy the first part of user declarations.  */


/* Line 189 of yacc.c  */
#line 81 "ce_expr.tab.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

/* "%code requires" blocks.  */

/* Line 209 of yacc.c  */
#line 41 "ce_expr.yy"


#include "config.h"

#include <cassert>
#include <cstdlib>
#include <cstring>

#include <iostream>
#include <sstream>
#include <iterator>
#include <string>
#include <stack>

//#define DODS_DEBUG

#include "debug.h"
#include "escaping.h"

#include "DDS.h"
#include "ConstraintEvaluator.h"

#include "BaseType.h"

#include "Byte.h"
#include "Int16.h"
#include "UInt16.h"
#include "Int32.h"
#include "UInt32.h"
#include "Float32.h"
#include "Float64.h"
#include "Str.h"
#include "Url.h"
#include "Array.h"
#include "Structure.h"
#include "Sequence.h"
#include "Grid.h"

#include "Error.h"

#include "util.h"
#include "parser.h"
#include "ce_parser.h"
#include "expr.h"
#include "RValue.h"

using std::cerr;
using std::endl;
using namespace libdap ;

#define EVALUATOR(arg) (static_cast<ce_parser_arg*>(arg)->get_eval())
#define DDS(arg) (static_cast<ce_parser_arg*>(arg)->get_dds())

// #define YYPARSE_PARAM arg

int ce_exprlex(void);		/* the scanner; see expr.lex */

void ce_exprerror(ce_parser_arg *arg, const string &s); 
void ce_exprerror(ce_parser_arg *arg, const string &s, const string &s2);
void no_such_func(ce_parser_arg *arg, const string &name);
void no_such_ident(ce_parser_arg *arg, const string &name, const string &word);

int_list *make_array_index(value &i1, value &i2, value &i3);
int_list *make_array_index(value &i1, value &i2);
int_list *make_array_index(value &i1);
int_list_list *make_array_indices(int_list *index);
int_list_list *append_array_index(int_list_list *indices, int_list *index);

void delete_array_indices(int_list_list *indices);
bool bracket_projection(DDS &table, const char *name, int_list_list *indices);

void process_array_indices(BaseType *variable, int_list_list *indices); 
void process_grid_indices(BaseType *variable, int_list_list *indices); 
void process_sequence_indices(BaseType *variable, int_list_list *indices);

/* Replace these with method calls. jhrg 8/31/06 */
bool is_array_t(BaseType *variable);
bool is_grid_t(BaseType *variable);
bool is_sequence_t(BaseType *variable);

BaseType *make_variable(ConstraintEvaluator &eval, const value &val);
bool_func get_function(const ConstraintEvaluator &eval, const char *name);
btp_func get_btp_function(const ConstraintEvaluator &eval, const char *name);
proj_func get_proj_function(const ConstraintEvaluator &eval, const char *name);

template<class arg_list, class arg_type>
arg_list make_fast_arg_list(unsigned long vector_size_hint, arg_type arg_value);

template<class arg_list, class arg_type>
arg_list make_fast_arg_list(arg_list int_values, arg_type arg_value);

template<class t, class T>
rvalue *build_constant_array(vector<t> *values, DDS *dds);




/* Line 209 of yacc.c  */
#line 203 "ce_expr.tab.cc"

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SCAN_STR = 258,
     SCAN_WORD = 259,
     SCAN_EQUAL = 260,
     SCAN_NOT_EQUAL = 261,
     SCAN_GREATER = 262,
     SCAN_GREATER_EQL = 263,
     SCAN_LESS = 264,
     SCAN_LESS_EQL = 265,
     SCAN_REGEXP = 266,
     SCAN_STAR = 267,
     SCAN_HASH_BYTE = 268,
     SCAN_HASH_INT16 = 269,
     SCAN_HASH_UINT16 = 270,
     SCAN_HASH_INT32 = 271,
     SCAN_HASH_UINT32 = 272,
     SCAN_HASH_FLOAT32 = 273,
     SCAN_HASH_FLOAT64 = 274
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 145 "ce_expr.yy"

    bool boolean;
    int op;
    char id[ID_MAX];
    
    libdap::dods_byte byte_value;
    libdap::dods_int16 int16_value;
    libdap::dods_uint16 uint16_value;
    libdap::dods_int32 int32_value;
    libdap::dods_uint32 uint32_value;
    libdap::dods_float32 float32_value;
    libdap::dods_float64 float64_value;
    
    libdap::byte_arg_list byte_values;
    libdap::int16_arg_list int16_values;
    libdap::uint16_arg_list uint16_values;
    libdap::int32_arg_list int32_values;
    libdap::uint32_arg_list uint32_values;
    libdap::float32_arg_list float32_values;
    libdap::float64_arg_list float64_values;
    
    libdap::value val;               // value is defined in expr.h

    libdap::bool_func b_func;
    libdap::btp_func bt_func;

    libdap::int_list *int_l_ptr;
    libdap::int_list_list *int_ll_ptr;
    
    libdap::rvalue *rval_ptr;
    libdap::rvalue_list *r_val_l_ptr;



/* Line 214 of yacc.c  */
#line 274 "ce_expr.tab.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 286 "ce_expr.tab.cc"
/* Unqualified %code blocks.  */

/* Line 265 of yacc.c  */
#line 232 "ce_expr.yy"

/* This global is used by the rule 'arg_length_hint' so that the hint can 
   be used during the paraent rule's parse. See fast_int32_arg_list. */
unsigned long arg_length_hint_value = 0;



/* Line 265 of yacc.c  */
#line 299 "ce_expr.tab.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  28
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   157

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  29
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  35
/* YYNRULES -- Number of rules.  */
#define YYNRULES  78
/* YYNRULES -- Number of states.  */
#define YYNSTATES  146

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   274

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    20,     2,
      22,    24,     2,     2,    21,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    23,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    27,     2,    28,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    25,     2,    26,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint8 yyprhs[] =
{
       0,     0,     3,     4,     6,     7,    11,    15,    17,    21,
      23,    25,    27,    29,    36,    43,    50,    57,    64,    71,
      78,    80,    82,    86,    88,    90,    94,    96,    98,   102,
     104,   106,   110,   112,   114,   118,   120,   122,   126,   128,
     130,   134,   136,   141,   143,   147,   153,   157,   159,   164,
     166,   171,   173,   175,   179,   181,   182,   184,   186,   188,
     191,   194,   198,   200,   202,   204,   207,   211,   215,   221,
     227,   235,   243,   245,   247,   249,   251,   253,   255
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      30,     0,    -1,    -1,    32,    -1,    -1,    20,    31,    51,
      -1,    32,    20,    51,    -1,    33,    -1,    33,    21,    32,
      -1,    60,    -1,    50,    -1,    58,    -1,    34,    -1,    13,
      22,    35,    23,    36,    24,    -1,    14,    22,    35,    23,
      38,    24,    -1,    15,    22,    35,    23,    40,    24,    -1,
      16,    22,    35,    23,    42,    24,    -1,    17,    22,    35,
      23,    44,    24,    -1,    18,    22,    35,    23,    46,    24,
      -1,    19,    22,    35,    23,    48,    24,    -1,     4,    -1,
      37,    -1,    36,    21,    37,    -1,     4,    -1,    39,    -1,
      38,    21,    39,    -1,     4,    -1,    41,    -1,    40,    21,
      41,    -1,     4,    -1,    43,    -1,    42,    21,    43,    -1,
       4,    -1,    45,    -1,    44,    21,    45,    -1,     4,    -1,
      47,    -1,    46,    21,    47,    -1,     4,    -1,    49,    -1,
      48,    21,    49,    -1,     4,    -1,     4,    22,    56,    24,
      -1,    52,    -1,    51,    20,    52,    -1,    54,    63,    25,
      55,    26,    -1,    54,    63,    54,    -1,    53,    -1,     4,
      22,    56,    24,    -1,    57,    -1,     4,    22,    56,    24,
      -1,    34,    -1,    54,    -1,    55,    21,    54,    -1,    55,
      -1,    -1,     4,    -1,     3,    -1,    59,    -1,    60,    61,
      -1,    59,    60,    -1,    59,    60,    61,    -1,     4,    -1,
       3,    -1,    62,    -1,    61,    62,    -1,    27,     4,    28,
      -1,    27,    12,    28,    -1,    27,     4,    23,     4,    28,
      -1,    27,     4,    23,    12,    28,    -1,    27,     4,    23,
       4,    23,     4,    28,    -1,    27,     4,    23,     4,    23,
      12,    28,    -1,     5,    -1,     6,    -1,     7,    -1,     8,
      -1,     9,    -1,    10,    -1,    11,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   241,   241,   247,   249,   249,   253,   259,   260,   266,
     278,   282,   286,   310,   316,   322,   328,   334,   340,   346,
     355,   366,   370,   377,   384,   388,   395,   402,   406,   413,
     420,   424,   431,   438,   442,   449,   456,   460,   467,   474,
     478,   485,   492,   514,   515,   521,   530,   541,   548,   562,
     563,   573,   579,   586,   595,   600,   605,   634,   650,   655,
     664,   670,   681,   686,   697,   701,   713,   722,   729,   741,
     752,   767,   783,   784,   785,   786,   787,   788,   789
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SCAN_STR", "SCAN_WORD", "SCAN_EQUAL",
  "SCAN_NOT_EQUAL", "SCAN_GREATER", "SCAN_GREATER_EQL", "SCAN_LESS",
  "SCAN_LESS_EQL", "SCAN_REGEXP", "SCAN_STAR", "SCAN_HASH_BYTE",
  "SCAN_HASH_INT16", "SCAN_HASH_UINT16", "SCAN_HASH_INT32",
  "SCAN_HASH_UINT32", "SCAN_HASH_FLOAT32", "SCAN_HASH_FLOAT64", "'&'",
  "','", "'('", "':'", "')'", "'{'", "'}'", "'['", "']'", "$accept",
  "constraint_expr", "$@1", "projection", "proj_clause",
  "array_const_special_form", "arg_length_hint", "fast_byte_arg_list",
  "fast_byte_arg", "fast_int16_arg_list", "fast_int16_arg",
  "fast_uint16_arg_list", "fast_uint16_arg", "fast_int32_arg_list",
  "fast_int32_arg", "fast_uint32_arg_list", "fast_uint32_arg",
  "fast_float32_arg_list", "fast_float32_arg", "fast_float64_arg_list",
  "fast_float64_arg", "proj_function", "selection", "clause",
  "bool_function", "r_value", "r_value_list", "arg_list", "id_or_const",
  "array_projection", "array_proj_clause", "name", "array_indices",
  "array_index", "rel_op", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      38,    44,    40,    58,    41,   123,   125,    91,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    29,    30,    30,    31,    30,    30,    32,    32,    33,
      33,    33,    33,    34,    34,    34,    34,    34,    34,    34,
      35,    36,    36,    37,    38,    38,    39,    40,    40,    41,
      42,    42,    43,    44,    44,    45,    46,    46,    47,    48,
      48,    49,    50,    51,    51,    52,    52,    52,    53,    54,
      54,    54,    55,    55,    56,    56,    57,    57,    58,    59,
      59,    59,    60,    60,    61,    61,    62,    62,    62,    62,
      62,    62,    63,    63,    63,    63,    63,    63,    63
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     1,     0,     3,     3,     1,     3,     1,
       1,     1,     1,     6,     6,     6,     6,     6,     6,     6,
       1,     1,     3,     1,     1,     3,     1,     1,     3,     1,
       1,     3,     1,     1,     3,     1,     1,     3,     1,     1,
       3,     1,     4,     1,     3,     5,     3,     1,     4,     1,
       4,     1,     1,     3,     1,     0,     1,     1,     1,     2,
       2,     3,     1,     1,     1,     2,     3,     3,     5,     5,
       7,     7,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       2,    63,    62,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     3,     7,    12,    10,    11,    58,     9,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     1,     0,
       0,    62,    60,     0,    59,    64,    57,    56,    51,    52,
      54,     0,    49,    20,     0,     0,     0,     0,     0,     0,
       0,    56,     5,    43,    47,     0,     6,     8,    61,     0,
       0,    65,    55,     0,    42,     0,     0,     0,     0,     0,
       0,     0,    55,     0,    72,    73,    74,    75,    76,    77,
      78,     0,     0,    66,    67,     0,    53,    23,     0,    21,
      26,     0,    24,    29,     0,    27,    32,     0,    30,    35,
       0,    33,    38,     0,    36,    41,     0,    39,     0,    44,
       0,    46,     0,     0,    50,     0,    13,     0,    14,     0,
      15,     0,    16,     0,    17,     0,    18,     0,    19,    50,
       0,     0,    68,    69,    22,    25,    28,    31,    34,    37,
      40,    45,     0,     0,    70,    71
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,    11,    27,    12,    13,    38,    44,    88,    89,    91,
      92,    94,    95,    97,    98,   100,   101,   103,   104,   106,
     107,    15,    52,    53,    54,    39,    40,    41,    42,    16,
      17,    18,    34,    35,    81
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -58
static const yytype_int16 yypact[] =
{
      44,   -58,    -8,    56,    83,    86,    87,    88,    89,    90,
     -58,    23,    31,    92,   -58,   -58,   -58,    73,    71,    26,
     103,   103,   103,   103,   103,   103,   103,    52,   -58,    52,
      69,   -58,    71,    21,    71,   -58,   -58,    93,   -58,   -58,
      95,    94,   -58,   -58,    91,    96,    97,    98,    99,   100,
     101,   104,   105,   -58,   -58,    85,   105,   -58,    71,     9,
     102,   -58,    26,    26,   -58,   113,   123,   124,   125,   127,
     128,   129,    26,    52,   -58,   -58,   -58,   -58,   -58,   -58,
     -58,     3,    22,   -58,   -58,   110,   -58,   -58,    14,   -58,
     -58,    28,   -58,   -58,    29,   -58,   -58,    76,   -58,   -58,
      78,   -58,   -58,    80,   -58,   -58,    82,   -58,   111,   -58,
      26,   -58,    51,   108,   -58,   113,   -58,   123,   -58,   124,
     -58,   125,   -58,   127,   -58,   128,   -58,   129,   -58,     4,
      54,    77,   -58,   -58,   -58,   -58,   -58,   -58,   -58,   -58,
     -58,   -58,   109,   112,   -58,   -58
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -58,   -58,   -58,   114,   -58,     1,   -13,   -58,    24,   -58,
      25,   -58,    19,   -58,    20,   -58,    27,   -58,    18,   -58,
      30,   -58,   116,    74,   -58,   -27,    36,   -57,   -58,   -58,
     -58,   131,   117,   -31,   -58
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -49
static const yytype_int16 yytable[] =
{
      55,    14,    55,    61,   -48,    85,    36,    37,    45,    46,
      47,    48,    49,    50,    19,   108,     3,     4,     5,     6,
       7,     8,     9,    28,   -48,    59,   112,    61,   110,    36,
      37,    14,    82,    60,   113,   115,    86,    83,   116,     3,
       4,     5,     6,     7,     8,     9,    55,     1,     2,   117,
     119,    29,   118,   120,   111,    36,    51,     3,     4,     5,
       6,     7,     8,     9,    10,     3,     4,     5,     6,     7,
       8,     9,     1,     2,   131,    63,     1,    31,    20,   132,
     141,   142,     3,     4,     5,     6,     7,     8,     9,   143,
      74,    75,    76,    77,    78,    79,    80,   121,    33,   123,
     122,   125,   124,   127,   126,    21,   128,    43,    22,    23,
      24,    25,    26,    30,    65,    62,    63,    87,    64,    66,
      67,    68,    69,    70,    71,    73,    72,    90,    93,    96,
      84,    99,   102,   105,   114,   129,   133,   144,   136,   134,
     145,   137,   135,   139,    57,    56,   130,   109,    32,    58,
     138,     0,     0,     0,     0,     0,     0,   140
};

static const yytype_int8 yycheck[] =
{
      27,     0,    29,    34,     0,    62,     3,     4,    21,    22,
      23,    24,    25,    26,    22,    72,    13,    14,    15,    16,
      17,    18,    19,     0,    20,     4,     4,    58,    25,     3,
       4,    30,    23,    12,    12,    21,    63,    28,    24,    13,
      14,    15,    16,    17,    18,    19,    73,     3,     4,    21,
      21,    20,    24,    24,    81,     3,     4,    13,    14,    15,
      16,    17,    18,    19,    20,    13,    14,    15,    16,    17,
      18,    19,     3,     4,    23,    21,     3,     4,    22,    28,
      26,     4,    13,    14,    15,    16,    17,    18,    19,    12,
       5,     6,     7,     8,     9,    10,    11,    21,    27,    21,
      24,    21,    24,    21,    24,    22,    24,     4,    22,    22,
      22,    22,    22,    21,    23,    22,    21,     4,    24,    23,
      23,    23,    23,    23,    23,    20,    22,     4,     4,     4,
      28,     4,     4,     4,    24,    24,    28,    28,   119,   115,
      28,   121,   117,   125,    30,    29,   110,    73,    17,    32,
     123,    -1,    -1,    -1,    -1,    -1,    -1,   127
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     4,    13,    14,    15,    16,    17,    18,    19,
      20,    30,    32,    33,    34,    50,    58,    59,    60,    22,
      22,    22,    22,    22,    22,    22,    22,    31,     0,    20,
      21,     4,    60,    27,    61,    62,     3,     4,    34,    54,
      55,    56,    57,     4,    35,    35,    35,    35,    35,    35,
      35,     4,    51,    52,    53,    54,    51,    32,    61,     4,
      12,    62,    22,    21,    24,    23,    23,    23,    23,    23,
      23,    23,    22,    20,     5,     6,     7,     8,     9,    10,
      11,    63,    23,    28,    28,    56,    54,     4,    36,    37,
       4,    38,    39,     4,    40,    41,     4,    42,    43,     4,
      44,    45,     4,    46,    47,     4,    48,    49,    56,    52,
      25,    54,     4,    12,    24,    21,    24,    21,    24,    21,
      24,    21,    24,    21,    24,    21,    24,    21,    24,    24,
      55,    23,    28,    28,    37,    39,    41,    43,    45,    47,
      49,    26,     4,    12,    28,    28
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (arg, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, arg); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, ce_parser_arg *arg)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, arg)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    ce_parser_arg *arg;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (arg);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, ce_parser_arg *arg)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, arg)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    ce_parser_arg *arg;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, arg);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule, ce_parser_arg *arg)
#else
static void
yy_reduce_print (yyvsp, yyrule, arg)
    YYSTYPE *yyvsp;
    int yyrule;
    ce_parser_arg *arg;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       , arg);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule, arg); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, ce_parser_arg *arg)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, arg)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    ce_parser_arg *arg;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (arg);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (ce_parser_arg *arg);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (ce_parser_arg *arg)
#else
int
yyparse (arg)
    ce_parser_arg *arg;
#endif
#endif
{


    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 241 "ce_expr.yy"
    {
             DBG(cerr << "Mark all variables" << endl);
		     DDS(arg)->mark_all(true);
		     (yyval.boolean) = true;
		 ;}
    break;

  case 4:

/* Line 1455 of yacc.c  */
#line 249 "ce_expr.yy"
    { DDS(arg)->mark_all(true); ;}
    break;

  case 5:

/* Line 1455 of yacc.c  */
#line 250 "ce_expr.yy"
    { 
		     (yyval.boolean) = (yyvsp[(3) - (3)].boolean);
		 ;}
    break;

  case 6:

/* Line 1455 of yacc.c  */
#line 254 "ce_expr.yy"
    {
		     (yyval.boolean) = (yyvsp[(1) - (3)].boolean) && (yyvsp[(3) - (3)].boolean);
		 ;}
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 261 "ce_expr.yy"
    {
		     (yyval.boolean) = (yyvsp[(1) - (3)].boolean) && (yyvsp[(3) - (3)].boolean);
		 ;}
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 267 "ce_expr.yy"
    {
		     BaseType *var = DDS(arg)->var((yyvsp[(1) - (1)].id));
		     if (var) {
			     DBG(cerr << "Marking " << (yyvsp[(1) - (1)].id) << endl);
			     (yyval.boolean) = DDS(arg)->mark((yyvsp[(1) - (1)].id), true);
			     DBG(cerr << "result: " << (yyval.boolean) << endl);
		     }
		     else {
			     no_such_ident(arg, (yyvsp[(1) - (1)].id), "identifier");
		     }
		;}
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 279 "ce_expr.yy"
    {
		    (yyval.boolean) = (yyvsp[(1) - (1)].boolean);
		;}
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 283 "ce_expr.yy"
    {
		    (yyval.boolean) = (yyvsp[(1) - (1)].boolean);
		;}
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 287 "ce_expr.yy"
    {
            Array *array = dynamic_cast<Array*>((yyvsp[(1) - (1)].rval_ptr)->bvalue(*DDS(arg)));
            if (array) { 
                /* When the special form appears here (not as a function argument)
                set send_p so the data will be sent and add it to the DDS. This 
                streamlines testing (and is likely what is intended). */
                
                array->set_send_p(true);
                DDS(arg)->add_var_nocopy(array);
                
                return true;
            }
            else {
                ce_exprerror(arg, "Could not create the anonymous vector using the # special form");
                return false;
            }
        ;}
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 311 "ce_expr.yy"
    {
            (yyval.rval_ptr) = build_constant_array<dods_byte, Byte>((yyvsp[(5) - (6)].byte_values), DDS(arg));
        ;}
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 317 "ce_expr.yy"
    {
            (yyval.rval_ptr) = build_constant_array<dods_int16, Int16>((yyvsp[(5) - (6)].int16_values), DDS(arg));
        ;}
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 323 "ce_expr.yy"
    {
            (yyval.rval_ptr) = build_constant_array<dods_uint16, UInt16>((yyvsp[(5) - (6)].uint16_values), DDS(arg));
        ;}
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 329 "ce_expr.yy"
    {
            (yyval.rval_ptr) = build_constant_array<dods_int32, Int32>((yyvsp[(5) - (6)].int32_values), DDS(arg));
        ;}
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 335 "ce_expr.yy"
    {
            (yyval.rval_ptr) = build_constant_array<dods_uint32, UInt32>((yyvsp[(5) - (6)].uint32_values), DDS(arg));
        ;}
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 341 "ce_expr.yy"
    {
            (yyval.rval_ptr) = build_constant_array<dods_float32, Float32>((yyvsp[(5) - (6)].float32_values), DDS(arg));
        ;}
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 347 "ce_expr.yy"
    {
            (yyval.rval_ptr) = build_constant_array<dods_float64, Float64>((yyvsp[(5) - (6)].float64_values), DDS(arg));
        ;}
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 356 "ce_expr.yy"
    {
              if (!check_int32((yyvsp[(1) - (1)].id)))
                  throw Error(malformed_expr, "#<type>(hint, value, ...) special form expected hint to be an integer");
                   
              arg_length_hint_value = atoi((yyvsp[(1) - (1)].id));
              (yyval.boolean) = true;
          ;}
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 367 "ce_expr.yy"
    {
              (yyval.byte_values) = make_fast_arg_list<byte_arg_list, dods_byte>(arg_length_hint_value, (yyvsp[(1) - (1)].byte_value));
          ;}
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 371 "ce_expr.yy"
    {
              (yyval.byte_values) = make_fast_arg_list<byte_arg_list, dods_byte>((yyvsp[(1) - (3)].byte_values), (yyvsp[(3) - (3)].byte_value));
          ;}
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 378 "ce_expr.yy"
    {
              (yyval.byte_value) = strtol((yyvsp[(1) - (1)].id), 0, 0);
          ;}
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 385 "ce_expr.yy"
    {
              (yyval.int16_values) = make_fast_arg_list<int16_arg_list, dods_int16>(arg_length_hint_value, (yyvsp[(1) - (1)].int16_value));
          ;}
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 389 "ce_expr.yy"
    {
              (yyval.int16_values) = make_fast_arg_list<int16_arg_list, dods_int16>((yyvsp[(1) - (3)].int16_values), (yyvsp[(3) - (3)].int16_value));
          ;}
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 396 "ce_expr.yy"
    {
              (yyval.int16_value) = strtol((yyvsp[(1) - (1)].id), 0, 0);
          ;}
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 403 "ce_expr.yy"
    {
              (yyval.uint16_values) = make_fast_arg_list<uint16_arg_list, dods_uint16>(arg_length_hint_value, (yyvsp[(1) - (1)].uint16_value));
          ;}
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 407 "ce_expr.yy"
    {
              (yyval.uint16_values) = make_fast_arg_list<uint16_arg_list, dods_uint16>((yyvsp[(1) - (3)].uint16_values), (yyvsp[(3) - (3)].uint16_value));
          ;}
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 414 "ce_expr.yy"
    {
              (yyval.uint16_value) = strtoul((yyvsp[(1) - (1)].id), 0, 0);
          ;}
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 421 "ce_expr.yy"
    {
              (yyval.int32_values) = make_fast_arg_list<int32_arg_list, dods_int32>(arg_length_hint_value, (yyvsp[(1) - (1)].int32_value));
          ;}
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 425 "ce_expr.yy"
    {
              (yyval.int32_values) = make_fast_arg_list<int32_arg_list, dods_int32>((yyvsp[(1) - (3)].int32_values), (yyvsp[(3) - (3)].int32_value));
          ;}
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 432 "ce_expr.yy"
    {
              (yyval.int32_value) = strtol((yyvsp[(1) - (1)].id), 0, 0);
          ;}
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 439 "ce_expr.yy"
    {
              (yyval.uint32_values) = make_fast_arg_list<uint32_arg_list, dods_uint32>(arg_length_hint_value, (yyvsp[(1) - (1)].uint32_value));
          ;}
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 443 "ce_expr.yy"
    {
              (yyval.uint32_values) = make_fast_arg_list<uint32_arg_list, dods_uint32>((yyvsp[(1) - (3)].uint32_values), (yyvsp[(3) - (3)].uint32_value));
          ;}
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 450 "ce_expr.yy"
    {
              (yyval.uint32_value) = strtoul((yyvsp[(1) - (1)].id), 0, 0);
          ;}
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 457 "ce_expr.yy"
    {
              (yyval.float32_values) = make_fast_arg_list<float32_arg_list, dods_float32>(arg_length_hint_value, (yyvsp[(1) - (1)].float32_value));
          ;}
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 461 "ce_expr.yy"
    {
              (yyval.float32_values) = make_fast_arg_list<float32_arg_list, dods_float32>((yyvsp[(1) - (3)].float32_values), (yyvsp[(3) - (3)].float32_value));
          ;}
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 468 "ce_expr.yy"
    {
              (yyval.float32_value) = strtof((yyvsp[(1) - (1)].id), 0);
          ;}
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 475 "ce_expr.yy"
    {
              (yyval.float64_values) = make_fast_arg_list<float64_arg_list, dods_float64>(arg_length_hint_value, (yyvsp[(1) - (1)].float64_value));
          ;}
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 479 "ce_expr.yy"
    {
              (yyval.float64_values) = make_fast_arg_list<float64_arg_list, dods_float64>((yyvsp[(1) - (3)].float64_values), (yyvsp[(3) - (3)].float64_value));
          ;}
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 486 "ce_expr.yy"
    {
              (yyval.float64_value) = strtod((yyvsp[(1) - (1)].id), 0);
          ;}
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 493 "ce_expr.yy"
    {
		    proj_func p_f = 0;
		    btp_func f = 0;

		    if ((f = get_btp_function(*(EVALUATOR(arg)), (yyvsp[(1) - (4)].id)))) {
			    EVALUATOR(arg)->append_clause(f, (yyvsp[(3) - (4)].r_val_l_ptr));
			    (yyval.boolean) = true;
		    }
		    else if ((p_f = get_proj_function(*(EVALUATOR(arg)), (yyvsp[(1) - (4)].id)))) { 
		        DDS &dds = dynamic_cast<DDS&>(*(DDS(arg)));
			    BaseType **args = build_btp_args( (yyvsp[(3) - (4)].r_val_l_ptr), dds );
			    (*p_f)(((yyvsp[(3) - (4)].r_val_l_ptr)) ? (yyvsp[(3) - (4)].r_val_l_ptr)->size():0, args, dds, *(EVALUATOR(arg)));
			    delete[] args;
			    (yyval.boolean) = true;
		    }
		    else {
			    no_such_func(arg, (yyvsp[(1) - (4)].id));
		    }
		;}
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 516 "ce_expr.yy"
    {
		    (yyval.boolean) = (yyvsp[(1) - (3)].boolean) && (yyvsp[(3) - (3)].boolean);
		;}
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 522 "ce_expr.yy"
    {
		    if ((yyvsp[(1) - (5)].rval_ptr)) {
			EVALUATOR(arg)->append_clause((yyvsp[(2) - (5)].op), (yyvsp[(1) - (5)].rval_ptr), (yyvsp[(4) - (5)].r_val_l_ptr));
			(yyval.boolean) = true;
		    }
		    else
			(yyval.boolean) = false;
		;}
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 531 "ce_expr.yy"
    {
		    if ((yyvsp[(1) - (3)].rval_ptr)) {
			rvalue_list *rv = new rvalue_list;
			rv->push_back((yyvsp[(3) - (3)].rval_ptr));
			EVALUATOR(arg)->append_clause((yyvsp[(2) - (3)].op), (yyvsp[(1) - (3)].rval_ptr), rv);
			(yyval.boolean) = true;
		    }
		    else
			(yyval.boolean) = false;
		;}
    break;

  case 47:

/* Line 1455 of yacc.c  */
#line 542 "ce_expr.yy"
    {
		    (yyval.boolean) = (yyvsp[(1) - (1)].boolean);
		;}
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 549 "ce_expr.yy"
    {
		   bool_func b_func = get_function((*EVALUATOR(arg)), (yyvsp[(1) - (4)].id));
		   if (!b_func) {
		       no_such_func(arg, (yyvsp[(1) - (4)].id));
		   }
		   else {
		       EVALUATOR(arg)->append_clause(b_func, (yyvsp[(3) - (4)].r_val_l_ptr));
		       (yyval.boolean) = true;
		   }
	       ;}
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 564 "ce_expr.yy"
    {
		    btp_func func = get_btp_function((*EVALUATOR(arg)), (yyvsp[(1) - (4)].id));
		    if (func) {
			    (yyval.rval_ptr) = new rvalue(func, (yyvsp[(3) - (4)].r_val_l_ptr));
		    } 
		    else { 
			    no_such_func(arg, (yyvsp[(1) - (4)].id));
		    }
		;}
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 574 "ce_expr.yy"
    {
            (yyval.rval_ptr) = (yyvsp[(1) - (1)].rval_ptr);
        ;}
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 580 "ce_expr.yy"
    {
		    if ((yyvsp[(1) - (1)].rval_ptr))
			    (yyval.r_val_l_ptr) = make_rvalue_list((yyvsp[(1) - (1)].rval_ptr));
		    else
			    (yyval.r_val_l_ptr) = 0;
		;}
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 587 "ce_expr.yy"
    {
		    if ((yyvsp[(1) - (3)].r_val_l_ptr) && (yyvsp[(3) - (3)].rval_ptr))
			    (yyval.r_val_l_ptr) = append_rvalue_list((yyvsp[(1) - (3)].r_val_l_ptr), (yyvsp[(3) - (3)].rval_ptr));
		    else
			    (yyval.r_val_l_ptr) = 0;
		;}
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 596 "ce_expr.yy"
    {  
		      (yyval.r_val_l_ptr) = (yyvsp[(1) - (1)].r_val_l_ptr);
	      ;}
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 600 "ce_expr.yy"
    { 
		      (yyval.r_val_l_ptr) = 0; 
	      ;}
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 606 "ce_expr.yy"
    { 
		    BaseType *btp = DDS(arg)->var(www2id((yyvsp[(1) - (1)].id)));
		    if (btp) {
                btp->set_in_selection(true);
                (yyval.rval_ptr) = new rvalue(btp);
		    }
		    else {
			    value new_val;
			    if (check_int32((yyvsp[(1) - (1)].id))) {
			        new_val.type = dods_int32_c;
			        new_val.v.i = atoi((yyvsp[(1) - (1)].id));
			    }
			    else if (check_uint32((yyvsp[(1) - (1)].id))) {
			        new_val.type = dods_uint32_c;
			        new_val.v.ui = atoi((yyvsp[(1) - (1)].id));
			    }
			    else if (check_float64((yyvsp[(1) - (1)].id))) {
			        new_val.type = dods_float64_c;
			        new_val.v.f = atof((yyvsp[(1) - (1)].id));
			    }
			    else {
			        new_val.type = dods_str_c;
			        new_val.v.s = new string(www2id((yyvsp[(1) - (1)].id)));
			    }
			    BaseType *btp = make_variable((*EVALUATOR(arg)), new_val);
			    (yyval.rval_ptr) = new rvalue(btp);
		    }
		;}
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 635 "ce_expr.yy"
    {
                    if ((yyvsp[(1) - (1)].val).type != dods_str_c || (yyvsp[(1) - (1)].val).v.s == 0 || (yyvsp[(1) - (1)].val).v.s->empty())
                        ce_exprerror(arg, "Malformed string", "");
                        
                    BaseType *var = DDS(arg)->var(www2id(*((yyvsp[(1) - (1)].val).v.s)));
                    if (var) {
                        (yyval.rval_ptr) = new rvalue(var);
                    }
                    else {
                        var = make_variable((*EVALUATOR(arg)), (yyvsp[(1) - (1)].val)); 
                        (yyval.rval_ptr) = new rvalue(var);
                    }
                ;}
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 651 "ce_expr.yy"
    {
                    (yyval.boolean) = (*DDS(arg)).mark((yyvsp[(1) - (1)].id), true);
                ;}
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 656 "ce_expr.yy"
    {
                    //string name = www2id($1);
                    if (!bracket_projection((*DDS(arg)), (yyvsp[(1) - (2)].id), (yyvsp[(2) - (2)].int_ll_ptr)))
                      no_such_ident(arg, (yyvsp[(1) - (2)].id), "array, grid or sequence");
                    
                    strncpy((yyval.id), (yyvsp[(1) - (2)].id), ID_MAX-1);
                    (yyval.id)[ID_MAX-1] = '\0';
                ;}
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 665 "ce_expr.yy"
    {
                    string name = string((yyvsp[(1) - (2)].id)) + string((yyvsp[(2) - (2)].id));
                    strncpy((yyval.id), name.c_str(), ID_MAX-1);
                    (yyval.id)[ID_MAX-1] = '\0';
                ;}
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 671 "ce_expr.yy"
    {
                    string name = string((yyvsp[(1) - (3)].id)) + string((yyvsp[(2) - (3)].id));
                    if (!bracket_projection((*DDS(arg)), name.c_str(), (yyvsp[(3) - (3)].int_ll_ptr)))
                      no_such_ident(arg, name.c_str(), "array, grid or sequence");

                    strncpy((yyval.id), name.c_str(), ID_MAX-1);
                    (yyval.id)[ID_MAX-1] = '\0';
                ;}
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 682 "ce_expr.yy"
    { 
                    strncpy((yyval.id), www2id((yyvsp[(1) - (1)].id)).c_str(), ID_MAX-1);
                    (yyval.id)[ID_MAX-1] = '\0';
                ;}
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 687 "ce_expr.yy"
    {
                    if ((yyvsp[(1) - (1)].val).type != dods_str_c || (yyvsp[(1) - (1)].val).v.s == 0 || (yyvsp[(1) - (1)].val).v.s->empty())
                        ce_exprerror(arg, "Malformed string", "");
                        
                    strncpy((yyval.id), www2id(*((yyvsp[(1) - (1)].val).v.s)).c_str(), ID_MAX-1);
                    
                    (yyval.id)[ID_MAX-1] = '\0';
                ;}
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 698 "ce_expr.yy"
    {
		    (yyval.int_ll_ptr) = make_array_indices((yyvsp[(1) - (1)].int_l_ptr));
		;}
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 702 "ce_expr.yy"
    {
		    (yyval.int_ll_ptr) = append_array_index((yyvsp[(1) - (2)].int_ll_ptr), (yyvsp[(2) - (2)].int_l_ptr));
		;}
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 714 "ce_expr.yy"
    {
    if (!check_uint32((yyvsp[(2) - (3)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(2) - (3)].id)) + "' is not a valid array index.");
    value i;
    i.type = dods_uint32_c;
    i.v.i = atoi((yyvsp[(2) - (3)].id));
    (yyval.int_l_ptr) = make_array_index(i);
;}
    break;

  case 67:

/* Line 1455 of yacc.c  */
#line 723 "ce_expr.yy"
    {
    value i;
    i.type = dods_int32_c;
    i.v.i =-1;
    (yyval.int_l_ptr) = make_array_index(i);
;}
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 730 "ce_expr.yy"
    {
    if (!check_uint32((yyvsp[(2) - (5)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(2) - (5)].id)) + "' is not a valid array index.");
    if (!check_uint32((yyvsp[(4) - (5)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(4) - (5)].id)) + "' is not a valid array index.");
    value i,j;
    i.type = j.type = dods_uint32_c;
    i.v.i = atoi((yyvsp[(2) - (5)].id));
    j.v.i = atoi((yyvsp[(4) - (5)].id));
    (yyval.int_l_ptr) = make_array_index(i, j);
;}
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 742 "ce_expr.yy"
    {
    if (!check_uint32((yyvsp[(2) - (5)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(2) - (5)].id)) + "' is not a valid array index.");
    value i,j;
    i.type = dods_uint32_c;
    j.type = dods_int32_c;  /* signed */
    i.v.i = atoi((yyvsp[(2) - (5)].id));
    j.v.i = -1;
    (yyval.int_l_ptr) = make_array_index(i, j);
;}
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 753 "ce_expr.yy"
    {
    if (!check_uint32((yyvsp[(2) - (7)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(2) - (7)].id)) + "' is not a valid array index.");
    if (!check_uint32((yyvsp[(4) - (7)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(4) - (7)].id)) + "' is not a valid array index.");
    if (!check_uint32((yyvsp[(6) - (7)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(6) - (7)].id)) + "' is not a valid array index.");
    value i, j, k;
    i.type = j.type = k.type = dods_uint32_c;
    i.v.i = atoi((yyvsp[(2) - (7)].id));
    j.v.i = atoi((yyvsp[(4) - (7)].id));
    k.v.i = atoi((yyvsp[(6) - (7)].id));
    (yyval.int_l_ptr) = make_array_index(i, j, k);
;}
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 768 "ce_expr.yy"
    {
    if (!check_uint32((yyvsp[(2) - (7)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(2) - (7)].id)) + "' is not a valid array index.");
    if (!check_uint32((yyvsp[(4) - (7)].id)))
        throw Error(malformed_expr, "The word `" + string((yyvsp[(4) - (7)].id)) + "' is not a valid array index.");
    value i, j, k;
    i.type = j.type = dods_uint32_c;
    k.type = dods_int32_c;
    i.v.i = atoi((yyvsp[(2) - (7)].id));
    j.v.i = atoi((yyvsp[(4) - (7)].id));
    k.v.i = -1;
    (yyval.int_l_ptr) = make_array_index(i, j, k);
;}
    break;



/* Line 1455 of yacc.c  */
#line 2395 "ce_expr.tab.cc"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (arg, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (arg, yymsg);
	  }
	else
	  {
	    yyerror (arg, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, arg);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, arg);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (arg, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, arg);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, arg);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 792 "ce_expr.yy"


// All these error reporting function now throw instances of Error. The expr
// parser no longer returns an error code to indicate and error. 2/16/2000
// jhrg.

void
ce_exprerror(ce_parser_arg *, const string &s)
{
    //ce_exprerror(s.c_str());
    string msg = "Constraint expression parse error: " + (string) s;
    throw Error(malformed_expr, msg);
}

void ce_exprerror(ce_parser_arg *, const string &s, const string &s2)
{
    //ce_exprerror(s.c_str(), s2.c_str());
    string msg = "Constraint expression parse error: " + (string) s + ": " + (string) s2;
    throw Error(malformed_expr, msg);    
}

void no_such_ident(ce_parser_arg *arg, const string &name, const string &word)
{
    string msg = "No such " + word + " in dataset";
    ce_exprerror(arg, msg /*.c_str()*/, name);
}

void no_such_func(ce_parser_arg *arg, const string &name)
{
    ce_exprerror(arg, "Not a registered function", name);
    //no_such_func(name/*.c_str()*/);
}

/* If we're calling this, assume var is not a Sequence. But assume that the
 name contains a dot and it's a separator. Look for the rightmost dot and
 then look to see if the name to the left is a sequence. Return a pointer
 to the sequence if it is otherwise return null. Uses tail-recursion to
 'walk' back from right to left looking at each dot. This way the sequence
 will be found even if there are structures between the field and the
 Sequence. */
static Sequence *
parent_is_sequence(DDS &table, const string &n)
{
    string::size_type dotpos = n.find_last_of('.');
    if (dotpos == string::npos)
        return 0;

    string s = n.substr(0, dotpos);

    // If the thing returned by table.var is not a Sequence, this cast
    // will yield null.
    Sequence *seq = dynamic_cast<Sequence*> (table.var(s));
    if (seq)
        return seq;
    else
        return parent_is_sequence(table, s);
}

bool bracket_projection(DDS &table, const char *name, int_list_list *indices)
{
    BaseType *var = table.var(name);
    Sequence *seq; // used in last else-if clause
#if 0
    Array *array;
#endif    
    if (!var)
        return false;

    if (is_array_t(var)) {
        /* calls to set_send_p should be replaced with
         calls to DDS::mark so that arrays of Structures,
         etc. will be processed correctly when individual
         elements are projected using short names.
         9/1/98 jhrg */
        /* var->set_send_p(true); */
        //table.mark(name, true);
        // We don't call mark() here for an array. Instead it is called from
        // within the parser. jhrg 10/10/08
        process_array_indices(var, indices); // throws on error
        delete_array_indices(indices);
    }
    else if (is_grid_t(var)) {
        process_grid_indices(var, indices);
        table.mark(name, true);
        delete_array_indices(indices);
    }
    else if (is_sequence_t(var)) {
        table.mark(name, true);
        process_sequence_indices(var, indices);
        delete_array_indices(indices);
    }
    else if ((seq = parent_is_sequence(table, name))) {
        process_sequence_indices(seq, indices);
        table.mark(name, true);
        delete_array_indices(indices);
    }
    else {
        return false;
    }

    return true;
}

// Given three values (I1, I2, I3), all of which must be integers, build an
// int_list which contains those values.
// 
// Note that we added support for * in the rightmost position of an index
// (i.e., [*], [n:*], [n:m:*]) and indicate that star using -1 as an index value.
// Bescause of this change, the test for the type of the rightmost value in
// the index subexpr was changed to include signed int.
// jhrg 12/20/12
//
// Returns: A pointer to an int_list of three integers or NULL if any of the
// values are not integers.

int_list *
make_array_index(value &i1, value &i2, value &i3)
{
    if (i1.type != dods_uint32_c || i2.type != dods_uint32_c || (i3.type != dods_uint32_c && i3.type != dods_int32_c))
        return (int_list *) 0;

    int_list *index = new int_list;

    index->push_back((int) i1.v.i);
    index->push_back((int) i2.v.i);
    index->push_back((int) i3.v.i);

    DBG(cout << "index: ");
    DBG(copy(index->begin(), index->end(), ostream_iterator<int>(cerr, " ")));
    DBG(cerr << endl);

    return index;
}

int_list *
make_array_index(value &i1, value &i2)
{
    if (i1.type != dods_uint32_c || (i2.type != dods_uint32_c && i2.type != dods_int32_c))
	return (int_list *) 0;

    int_list *index = new int_list;

    index->push_back((int) i1.v.i);
    index->push_back(1);
    index->push_back((int) i2.v.i);

    DBG(cout << "index: ");
    DBG(copy(index->begin(), index->end(), ostream_iterator<int>(cerr, " ")));
    DBG(cerr << endl);

    return index;
}

int_list *
make_array_index(value &i1)
{
    if (i1.type != dods_uint32_c && i1.type != dods_int32_c)
	return (int_list *) 0;

    int_list *index = new int_list;

    // When the CE is Array[*] that means all of the elements, but the value
    // of i1 will be -1. Make the projection triple be 0:1:-1 which is a 
    // pattern that libdap::Array will recognize.
    if (i1.v.i == -1)
        index->push_back(0);
    else
        index->push_back((int) i1.v.i);
    index->push_back(1);
    index->push_back((int) i1.v.i);

    DBG(cout << "index: ");
    DBG(copy(index->begin(), index->end(), ostream_iterator<int>(cerr, " ")));
    DBG(cerr << endl);

    return index;
}

int_list_list *
make_array_indices(int_list *index)
{
    int_list_list *indices = new int_list_list;

    DBG(cout << "index: ");
    DBG(copy(index->begin(), index->end(), ostream_iterator<int>(cerr, " ")));
    DBG(cerr << endl);

    assert(index);
    indices->push_back(index);

    return indices;
}

int_list_list *
append_array_index(int_list_list *indices, int_list *index)
{
    assert(indices);
    assert(index);

    indices->push_back(index);

    return indices;
}

// Delete an array indices list. 

void delete_array_indices(int_list_list *indices)
{
    assert(indices);

    for (int_list_citer i = indices->begin(); i != indices->end(); i++) {
	int_list *il = *i;
	assert(il);
	delete il;
    }

    delete indices;
}

bool is_array_t(BaseType *variable)
{
    assert(variable);

    if (variable->type() != dods_array_c)
	return false;
    else
	return true;
}

bool is_grid_t(BaseType *variable)
{
    assert(variable);

    if (variable->type() != dods_grid_c)
	return false;
    else
	return true;
}

bool is_sequence_t(BaseType *variable)
{
    assert(variable);

    if (variable->type() != dods_sequence_c)
	return false;
    else
	return true;
}

void process_array_indices(BaseType *variable, int_list_list *indices)
{
    assert(variable);

    Array *a = dynamic_cast<Array *>(variable); // replace with dynamic cast
    if (!a)
        throw Error(malformed_expr,
		    string("The constraint expression evaluator expected an array; ") + variable->name() + " is not an array.");

    if (a->dimensions(true) != (unsigned) indices->size())
        throw Error(malformed_expr,
		    string("Error: The number of dimensions in the constraint for ") + variable->name()
                    + " must match the number in the array.");

    DBG(cerr << "Before applying projection to array:" << endl);
    DBG(a->print_decl(cerr, "", true, false, true));

    assert(indices);
    
    int_list_citer p = indices->begin();
    Array::Dim_iter r = a->dim_begin();
    for (; p != indices->end() && r != a->dim_end(); p++, r++) {
        int_list *index = *p;
        assert(index);

        int_citer q = index->begin();
        assert(q != index->end());
        int start = *q;

        q++;
        int stride = *q;

        q++;
        int stop = *q;

        q++;
        if (q != index->end())
            throw Error(malformed_expr, string("Too many values in index list for ") + a->name() + ".");

        DBG(cerr << "process_array_indices: Setting constraint on " 
            << a->name() << "[" << start << ":" << stop << "]"
            << endl);

        // It's possible that an array will appear more than once in a CE
        // (for example, if an array of structures is constrained so that
        // only two fields are projected and there's an associated hyperslab).
        // However, in this case the two hyperslabs must be equal; test for
        // that here.
        //
        // We added '*' to mean 'the last element' in the array and use an index of -1
        // to indicate that. If 'stop' is -1, don't test it here because dimension_stop()
        // won't be -1 but the actual ending index of the array. jhrg 12/20/12

        if (a->send_p() && (a->dimension_start(r, true) != start || (a->dimension_stop(r, true) != stop && stop != -1)
                            || a->dimension_stride(r, true) != stride))
            throw Error(malformed_expr,
                    string("The Array was already projected differently in the constraint expression: ") + a->name() + ".");

        a->add_constraint(r, start, stride, stop);

        DBG(cerr << "Set Constraint: " << a->dimension_size(r, true) << endl);
    }

    DBG(cerr << "After applying projection to array:" << endl);
    DBG(a->print_decl(cerr, "", true, false, true));


    if (p != indices->end() && r == a->dim_end())
        throw Error(malformed_expr, string("Too many indices in constraint for ") + a->name() + ".");
}

void process_grid_indices(BaseType *variable, int_list_list *indices)
{
    assert(variable);
    assert(variable->type() == dods_grid_c);
    Grid *g = dynamic_cast<Grid *>(variable);
    if (!g)
        throw Error(unknown_error, "Expected a Grid variable");

    Array *a = g->get_array();

    if (a->dimensions(true) != (unsigned) indices->size())
        throw Error(malformed_expr,
		    string("Error: The number of dimensions in the constraint for ") + variable->name()
		    + " must match the number in the grid.");

    // First do the constraints on the ARRAY in the grid.
    process_array_indices(g->array_var(), indices);

    // Now process the maps.
    Grid::Map_iter r = g->map_begin();

    // Suppress all maps by default.
    for (; r != g->map_end(); r++) {
        (*r)->set_send_p(false);
    }

    // Add specified maps to the current projection.
    assert(indices);
    int_list_citer p = indices->begin();
    r = g->map_begin();
    for (; p != indices->end() && r != g->map_end(); p++, r++) {
        int_list *index = *p;
        assert(index);

        int_citer q = index->begin();
        assert(q != index->end());
        int start = *q;

        q++;
        int stride = *q;

        q++;
        int stop = *q;

        BaseType *btp = *r;
        assert(btp);
        assert(btp->type() == dods_array_c);
        Array *a = (Array *) btp;
        a->set_send_p(true);
        a->reset_constraint();

        q++;
        if (q != index->end()) {
            throw Error(malformed_expr, string("Too many values in index list for ") + a->name() + ".");
        }

        DBG(cerr << "process_grid_indices: Setting constraint on "
            << a->name() << "[" << start << ":"
            << stop << "]" << endl);
    
        Array::Dim_iter si = a->dim_begin();
        a->add_constraint(si, start, stride, stop);

    }

    DBG(cout << "Grid Constraint: ";
	for (Array::Dim_iter dp = ((Array *) g->array_var())->dim_begin();
	     dp != ((Array *) g->array_var())->dim_end(); dp++)
	    cout << ((Array *) g->array_var())->dimension_size(dp, true) << " ";
	    cout << endl
	);

    if (p != indices->end() && r == g->map_end()) {
        throw Error(malformed_expr,
		    string("Too many indices in constraint for ") + (*r)->name() + ".");
    }
}

void process_sequence_indices(BaseType *variable, int_list_list *indices)
{
    assert(variable);
    assert(variable->type() == dods_sequence_c);
    Sequence *s = dynamic_cast<Sequence *> (variable);
    if (!s)
        throw Error(malformed_expr, "Expected a Sequence variable");

    // Add specified maps to the current projection.
    assert(indices);
    for (int_list_citer p = indices->begin(); p != indices->end(); p++) {
        int_list *index = *p;
        assert(index);

        int_citer q = index->begin();
        assert(q != index->end());
        int start = *q;

        q++;
        int stride = *q;

        q++;
        int stop = *q;

        q++;
        if (q != index->end()) {
            throw Error(malformed_expr, string("Too many values in index list for ") + s->name() + ".");
        }

        s->set_row_number_constraint(start, stop, stride);
    }
}

// Given a value, wrap it up in a BaseType and return a pointer to the same.

BaseType *
make_variable(ConstraintEvaluator &eval, const value &val)
{
    BaseType *var;
    switch (val.type) {
    case dods_int32_c: {
        var = new Int32("dummy");
        var->val2buf((void *) &val.v.i);
        break;
    }

    case dods_uint32_c: {
        var = new UInt32("dummy");
        var->val2buf((void *) &val.v.i);
        break;
    }

    case dods_float64_c: {
        var = new Float64("dummy");
        var->val2buf((void *) &val.v.f);
        break;
    }

    case dods_str_c: {
        var = new Str("dummy");
        var->val2buf((void *) val.v.s);
        break;
    }

    default:
        var = (BaseType *) 0;
        return var;
    }

    var->set_read_p(true); // ...so the evaluator will know it has data
    eval.append_constant(var);

    return var;
}

// Given a string (passed in VAL), consult the DDS CE function lookup table
// to see if a function by that name exists. 
// NB: function arguments are type-checked at run-time.
//
// Returns: A pointer to the function or NULL if not such function exists.

bool_func get_function(const ConstraintEvaluator &eval, const char *name)
{
    bool_func f;

    if (eval.find_function(name, &f))
        return f;
    else
        return 0;
}

btp_func get_btp_function(const ConstraintEvaluator &eval, const char *name)
{
    btp_func f;

    if (eval.find_function(name, &f))
        return f;
    else
        return 0;
}

proj_func get_proj_function(const ConstraintEvaluator &eval, const char *name)
{
    proj_func f;

    if (eval.find_function(name, &f))
        return f;
    else
        return 0;
}

template<class arg_type_list, class arg_type>
arg_type_list
make_fast_arg_list(unsigned long vector_size_hint, arg_type value)
{
    arg_type_list args = new std::vector<arg_type>;
    
    if (vector_size_hint > 0) args->reserve(vector_size_hint);
    
    args->push_back(value);
    return args;
}

template<class arg_type_list, class arg_type>
arg_type_list
make_fast_arg_list(arg_type_list values, arg_type value)
{
    values->push_back(value);
    return values;
}

template<class t, class T>
rvalue *build_constant_array(vector<t> *values, DDS *dds)
{
    //vector<t> *values = $5;
            
    T i("");
    Array *array = new Array("", &i);
    array->append_dim(values->size());
    
    // TODO Make set_value_nocopy() methods so that values' pointers can be copied
    // instead of allocating memory twice. jhrg 7/5/13
            
    array->set_value(*values, values->size());
    delete values;
    array->set_read_p(true);
            
    static unsigned long counter = 1;
    string name;
    do {
        name = "g" + long_to_string(counter++);
    } while (dds->var(name));
    array->set_name(name);
            
    return new rvalue(array);
}


