/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.actions;

import de.rub.nds.modifiablevariable.util.Modifiable;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EarlyCcsAction
extends TlsAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Boolean targetOpenssl1_0_0;
    private boolean executedAsPlanned = false;

    public EarlyCcsAction(Boolean targetsOpenssl1_0_0) {
        this.targetOpenssl1_0_0 = targetsOpenssl1_0_0;
    }

    @Override
    public void execute(State state) {
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(state.getConfig());
        ClientKeyExchangeMessage message = factory.createClientKeyExchangeMessage(AlgorithmResolver.getKeyExchangeAlgorithm(state.getTlsContext().getChooser().getSelectedCipherSuite()));
        if (!this.targetOpenssl1_0_0.booleanValue()) {
            message.setIncludeInDigest(Modifiable.explicit((Boolean)false));
        }
        message.setAdjustContext(Modifiable.explicit((Boolean)false));
        ClientKeyExchangeHandler handler = (ClientKeyExchangeHandler)message.getHandler(state.getTlsContext());
        byte[] protocolMessageBytes = handler.prepareMessage(message);
        if (this.targetOpenssl1_0_0.booleanValue()) {
            handler.adjustPremasterSecret(message);
            handler.adjustMasterSecret(message);
        }
        handler.adjustTlsContextAfterSerialize(message);
        LinkedList<AbstractRecord> recordList = new LinkedList<AbstractRecord>();
        Record r = new Record();
        r.setContentMessageType(ProtocolMessageType.HANDSHAKE);
        recordList.add(r);
        byte[] prepareRecords = state.getTlsContext().getRecordLayer().prepareRecords(protocolMessageBytes, ProtocolMessageType.HANDSHAKE, recordList);
        try {
            state.getTlsContext().getTransportHandler().sendData(prepareRecords);
            this.executedAsPlanned = true;
        }
        catch (IOException E) {
            LOGGER.debug("Could not write Data to stream", (Throwable)E);
            this.executedAsPlanned = false;
        }
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.executedAsPlanned = false;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.executedAsPlanned;
    }
}

