/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.modifiablevariable.util.BadRandom;
import de.rub.nds.tlsattacker.core.util.ConnectionHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicTlsServer
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private String[] cipherSuites = null;
    private final int port;
    private final SSLContext sslContext;
    private ServerSocket serverSocket;
    private boolean shutdown;
    boolean closed = true;
    private volatile boolean initialized;

    public BasicTlsServer(KeyStore keyStore, String password, String protocol, int port) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        this.port = port;
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, password.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        this.sslContext = SSLContext.getInstance(protocol);
        this.sslContext.init(keyManagers, trustManagers, (SecureRandom)new BadRandom());
        this.cipherSuites = this.sslContext.getServerSocketFactory().getSupportedCipherSuites();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Provider: " + this.sslContext.getProvider());
            LOGGER.debug("Supported cipher suites (" + this.sslContext.getServerSocketFactory().getSupportedCipherSuites().length + ")");
            for (String c : this.sslContext.getServerSocketFactory().getSupportedCipherSuites()) {
                LOGGER.debug(" " + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.preSetup();
            this.closed = false;
            while (!this.shutdown) {
                try {
                    LOGGER.info("Listening on port " + this.port + "...\n");
                    Socket socket = this.serverSocket.accept();
                    if (socket == null) continue;
                    ConnectionHandler ch = new ConnectionHandler(socket);
                    Thread t = new Thread(ch);
                    t.start();
                }
                catch (IOException ex) {
                    LOGGER.debug(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            this.closed = true;
        }
        catch (IOException ex) {
            LOGGER.debug(ex.getLocalizedMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                    this.serverSocket = null;
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
            LOGGER.info("Shutdown complete");
        }
    }

    private void preSetup() throws SocketException, IOException {
        SSLServerSocketFactory serverSocketFactory = this.sslContext.getServerSocketFactory();
        this.serverSocket = serverSocketFactory.createServerSocket(this.port);
        this.serverSocket.setReuseAddress(true);
        LOGGER.debug("Presetup successful");
        this.initialized = true;
    }

    public void shutdown() {
        this.shutdown = true;
        LOGGER.debug("Shutdown signal received");
        try {
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.port;
    }
}

