/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PSKBinderPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PSKIdentityPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientHelloSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PSKBinderSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PSKIdentitySerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreSharedKeyExtensionPreparator
extends ExtensionPreparator<PreSharedKeyExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PreSharedKeyExtensionMessage msg;
    private ClientHelloMessage clientHello;

    public PreSharedKeyExtensionPreparator(Chooser chooser, PreSharedKeyExtensionMessage message, ExtensionSerializer<PreSharedKeyExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing PreSharedKeyExtensionMessage");
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.msg.getEntries(this.chooser);
            this.prepareLists();
            this.prepareIdentityListBytes();
            this.prepareBinderListBytes();
        } else {
            this.prepareSelectedIdentity();
        }
    }

    private void prepareLists() {
        if (this.msg.getIdentities() != null) {
            for (PSKIdentity pskIdentity : this.msg.getIdentities()) {
                new PSKIdentityPreparator(this.chooser, pskIdentity).prepare();
            }
        }
        if (this.msg.getBinders() != null) {
            for (PSKBinder pskBinder : this.msg.getBinders()) {
                new PSKBinderPreparator(this.chooser, pskBinder).prepare();
            }
        }
    }

    private void prepareSelectedIdentity() {
        LOGGER.debug("Preparing selected identity");
        this.msg.setSelectedIdentity(this.chooser.getContext().getSelectedIdentityIndex());
    }

    private void prepareIdentityListBytes() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (PSKIdentity pskIdentity : this.msg.getIdentities()) {
            PSKIdentitySerializer serializer = new PSKIdentitySerializer(pskIdentity);
            try {
                outputStream.write(serializer.serialize());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not write byte[] from PSKIdentity", ex);
            }
        }
        this.msg.setIdentityListBytes(outputStream.toByteArray());
        this.msg.setIdentityListLength(((byte[])this.msg.getIdentityListBytes().getValue()).length);
    }

    private void prepareBinderListBytes() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (PSKBinder pskBinder : this.msg.getBinders()) {
            PSKBinderSerializer serializer = new PSKBinderSerializer(pskBinder);
            try {
                outputStream.write(serializer.serialize());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not write byte[] from PSKIdentity", ex);
            }
        }
        this.msg.setBinderListBytes(outputStream.toByteArray());
        this.msg.setBinderListLength(((byte[])this.msg.getBinderListBytes().getValue()).length);
    }

    @Override
    public void afterPrepareExtensionContent() {
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.prepareActualBinders();
        }
    }

    private void prepareActualBinders() {
        LOGGER.debug("Preparing binder values to replace dummy bytes");
        ClientHelloSerializer clientHelloSerializer = new ClientHelloSerializer(this.clientHello, this.chooser.getSelectedProtocolVersion());
        byte[] clientHelloBytes = clientHelloSerializer.serialize();
        byte[] relevantBytes = this.getRelevantBytes(clientHelloBytes);
        this.calculateBinders(relevantBytes, this.msg);
        this.prepareBinderListBytes();
    }

    private byte[] getRelevantBytes(byte[] clientHelloBytes) {
        int remainingBytes = clientHelloBytes.length - 2;
        for (PSKBinder pskBinder : this.msg.getBinders()) {
            remainingBytes = remainingBytes - 1 - (Integer)pskBinder.getBinderEntryLength().getValue();
        }
        byte[] relevantBytes = new byte[remainingBytes];
        System.arraycopy(clientHelloBytes, 0, relevantBytes, 0, remainingBytes);
        LOGGER.debug("Relevant Bytes:" + ArrayConverter.bytesToHexString((byte[])relevantBytes));
        return relevantBytes;
    }

    private void calculateBinders(byte[] relevantBytes, PreSharedKeyExtensionMessage msg) {
        List<PskSet> pskSets = this.chooser.getPskSets();
        LOGGER.debug("Calculating Binders");
        for (int x = 0; x < msg.getBinders().size(); ++x) {
            try {
                HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(pskSets.get(x).getCipherSuite());
                Mac mac = Mac.getInstance(hkdfAlgortihm.getMacAlgorithm().getJavaName());
                DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(ProtocolVersion.TLS13, pskSets.get(x).getCipherSuite());
                byte[] psk = pskSets.get(x).getPreSharedKey();
                byte[] earlySecret = HKDFunction.extract(hkdfAlgortihm, new byte[0], psk);
                byte[] binderKey = HKDFunction.deriveSecret(hkdfAlgortihm, digestAlgo.getJavaName(), earlySecret, "res binder", ArrayConverter.hexStringToByteArray((String)""));
                byte[] binderFinKey = HKDFunction.expandLabel(hkdfAlgortihm, binderKey, "finished", new byte[0], mac.getMacLength());
                this.chooser.getContext().getDigest().setRawBytes(relevantBytes);
                SecretKeySpec keySpec = new SecretKeySpec(binderFinKey, mac.getAlgorithm());
                mac.init(keySpec);
                mac.update(this.chooser.getContext().getDigest().digest(ProtocolVersion.TLS13, pskSets.get(x).getCipherSuite()));
                byte[] binderVal = mac.doFinal();
                this.chooser.getContext().getDigest().setRawBytes(new byte[0]);
                LOGGER.debug("Using PSK:" + ArrayConverter.bytesToHexString((byte[])psk));
                LOGGER.debug("Calculated Binder:" + ArrayConverter.bytesToHexString((byte[])binderVal));
                msg.getBinders().get(x).setBinderEntry(binderVal);
                if (x != 0) continue;
                this.chooser.getContext().setEarlyDataPsk(psk);
                continue;
            }
            catch (CryptoException | InvalidKeyException | NoSuchAlgorithmException ex) {
                throw new PreparationException("Could not calculate Binders", ex);
            }
        }
    }

    public ClientHelloMessage getClientHello() {
        return this.clientHello;
    }

    public void setClientHello(ClientHelloMessage clientHello) {
        this.clientHello = clientHello;
    }
}

