/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.apache.solr.common.SolrException;
import org.apache.solr.jersey.CatchAllExceptionMapper;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class NotFoundExceptionMapper
implements ExceptionMapper<NotFoundException> {
    @Context
    public ResourceContext resourceContext;

    public Response toResponse(NotFoundException exception) {
        ContainerRequestContext containerRequestContext = (ContainerRequestContext)this.resourceContext.getResource(ContainerRequestContext.class);
        if (containerRequestContext.getPropertyNames().contains("ERROR_IF_RESOURCE_NOT_FOUND")) {
            containerRequestContext.setProperty("RESOURCE_NOT_FOUND", (Object)"NOT_FOUND_VALUE");
            return null;
        }
        SolrQueryResponse solrQueryResponse = (SolrQueryResponse)containerRequestContext.getProperty(RequestContextKeys.SOLR_QUERY_RESPONSE);
        SolrQueryRequest solrQueryRequest = (SolrQueryRequest)containerRequestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        SolrException stashedException = new SolrException(SolrException.ErrorCode.NOT_FOUND, "Cannot find API for the path: " + solrQueryRequest.getContext().get("path"));
        solrQueryResponse.setException((Exception)((Object)stashedException));
        return CatchAllExceptionMapper.processAndRespondToException((Exception)((Object)stashedException), solrQueryRequest, containerRequestContext);
    }
}

