/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.prometheus.collector.MetricsCollectorFactory;
import org.apache.solr.prometheus.collector.SchedulerMetricsCollector;
import org.apache.solr.prometheus.exporter.CachedPrometheusCollector;
import org.apache.solr.prometheus.exporter.MetricsConfiguration;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.apache.solr.prometheus.exporter.SolrClientFactory;
import org.apache.solr.prometheus.exporter.SolrScrapeConfiguration;
import org.apache.solr.prometheus.scraper.SolrCloudScraper;
import org.apache.solr.prometheus.scraper.SolrScraper;
import org.apache.solr.prometheus.scraper.SolrStandaloneScraper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrExporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_PORT = 8989;
    private static final String DEFAULT_BASE_URL = "http://localhost:8983/solr";
    private static final String DEFAULT_ZK_HOST = "";
    private static final String DEFAULT_CLUSTER_ID = "";
    private static final String DEFAULT_CONFIG = "solr-exporter-config.xml";
    private static final int DEFAULT_SCRAPE_INTERVAL = 60;
    private static final Integer DEFAULT_NUM_THREADS = 1;
    private static final String DEFAULT_CREDENTIALS = "";
    public static final CollectorRegistry defaultRegistry = new CollectorRegistry();
    private final int port;
    private final CachedPrometheusCollector prometheusCollector;
    private final SchedulerMetricsCollector metricsCollector;
    private final SolrScraper solrScraper;
    private final ExecutorService metricCollectorExecutor;
    private final ExecutorService requestExecutor;
    private HTTPServer httpServer;

    public SolrExporter(int port, int numberThreads, int scrapeInterval, SolrScrapeConfiguration scrapeConfiguration, MetricsConfiguration metricsConfiguration, String clusterId) {
        this.port = port;
        this.metricCollectorExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)numberThreads, (ThreadFactory)new SolrNamedThreadFactory("solr-exporter-collectors"));
        this.requestExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)numberThreads, (ThreadFactory)new SolrNamedThreadFactory("solr-exporter-requests"));
        this.solrScraper = this.createScraper(scrapeConfiguration, metricsConfiguration.getSettings(), clusterId);
        this.metricsCollector = new MetricsCollectorFactory(this.metricCollectorExecutor, scrapeInterval, this.solrScraper, metricsConfiguration).create();
        this.prometheusCollector = new CachedPrometheusCollector();
    }

    void start() throws IOException {
        defaultRegistry.register((Collector)this.prometheusCollector);
        this.metricsCollector.addObserver(this.prometheusCollector);
        this.metricsCollector.start();
        this.httpServer = new HTTPServer(new InetSocketAddress(this.port), defaultRegistry);
    }

    void stop() {
        this.httpServer.stop();
        this.metricsCollector.removeObserver(this.prometheusCollector);
        this.requestExecutor.shutdownNow();
        this.metricCollectorExecutor.shutdownNow();
        IOUtils.closeQuietly((AutoCloseable)this.metricsCollector);
        IOUtils.closeQuietly((AutoCloseable)this.solrScraper);
        defaultRegistry.unregister((Collector)this.prometheusCollector);
    }

    private SolrScraper createScraper(SolrScrapeConfiguration configuration, PrometheusExporterSettings settings, String clusterId) {
        SolrClientFactory factory = new SolrClientFactory(settings, configuration);
        switch (configuration.getType()) {
            case STANDALONE: {
                return new SolrStandaloneScraper(factory.createStandaloneSolrClient(configuration.getSolrHost().get()), this.requestExecutor, clusterId);
            }
            case CLOUD: {
                return new SolrCloudScraper(factory.createCloudSolrClient(configuration.getZookeeperConnectionString().get()), this.requestExecutor, factory, clusterId);
            }
        }
        throw new RuntimeException("Invalid type: " + configuration.getType());
    }

    public static void main(String[] args) {
        Options mainOptions = new Options();
        Options deprecatedOptions = new Options();
        Option baseUrlOption = Option.builder((String)"b").longOpt("base-url").hasArg().argName("BASE_URL").type(String.class).desc("Specify the Solr base URL when connecting to Solr in standalone mode. If omitted both the -b parameter and the -z parameter, connect to http://localhost:8983/solr. For example 'http://localhost:8983/solr'.").build();
        mainOptions.addOption(baseUrlOption);
        Option baseUrlDepOption = Option.builder().longOpt("baseUrl").hasArg().argName("BASE_URL").type(String.class).deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --base-url instead").get()).desc("Specify the Solr base URL when connecting to Solr in standalone mode. If omitted both the -b parameter and the -z parameter, connect to http://localhost:8983/solr. For example 'http://localhost:8983/solr'.").build();
        deprecatedOptions.addOption(baseUrlDepOption);
        Option configOption = Option.builder().longOpt("config-file").hasArg().argName("CONFIG").type(String.class).desc("Specify the configuration file; the default is solr-exporter-config.xml.").build();
        Option configOptionDeprecated = Option.builder((String)"f").hasArg().argName("CONFIG").type(String.class).deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --config-file instead").get()).desc("Specify the configuration file; the default is solr-exporter-config.xml.").build();
        mainOptions.addOption(configOption);
        mainOptions.addOption(configOptionDeprecated);
        Option helpOption = Option.builder((String)"h").longOpt("help").desc("Prints this help message.").build();
        mainOptions.addOption(helpOption);
        Option clusterIdOption = Option.builder().longOpt("cluster-id").hasArg().argName("CLUSTER_ID").type(String.class).desc("Specify a unique identifier for the cluster, which can be used to select between multiple clusters in Grafana. By default this ID will be equal to a hash of the -b or -z argument").build();
        mainOptions.addOption(clusterIdOption);
        Option clusterIdDepOption = Option.builder((String)"i").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --cluster-id instead").get()).hasArg().argName("CLUSTER_ID").type(String.class).desc("Specify a unique identifier for the cluster, which can be used to select between multiple clusters in Grafana. By default this ID will be equal to a hash of the -b or -z argument").build();
        deprecatedOptions.addOption(clusterIdDepOption);
        Option numThreadsOption = Option.builder().longOpt("num-threads").hasArg().argName("NUM_THREADS").type(Integer.class).desc("Specify the number of threads. solr-exporter creates a thread pools for request to Solr. If you need to improve request latency via solr-exporter, you can increase the number of threads; the default is " + DEFAULT_NUM_THREADS + ".").build();
        mainOptions.addOption(numThreadsOption);
        Option numThreadsOptionDeprecated = Option.builder((String)"n").hasArg().deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --num-threads instead").get()).argName("NUM_THREADS").type(Integer.class).desc("Specify the number of threads. solr-exporter creates a thread pools for request to Solr. If you need to improve request latency via solr-exporter, you can increase the number of threads; the default is " + DEFAULT_NUM_THREADS + ".").build();
        mainOptions.addOption(numThreadsOptionDeprecated);
        Option portOption = Option.builder((String)"p").longOpt("port").hasArg().argName("PORT").type(Integer.class).desc("Specify the solr-exporter HTTP listen port; default is 8989.").build();
        mainOptions.addOption(portOption);
        Option scrapeIntervalOption = Option.builder().longOpt("scrape-interval").hasArg().argName("SCRAPE_INTERVAL").type(Integer.class).desc("Specify the delay between scraping Solr metrics; the default is 60 seconds.").build();
        mainOptions.addOption(scrapeIntervalOption);
        Option scrapeIntervalOptionDeprecated = Option.builder((String)"s").hasArg().argName("SCRAPE_INTERVAL").type(Integer.class).deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --scrape-interval instead").get()).desc("Specify the delay between scraping Solr metrics; the default is 60 seconds.").build();
        mainOptions.addOption(scrapeIntervalOptionDeprecated);
        Option sslOption = Option.builder((String)"ssl").longOpt("ssl-enabled").type(Boolean.class).desc("Enable TLS connection to Solr. Expects following env variables: SOLR_SSL_KEY_STORE, SOLR_SSL_KEY_STORE_PASSWORD, SOLR_SSL_TRUST_STORE, SOLR_SSL_TRUST_STORE_PASSWORD. Example: --ssl-enabled").build();
        mainOptions.addOption(sslOption);
        Option credentialsOption = Option.builder((String)"u").longOpt("credentials").hasArg().argName("CREDENTIALS").type(String.class).desc("Specify the credentials in the format username:password. Example: --credentials solr:SolrRocks").build();
        mainOptions.addOption(credentialsOption);
        Option zkHostOption = Option.builder((String)"z").longOpt("zk-host").hasArg().argName("ZK_HOST").type(String.class).desc("Specify the ZooKeeper connection string when connecting to Solr in SolrCloud mode. If omitted both the -b parameter and the -z parameter, connect to http://localhost:8983/solr. For example 'localhost:2181/solr'.").build();
        mainOptions.addOption(zkHostOption);
        Options options = new Options();
        options.addOptions(mainOptions);
        options.addOptions(deprecatedOptions);
        try {
            String credentials;
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(options, args);
            if (commandLine.hasOption(helpOption)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("bin/solr-exporter", "Prometheus exporter for Apache Solr.", mainOptions, null, true);
                return;
            }
            SolrScrapeConfiguration scrapeConfiguration = null;
            String defaultClusterId = "";
            if (commandLine.hasOption(zkHostOption)) {
                String zkHost = commandLine.getOptionValue(zkHostOption, "");
                defaultClusterId = SolrExporter.makeShortHash(zkHost);
                scrapeConfiguration = SolrScrapeConfiguration.solrCloud(zkHost);
            } else if (commandLine.hasOption(baseUrlOption) || commandLine.hasOption(baseUrlDepOption)) {
                log.warn("-b and --base-url will be replaced with -s and --solr-url in Solr 10");
                String baseUrl = commandLine.hasOption(baseUrlOption) ? commandLine.getOptionValue(baseUrlOption) : commandLine.getOptionValue(baseUrlDepOption, DEFAULT_BASE_URL);
                defaultClusterId = SolrExporter.makeShortHash(baseUrl);
                scrapeConfiguration = SolrScrapeConfiguration.standalone(baseUrl);
            }
            if (scrapeConfiguration == null) {
                log.error("Must provide either --{} or --{}", (Object)baseUrlOption.getLongOpt(), (Object)zkHostOption.getLongOpt());
            }
            int port = (Integer)commandLine.getParsedOptionValue(portOption, (Object)8989);
            String clusterId = commandLine.getOptionValue(clusterIdOption, "");
            if (commandLine.hasOption("i")) {
                clusterId = commandLine.getOptionValue("i");
            }
            if (StrUtils.isNullOrEmpty((String)clusterId)) {
                clusterId = defaultClusterId;
            }
            if (commandLine.hasOption(credentialsOption) && (credentials = commandLine.getOptionValue(credentialsOption, "")).indexOf(58) > 0) {
                String[] credentialsArray = credentials.split(":", 2);
                scrapeConfiguration.withBasicAuthCredentials(credentialsArray[0], credentialsArray[1]);
            }
            if (commandLine.hasOption(sslOption)) {
                log.info("SSL ENABLED");
                scrapeConfiguration.withSslConfiguration(Paths.get(SolrExporter.getSystemVariable("SOLR_SSL_KEY_STORE"), new String[0]), SolrExporter.getSystemVariable("SOLR_SSL_KEY_STORE_PASSWORD"), Paths.get(SolrExporter.getSystemVariable("SOLR_SSL_TRUST_STORE"), new String[0]), SolrExporter.getSystemVariable("SOLR_SSL_TRUST_STORE_PASSWORD"));
            }
            String configFile = DEFAULT_CONFIG;
            if (commandLine.hasOption(configOptionDeprecated)) {
                configFile = commandLine.getOptionValue(configOptionDeprecated);
            } else if (commandLine.hasOption(configOption)) {
                configFile = commandLine.getOptionValue(configOption);
            }
            int numberOfThreads = DEFAULT_NUM_THREADS;
            if (commandLine.hasOption("num-threads")) {
                numberOfThreads = (Integer)commandLine.getParsedOptionValue("num-threads");
            } else if (commandLine.hasOption("n")) {
                numberOfThreads = (Integer)commandLine.getParsedOptionValue("n");
            }
            int scrapeInterval = 60;
            if (commandLine.hasOption("s")) {
                scrapeInterval = (Integer)commandLine.getParsedOptionValue(scrapeIntervalOptionDeprecated);
            } else if (commandLine.hasOption("scrape-interval")) {
                scrapeInterval = (Integer)commandLine.getParsedOptionValue(scrapeIntervalOption);
            }
            SolrExporter solrExporter = new SolrExporter(port, numberOfThreads, scrapeInterval, scrapeConfiguration, SolrExporter.loadMetricsConfiguration(configFile), clusterId);
            log.info("Starting Solr Prometheus Exporting on port {}", (Object)port);
            solrExporter.start();
            log.info("Solr Prometheus Exporter is running. Collecting metrics for cluster {}: {}", (Object)clusterId, (Object)scrapeConfiguration);
        }
        catch (IOException e) {
            log.error("Failed to start Solr Prometheus Exporter: ", (Throwable)e);
        }
        catch (ParseException e) {
            log.error("Failed to parse command line arguments: ", (Throwable)e);
        }
    }

    static String makeShortHash(String inputString) {
        return DigestUtils.sha256Hex((String)inputString).substring(0, 10);
    }

    private static MetricsConfiguration loadMetricsConfiguration(String configPath) {
        try {
            return MetricsConfiguration.from(configPath);
        }
        catch (Exception e) {
            log.error("Could not load scrape configuration from {}", (Object)configPath);
            throw new RuntimeException(e);
        }
    }

    private static String getSystemVariable(String name) {
        return System.getProperty(name, System.getenv(name));
    }
}

