/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Static;

public class SetopOperandTypeChecker
implements SqlOperandTypeChecker {
    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int i;
        assert (callBinding.getOperandCount() == 2) : "setops are binary (for now)";
        final RelDataType[] argTypes = new RelDataType[callBinding.getOperandCount()];
        int colCount = -1;
        SqlValidator validator = callBinding.getValidator();
        for (i = 0; i < argTypes.length; ++i) {
            argTypes[i] = callBinding.getOperandType(i);
            RelDataType argType = argTypes[i];
            if (!argType.isStruct()) {
                if (throwOnFailure) {
                    throw new AssertionError((Object)"setop arg must be a struct");
                }
                return false;
            }
            List<RelDataTypeField> fields = argType.getFieldList();
            if (i == 0) {
                colCount = fields.size();
                continue;
            }
            if (fields.size() == colCount) continue;
            if (throwOnFailure) {
                SqlNode node = callBinding.operand(i);
                if (node instanceof SqlSelect) {
                    node = ((SqlSelect)node).getSelectList();
                }
                throw validator.newValidationError(Objects.requireNonNull(node, "node"), Static.RESOURCE.columnCountMismatchInSetop(callBinding.getOperator().getName()));
            }
            return false;
        }
        for (i = 0; i < colCount; ++i) {
            final int i2 = i;
            AbstractList<RelDataType> columnIthTypes = new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return argTypes[index].getFieldList().get(i2).getType();
                }

                @Override
                public int size() {
                    return argTypes.length;
                }
            };
            RelDataType type = callBinding.getTypeFactory().leastRestrictive((List<RelDataType>)columnIthTypes);
            if (type != null) continue;
            boolean coerced = false;
            if (callBinding.isTypeCoercionEnabled()) {
                for (int j = 0; j < callBinding.getOperandCount(); ++j) {
                    TypeCoercion typeCoercion = validator.getTypeCoercion();
                    RelDataType widenType = typeCoercion.getWiderTypeFor((List<RelDataType>)columnIthTypes, true);
                    if (null == widenType) continue;
                    coerced = typeCoercion.rowTypeCoercion(callBinding.getScope(), callBinding.operand(j), i, widenType) || coerced;
                }
            }
            if (coerced) continue;
            if (throwOnFailure) {
                SqlNode field = SqlUtil.getSelectListItem(callBinding.operand(0), i);
                throw validator.newValidationError(field, Static.RESOURCE.columnTypeMismatchInSetop(i + 1, callBinding.getOperator().getName()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "{0} " + opName + " {1}";
    }
}

