/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.common;

import java.io.ByteArrayInputStream;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.crossdc.common.ConfigProperty;
import org.apache.solr.crossdc.common.KafkaCrossDcConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressForbidden(reason="load properties from byte array")
public class ConfUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void fillProperties(SolrZkClient solrClient, Map<String, Object> properties) {
        String val;
        Map<String, String> env = System.getenv();
        for (ConfigProperty configKey : KafkaCrossDcConf.CONFIG_PROPERTIES) {
            val = env.get(configKey.getKey());
            if (val == null) {
                val = env.get(configKey.getKey().toUpperCase(Locale.ROOT));
            }
            if (val == null) continue;
            properties.put(configKey.getKey(), val);
        }
        for (ConfigProperty configKey : KafkaCrossDcConf.CONFIG_PROPERTIES) {
            val = System.getProperty(configKey.getKey());
            if (val == null) continue;
            properties.put(configKey.getKey(), val);
        }
        Properties zkProps = new Properties();
        if (solrClient != null) {
            try {
                if (solrClient.exists(System.getProperty("zkCrossDcPropsPath", "/crossdc.properties"), true).booleanValue()) {
                    byte[] data = solrClient.getData(System.getProperty("zkCrossDcPropsPath", "/crossdc.properties"), null, null, true);
                    if (data == null) {
                        log.error("/crossdc.properties file in Zookeeper has no data");
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "/crossdc.properties file in Zookeeper has no data");
                    }
                    zkProps.load(new ByteArrayInputStream(data));
                    KafkaCrossDcConf.readZkProps(properties, zkProps);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Interrupted looking for CrossDC configuration in Zookeeper", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, (Throwable)e);
            }
            catch (Exception e) {
                log.error("Exception looking for CrossDC configuration in Zookeeper", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception looking for CrossDC configuration in Zookeeper", (Throwable)e);
            }
        }
    }

    public static void verifyProperties(Map<String, Object> properties) {
        if (properties.get("solr.crossdc.bootstrapServers") == null) {
            log.error("solr.crossdc.bootstrapServers not specified for producer in CrossDC configuration props={}", properties);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.crossdc.bootstrapServers not specified in configuration");
        }
        if (properties.get("solr.crossdc.topicName") == null) {
            log.error("solr.crossdc.topicName not specified for producer in CrossDC configuration props={}", properties);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.crossdc.topicName not specified in configuration");
        }
    }
}

