/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.request;

import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.CheckSumHandler;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.request.ServiceTicketIssuer;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApOption;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.LastReq;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.LastReqEntry;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.LastReqType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.EncTgsRepPart;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.TgsRep;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.TgsReq;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TicketFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TgsRequest
extends KdcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(TgsRequest.class);
    private EncryptionKey tgtSessionKey;
    private Ticket tgtTicket;

    public TgsRequest(TgsReq tgsReq, KdcContext kdcContext) {
        super(tgsReq, kdcContext);
        this.setPreauthRequired(true);
    }

    public EncryptionKey getTgtSessionKey() {
        return this.tgtSessionKey;
    }

    public void setTgtSessionKey(EncryptionKey tgtSessionKey) {
        this.tgtSessionKey = tgtSessionKey;
    }

    @Override
    protected void checkClient() throws KrbException {
    }

    public Ticket getTgtTicket() {
        return this.tgtTicket;
    }

    @Override
    protected void issueTicket() throws KrbException {
        ServiceTicketIssuer issuer = new ServiceTicketIssuer(this);
        Ticket newTicket = issuer.issueTicket();
        LOG.info("TGS_REQ ISSUE: authtime " + newTicket.getEncPart().getAuthTime().getTime() + "," + newTicket.getEncPart().getCname() + " for " + newTicket.getSname());
        this.setTicket(newTicket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyAuthenticator(PaDataEntry paDataEntry) throws KrbException {
        boolean success;
        byte[] reqBody;
        EncryptionKey tgsKey;
        ApReq apReq = KrbCodec.decode(paDataEntry.getPaDataValue(), ApReq.class);
        if (apReq.getPvno() != 5) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADVERSION);
        }
        if (apReq.getMsgType() != KrbMessageType.AP_REQ) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_MSG_TYPE);
        }
        this.tgtTicket = apReq.getTicket();
        EncryptionType encType = this.tgtTicket.getEncryptedEncPart().getEType();
        String remoteRealm = this.tgtTicket.getRealm();
        if (this.checkCrossRealm(remoteRealm)) {
            KrbIdentity tgs = this.getCrossRealmTgsEntry(remoteRealm);
            if (tgs == null) throw new KrbException("Failed to get the tgs entry for remote realm: " + remoteRealm);
            tgsKey = tgs.getKey(encType);
        } else {
            tgsKey = this.getTgsEntry().getKeys().get(encType);
        }
        if (tgsKey == null) {
            throw new KrbException("Failed to get the tgs key for the type: " + encType);
        }
        if (this.tgtTicket.getTktvno() != 5) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADVERSION);
        }
        EncTicketPart encPart = EncryptionUtil.unseal(this.tgtTicket.getEncryptedEncPart(), tgsKey, KeyUsage.KDC_REP_TICKET, EncTicketPart.class);
        this.tgtTicket.setEncPart(encPart);
        EncryptionKey encKey = null;
        encKey = this.tgtTicket.getEncPart().getKey();
        if (encKey == null) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_NOKEY);
        }
        Authenticator authenticator = EncryptionUtil.unseal(apReq.getEncryptedAuthenticator(), encKey, KeyUsage.TGS_REQ_AUTH, Authenticator.class);
        if (!authenticator.getCname().equals(this.tgtTicket.getEncPart().getCname())) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADMATCH);
        }
        HostAddresses hostAddresses = this.tgtTicket.getEncPart().getClientAddresses();
        if (hostAddresses == null || hostAddresses.isEmpty() ? !this.getKdcContext().getConfig().isEmptyAddressesAllowed() : !hostAddresses.contains(this.getClientAddress())) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADADDR);
        }
        PrincipalName serverPrincipal = this.tgtTicket.getSname();
        serverPrincipal.setRealm(this.tgtTicket.getRealm());
        if (authenticator.getCrealm() != null && authenticator.getCrealm().equals(this.getKdcContext().getKdcRealm())) {
            PrincipalName clientPrincipal = authenticator.getCname();
            clientPrincipal.setRealm(authenticator.getCrealm());
            KrbIdentity clientEntry = this.getEntry(clientPrincipal.getName());
            this.setClientEntry(clientEntry);
        }
        if (!authenticator.getCtime().isInClockSkew(this.getKdcContext().getConfig().getAllowableClockSkew() * 1000L)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_SKEW);
        }
        KerberosTime now = KerberosTime.now();
        KerberosTime startTime = this.tgtTicket.getEncPart().getStartTime();
        if (startTime == null) {
            startTime = this.tgtTicket.getEncPart().getAuthTime();
        }
        if (!startTime.lessThan(now)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_TKT_NYV);
        }
        KerberosTime endTime = this.tgtTicket.getEncPart().getEndTime();
        if (!endTime.greaterThan(now)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_TKT_EXPIRED);
        }
        apReq.getApOptions().setFlag(ApOption.MUTUAL_REQUIRED);
        this.setTgtSessionKey(this.tgtTicket.getEncPart().getKey());
        CheckSum checkSum = authenticator.getCksum();
        if (checkSum == null) return;
        try {
            reqBody = KrbCodec.encode(this.getKdcReq().getReqBody());
        }
        catch (KrbException e) {
            String errMessage = "Encode the ReqBody failed. " + e.getMessage();
            LOG.error(errMessage);
            throw new KrbException(errMessage);
        }
        switch (checkSum.getCksumtype()) {
            case RSA_MD5_DES: 
            case RSA_MD4_DES: 
            case DES_MAC: 
            case DES_CBC: 
            case HMAC_SHA1_DES3: 
            case HMAC_SHA1_96_AES256: 
            case HMAC_SHA1_96_AES128: 
            case CMAC_CAMELLIA128: 
            case CMAC_CAMELLIA256: 
            case MD5_HMAC_ARCFOUR: 
            case HMAC_MD5_ARCFOUR: {
                success = CheckSumHandler.verifyWithKey(checkSum, reqBody, this.getTgtSessionKey().getKeyData(), KeyUsage.TGS_REQ_AUTH_CKSUM);
                break;
            }
            default: {
                success = CheckSumHandler.verify(checkSum, reqBody);
            }
        }
        if (success) return;
        LOG.error("Verify the KdcReqBody failed.");
        throw new KrbException("Verify the KdcReqBody failed.");
    }

    @Override
    protected void makeReply() throws KrbException {
        Ticket ticket = this.getTicket();
        TgsRep reply = new TgsRep();
        if (this.getClientEntry() == null) {
            reply.setCname(ticket.getEncPart().getCname());
            reply.setCrealm(ticket.getEncPart().getCrealm());
        } else {
            reply.setCname(this.getClientEntry().getPrincipal());
            reply.setCrealm(this.getKdcContext().getKdcRealm());
        }
        reply.setTicket(ticket);
        EncKdcRepPart encKdcRepPart = this.makeEncKdcRepPart();
        reply.setEncPart(encKdcRepPart);
        EncryptionKey sessionKey = this.getToken() != null ? this.getSessionKey() : this.getTgtSessionKey();
        EncryptedData encryptedData = EncryptionUtil.seal(encKdcRepPart, sessionKey, KeyUsage.TGS_REP_ENCPART_SESSKEY);
        reply.setEncryptedEncPart(encryptedData);
        this.setReply(reply);
    }

    private EncKdcRepPart makeEncKdcRepPart() {
        KdcReq request = this.getKdcReq();
        Ticket ticket = this.getTicket();
        EncTgsRepPart encKdcRepPart = new EncTgsRepPart();
        encKdcRepPart.setKey(ticket.getEncPart().getKey());
        LastReq lastReq = new LastReq();
        LastReqEntry entry = new LastReqEntry();
        entry.setLrType(LastReqType.THE_LAST_INITIAL);
        entry.setLrValue(new KerberosTime());
        lastReq.add(entry);
        encKdcRepPart.setLastReq(lastReq);
        encKdcRepPart.setNonce(request.getReqBody().getNonce());
        encKdcRepPart.setFlags(ticket.getEncPart().getFlags());
        encKdcRepPart.setAuthTime(ticket.getEncPart().getAuthTime());
        encKdcRepPart.setStartTime(ticket.getEncPart().getStartTime());
        encKdcRepPart.setEndTime(ticket.getEncPart().getEndTime());
        if (ticket.getEncPart().getFlags().isFlagSet(TicketFlag.RENEWABLE)) {
            encKdcRepPart.setRenewTill(ticket.getEncPart().getRenewtill());
        }
        encKdcRepPart.setSname(ticket.getSname());
        encKdcRepPart.setSrealm(ticket.getRealm());
        encKdcRepPart.setCaddr(ticket.getEncPart().getClientAddresses());
        return encKdcRepPart;
    }

    @Override
    public ByteBuffer getRequestBody() throws KrbException {
        return null;
    }
}

