/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.resolve.internal;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=ArtifactResolver.class, hint="default")
public class DefaultArtifactResolver
implements ArtifactResolver,
Contextualizable {
    private PlexusContainer container;

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, Artifact mavenArtifact) throws ArtifactResolverException {
        try {
            String hint = DefaultArtifactResolver.isMaven31() ? "maven31" : "maven3";
            ArtifactResolver effectiveArtifactResolver = (ArtifactResolver)this.container.lookup(ArtifactResolver.class, hint);
            return effectiveArtifactResolver.resolveArtifact(buildingRequest, mavenArtifact);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactResolverException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) throws ArtifactResolverException {
        try {
            String hint = DefaultArtifactResolver.isMaven31() ? "maven31" : "maven3";
            ArtifactResolver effectiveArtifactResolver = (ArtifactResolver)this.container.lookup(ArtifactResolver.class, hint);
            return effectiveArtifactResolver.resolveArtifact(buildingRequest, coordinate);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactResolverException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected static boolean isMaven31() {
        return DefaultArtifactResolver.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

