/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@IgnoreJRERequirement
public final class ThreadUtil {
    private static final ThreadLocal<Boolean> TREAT_AS_VIRTUAL_THREAD = new ThreadLocal();

    private ThreadUtil() {
        throw new IllegalStateException("No instances");
    }

    private static boolean isTreatAsVirtualThread() {
        return Boolean.TRUE.equals(TREAT_AS_VIRTUAL_THREAD.get());
    }

    public static void setTreatAsVirtualThread(boolean b) {
        if (ThreadUtil.isVirtualThread()) {
            return;
        }
        TREAT_AS_VIRTUAL_THREAD.set(b);
    }

    public static boolean isVirtualThread() {
        return ThreadUtil.isTreatAsVirtualThread();
    }

    public static boolean isVirtualThreadSupported() {
        return false;
    }

    public static ExecutorService newVirtualThreadPerTaskExecutor() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> ThreadUtil.startNewDaemonThread(true, r));
    }

    public static boolean checkNotInterruptedOrThrow() throws InterruptedIOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException();
        }
        return true;
    }

    public static Thread startNewDaemonThread(boolean virtual, Runnable run) {
        if (virtual) {
            Runnable run0 = run;
            run = () -> {
                ThreadUtil.setTreatAsVirtualThread(true);
                run0.run();
            };
        }
        Thread t = new Thread(run);
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static void runOnSystemThread(Runnable op) throws InterruptedException {
        boolean treatAsVirtual = ThreadUtil.isTreatAsVirtualThread();
        if (treatAsVirtual) {
            ThreadUtil.setTreatAsVirtualThread(false);
        }
        try {
            op.run();
        }
        finally {
            if (treatAsVirtual) {
                ThreadUtil.setTreatAsVirtualThread(treatAsVirtual);
            }
        }
    }
}

