/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.coor.conversion.DMSCoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.NauticalCoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ProjectedCoordinateFormat;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class CoordinateFormatManager {
    private static final List<ICoordinateFormat> formats = new ArrayList<ICoordinateFormat>();
    private static volatile ICoordinateFormat defaultCoordinateFormat;

    private CoordinateFormatManager() {
    }

    public static void registerCoordinateFormat(ICoordinateFormat format) {
        formats.add(format);
    }

    public static List<ICoordinateFormat> getCoordinateFormats() {
        return Collections.unmodifiableList(formats);
    }

    public static ICoordinateFormat getDefaultFormat() {
        return defaultCoordinateFormat;
    }

    public static void setCoordinateFormat(ICoordinateFormat format) {
        if (format != null) {
            defaultCoordinateFormat = format;
        }
    }

    public static ICoordinateFormat getCoordinateFormat(String id) {
        CheckParameterUtil.ensureParameterNotNull(id, "id");
        return formats.stream().filter(format -> id.equals(format.getId())).findFirst().orElse(null);
    }

    static {
        CoordinateFormatManager.registerCoordinateFormat(DecimalDegreesCoordinateFormat.INSTANCE);
        CoordinateFormatManager.registerCoordinateFormat(DMSCoordinateFormat.INSTANCE);
        CoordinateFormatManager.registerCoordinateFormat(NauticalCoordinateFormat.INSTANCE);
        CoordinateFormatManager.registerCoordinateFormat(ProjectedCoordinateFormat.INSTANCE);
        defaultCoordinateFormat = DecimalDegreesCoordinateFormat.INSTANCE;
    }
}

