/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.harvest.HarvestConfig;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.message.Message;
import org.ice4j.socket.SocketPool;
import org.ice4j.socket.StunDatagramPacketFilter;
import org.ice4j.util.Buffer;
import org.ice4j.util.BufferHandler;
import org.ice4j.util.BufferPool;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.queue.QueueStatistics;

public abstract class AbstractUdpListener {
    private static final Logger logger = Logger.getLogger(AbstractUdpListener.class.getName());
    private static final int BUFFER_SIZE = 1472;
    private static final int POOL_SIZE = 256;
    public static int BYTES_TO_LEAVE_AT_START_OF_PACKET = 0;
    public static int BYTES_TO_LEAVE_AT_END_OF_PACKET = 0;
    public static boolean USE_PUSH_API = false;
    private final Map<SocketAddress, MySocket> sockets = new ConcurrentHashMap<SocketAddress, MySocket>();
    private final ArrayBlockingQueue<Buffer> pool = new ArrayBlockingQueue(256);
    protected final TransportAddress localAddress;
    private final SocketPool socketPool;
    private final DatagramSocket receiveSocket;
    private final Thread thread;
    private boolean close = false;

    public static List<TransportAddress> getAllowedAddresses(int port2) {
        LinkedList<TransportAddress> addresses = new LinkedList<TransportAddress>();
        for (InetAddress address : HostCandidateHarvester.getAllAllowedAddresses()) {
            addresses.add(new TransportAddress(address, port2, Transport.UDP));
        }
        return addresses;
    }

    static String getUfrag(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 20) {
            return null;
        }
        if ((buf[off + 4] & 0xFF) != 33 || (buf[off + 5] & 0xFF) != 18 || (buf[off + 6] & 0xFF) != 164 || (buf[off + 7] & 0xFF) != 66) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Not a STUN packet, magic cookie not found.");
            }
            return null;
        }
        try {
            Message stunMessage = Message.decode(buf, off, len);
            if (stunMessage.getMessageType() != '\u0001') {
                return null;
            }
            UsernameAttribute usernameAttribute = (UsernameAttribute)stunMessage.getAttribute('\u0006');
            if (usernameAttribute == null) {
                return null;
            }
            String usernameString = new String(usernameAttribute.getUsername());
            return usernameString.split(":")[0];
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Failed to extract local ufrag: " + e);
            }
            return null;
        }
    }

    protected AbstractUdpListener(TransportAddress localAddress) throws IOException {
        TransportAddress tempAddress = localAddress;
        boolean bindWildcard = StackProperties.getBoolean("org.ice4j.BIND_WILDCARD", false);
        if (bindWildcard) {
            tempAddress = new TransportAddress((InetAddress)null, localAddress.getPort(), localAddress.getTransport());
        }
        this.socketPool = new SocketPool(tempAddress, HarvestConfig.config.udpSocketPoolSize());
        this.receiveSocket = this.socketPool.getReceiveSocket();
        Integer receiveBufferSize = HarvestConfig.config.udpReceiveBufferSize();
        if (receiveBufferSize != null) {
            this.receiveSocket.setReceiveBufferSize(receiveBufferSize);
        }
        if (localAddress.getPort() == 0) {
            tempAddress = new TransportAddress(tempAddress.getAddress(), this.receiveSocket.getLocalPort(), tempAddress.getTransport());
        }
        this.localAddress = tempAddress;
        String logMessage = "Initialized AbstractUdpListener with address " + this.localAddress;
        logMessage = logMessage + ". Receive buffer size " + this.receiveSocket.getReceiveBufferSize();
        if (receiveBufferSize != null) {
            logMessage = logMessage + " (asked for " + receiveBufferSize + ")";
        }
        logMessage = logMessage + "; socket pool size " + this.socketPool.getNumSockets();
        logger.info(logMessage);
        this.thread = new Thread(() -> {
            if (USE_PUSH_API) {
                this.runInHarvesterThreadPush();
            } else {
                this.runInHarvesterThread();
            }
        });
        this.thread.setName(AbstractUdpListener.class.getName() + " thread for " + this.localAddress);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public TransportAddress getLocalAddress() {
        return this.localAddress;
    }

    public void close() {
        this.close = true;
        this.socketPool.close();
    }

    private void runInHarvesterThread() {
        DatagramPacket pkt = null;
        while (!this.close) {
            Buffer buf = this.getFreeBuffer();
            if (pkt == null) {
                pkt = new DatagramPacket(buf.getBuffer(), 0, buf.getBuffer().length);
            } else {
                pkt.setData(buf.getBuffer(), 0, buf.getBuffer().length);
            }
            try {
                this.receiveSocket.receive(pkt);
            }
            catch (IOException ioe) {
                if (this.close) break;
                logger.severe("Failed to receive from socket: " + ioe);
                break;
            }
            buf.setOffset(pkt.getOffset());
            buf.setLength(pkt.getLength());
            InetSocketAddress remoteAddress = (InetSocketAddress)pkt.getSocketAddress();
            MySocket destinationSocket = this.sockets.get(remoteAddress);
            if (destinationSocket != null) {
                destinationSocket.addBuffer(buf);
                continue;
            }
            String ufrag = AbstractUdpListener.getUfrag(buf.getBuffer(), buf.getOffset(), buf.getLength());
            if (ufrag == null) continue;
            MySocket newSocket = this.maybeAcceptNewSession(buf, remoteAddress, ufrag);
            if (newSocket == null) {
                this.pool.offer(buf);
                continue;
            }
            newSocket.addBuffer(buf);
        }
        for (MySocket candidateSocket : new ArrayList<MySocket>(this.sockets.values())) {
            candidateSocket.close();
        }
        this.socketPool.close();
    }

    private void runInHarvesterThreadPush() {
        DatagramPacket pkt = new DatagramPacket(new byte[1500], 0, 1500);
        Clock clock = Clock.systemUTC();
        while (!this.close) {
            Instant receivedTime;
            pkt.setData(pkt.getData(), 0, pkt.getData().length);
            try {
                this.receiveSocket.receive(pkt);
                receivedTime = clock.instant();
            }
            catch (IOException ioe) {
                if (this.close) break;
                logger.severe("Failed to receive from socket: " + ioe);
                break;
            }
            InetSocketAddress remoteAddress = (InetSocketAddress)pkt.getSocketAddress();
            MySocket destinationSocket = this.sockets.get(remoteAddress);
            if (destinationSocket == null) {
                String ufrag = AbstractUdpListener.getUfrag(pkt.getData(), pkt.getOffset(), pkt.getLength());
                if (ufrag == null) continue;
                Buffer buffer = this.bufferFromPacket(pkt, receivedTime);
                MySocket newSocket = this.maybeAcceptNewSession(buffer, remoteAddress, ufrag);
                if (newSocket == null) {
                    BufferPool.returnBuffer.invoke(buffer);
                    continue;
                }
                newSocket.addBuffer(buffer);
                continue;
            }
            Buffer buf = this.bufferFromPacket(pkt, receivedTime);
            if (StunDatagramPacketFilter.isStunPacket(pkt)) {
                destinationSocket.addBuffer(buf);
                continue;
            }
            destinationSocket.bufferHandler.handleBuffer(buf);
        }
        for (MySocket candidateSocket : new ArrayList<MySocket>(this.sockets.values())) {
            candidateSocket.close();
        }
        this.socketPool.close();
    }

    private Buffer bufferFromPacket(DatagramPacket p, Instant receivedTime) {
        int off = BYTES_TO_LEAVE_AT_START_OF_PACKET;
        Buffer buffer = BufferPool.getBuffer.invoke((Integer)(off + p.getLength() + BYTES_TO_LEAVE_AT_END_OF_PACKET));
        System.arraycopy(p.getData(), p.getOffset(), buffer.getBuffer(), off, p.getLength());
        buffer.setOffset(off);
        buffer.setLength(p.getLength());
        buffer.setLocalAddress(this.receiveSocket.getLocalSocketAddress());
        buffer.setRemoteAddress(p.getSocketAddress());
        buffer.setReceivedTime(receivedTime);
        return buffer;
    }

    protected abstract MySocket maybeAcceptNewSession(Buffer var1, InetSocketAddress var2, String var3);

    private Buffer getFreeBuffer() {
        Buffer buf = this.pool.poll();
        if (buf == null) {
            buf = new Buffer(new byte[1472], 0, 0);
        }
        return buf;
    }

    protected MySocket addSocket(InetSocketAddress remoteAddress, String ufrag, @NotNull BufferHandler bufferHandler) throws SocketException {
        MySocket newSocket = new MySocket(remoteAddress, ufrag, bufferHandler);
        this.sockets.put(remoteAddress, newSocket);
        return newSocket;
    }

    protected class MySocket
    extends DatagramSocket {
        private static final int QUEUE_SIZE = 128;
        private final ArrayBlockingQueue<Buffer> queue;
        private final QueueStatistics queueStatistics;
        private InetSocketAddress remoteAddress;
        private boolean closed;
        private final String ufrag;
        @NotNull
        private final BufferHandler bufferHandler;

        MySocket(InetSocketAddress remoteAddress, @NotNull String ufrag, BufferHandler bufferHandler) throws SocketException {
            super((SocketAddress)null);
            this.queue = new ArrayBlockingQueue(128);
            this.closed = false;
            this.ufrag = ufrag;
            this.bufferHandler = bufferHandler;
            this.remoteAddress = remoteAddress;
            this.queueStatistics = logger.isLoggable(Level.FINEST) ? new QueueStatistics(128, Clock.systemUTC()) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBuffer(Buffer buf) {
            ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
            synchronized (arrayBlockingQueue) {
                if (this.queue.size() == 128) {
                    logger.info("Dropping a packet because the queue is full. Remote address = " + this.remoteAddress + " ufrag=" + this.ufrag);
                    if (this.queueStatistics != null) {
                        this.queueStatistics.dropped();
                    }
                    this.queue.poll();
                }
                this.queue.offer(buf);
                if (this.queueStatistics != null) {
                    this.queueStatistics.added();
                }
                this.queue.notify();
            }
        }

        @Override
        public InetAddress getLocalAddress() {
            return AbstractUdpListener.this.localAddress.getAddress();
        }

        @Override
        public int getLocalPort() {
            return AbstractUdpListener.this.localAddress.getPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return AbstractUdpListener.this.localAddress;
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.remoteAddress;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.remoteAddress.getAddress();
        }

        @Override
        public int getPort() {
            return this.remoteAddress.getPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
            synchronized (arrayBlockingQueue) {
                this.closed = true;
                this.queue.notifyAll();
            }
            if (this.remoteAddress != null) {
                AbstractUdpListener.this.sockets.remove(this.remoteAddress);
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(DatagramPacket p) throws IOException {
            Buffer buf = null;
            while (buf == null) {
                ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
                synchronized (arrayBlockingQueue) {
                    if (this.closed) {
                        throw new SocketException("Socket closed");
                    }
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if ((buf = this.queue.poll()) != null && this.queueStatistics != null) {
                        this.queueStatistics.removed(this.queue.size(), null);
                    }
                }
            }
            byte[] pData = p.getData();
            if (pData == null || pData.length < buf.getLength()) {
                throw new IOException("packet buffer not available");
            }
            System.arraycopy(buf.getBuffer(), buf.getOffset(), pData, 0, buf.getLength());
            p.setLength(buf.getLength());
            p.setSocketAddress(this.remoteAddress);
            if (USE_PUSH_API) {
                BufferPool.returnBuffer.invoke(buf);
            } else {
                AbstractUdpListener.this.pool.offer(buf);
            }
        }

        @Override
        public void send(DatagramPacket p) throws IOException {
            p.setSocketAddress(this.remoteAddress);
            AbstractUdpListener.this.socketPool.send(p);
        }
    }
}

