/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.oer.Element;
import org.bouncycastle.oer.ElementSupplier;
import org.bouncycastle.oer.Switch;

public class OERDefinition {
    static final BigInteger[] uIntMax = new BigInteger[]{new BigInteger("256"), new BigInteger("65536"), new BigInteger("4294967296"), new BigInteger("18446744073709551616")};
    static final BigInteger[][] sIntRange = new BigInteger[][]{{new BigInteger("-128"), new BigInteger("127")}, {new BigInteger("-32768"), new BigInteger("32767")}, {new BigInteger("-2147483648"), new BigInteger("2147483647")}, {new BigInteger("-9223372036854775808"), new BigInteger("9223372036854775807")}};

    public static Builder bool() {
        return new Builder(BaseType.BOOLEAN);
    }

    public static Builder integer() {
        return new Builder(BaseType.INT);
    }

    public static Builder integer(long l) {
        return new Builder(BaseType.INT).defaultValue(new ASN1Integer(l));
    }

    public static Builder bitString(long l) {
        return new Builder(BaseType.BIT_STRING).fixedSize(l);
    }

    public static Builder integer(BigInteger bigInteger, BigInteger bigInteger2) {
        return new Builder(BaseType.INT).range(bigInteger, bigInteger2);
    }

    public static Builder integer(long l, long l2) {
        return new Builder(BaseType.INT).range(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }

    public static Builder integer(long l, long l2, ASN1Encodable aSN1Encodable) {
        return new Builder(BaseType.INT).range(l, l2, aSN1Encodable);
    }

    public static Builder nullValue() {
        return new Builder(BaseType.NULL);
    }

    public static Builder seq() {
        return new Builder(BaseType.SEQ);
    }

    public static Builder seq(Object ... objectArray) {
        return new Builder(BaseType.SEQ).items(objectArray);
    }

    public static Builder aSwitch(Switch switch_) {
        return new Builder(BaseType.Switch).decodeSwitch(switch_);
    }

    public static Builder enumItem(String string) {
        return new Builder(BaseType.ENUM_ITEM).label(string);
    }

    public static Builder enumItem(String string, BigInteger bigInteger) {
        return new Builder(BaseType.ENUM_ITEM).enumValue(bigInteger).label(string);
    }

    public static Builder enumeration(Object ... objectArray) {
        return new Builder(BaseType.ENUM).items(objectArray);
    }

    public static Builder choice(Object ... objectArray) {
        return new Builder(BaseType.CHOICE).items(objectArray);
    }

    public static Builder placeholder() {
        return new Builder(null);
    }

    public static Builder seqof(Object ... objectArray) {
        return new Builder(BaseType.SEQ_OF).items(objectArray);
    }

    public static Builder octets() {
        return new Builder(BaseType.OCTET_STRING).unbounded();
    }

    public static Builder octets(int n) {
        return new Builder(BaseType.OCTET_STRING).fixedSize(n);
    }

    public static Builder octets(int n, int n2) {
        return new Builder(BaseType.OCTET_STRING).range(BigInteger.valueOf(n), BigInteger.valueOf(n2));
    }

    public static Builder ia5String() {
        return new Builder(BaseType.IA5String);
    }

    public static Builder utf8String() {
        return new Builder(BaseType.UTF8_STRING);
    }

    public static Builder utf8String(int n) {
        return new Builder(BaseType.UTF8_STRING).rangeToMAXFrom(n);
    }

    public static Builder utf8String(int n, int n2) {
        return new Builder(BaseType.UTF8_STRING).range(BigInteger.valueOf(n), BigInteger.valueOf(n2));
    }

    public static Builder opaque() {
        return new Builder(BaseType.OPAQUE);
    }

    public static List<Object> optional(Object ... objectArray) {
        return new OptionalList(Arrays.asList(objectArray));
    }

    public static ExtensionList extension(Object ... objectArray) {
        return new ExtensionList(1, Arrays.asList(objectArray));
    }

    public static ExtensionList extension(int n, Object ... objectArray) {
        return new ExtensionList(n, Arrays.asList(objectArray));
    }

    public static Builder deferred(ElementSupplier elementSupplier) {
        return new Builder(BaseType.Supplier).elementSupplier(elementSupplier);
    }

    public static enum BaseType {
        SEQ,
        SEQ_OF,
        CHOICE,
        ENUM,
        INT,
        OCTET_STRING,
        OPAQUE,
        UTF8_STRING,
        BIT_STRING,
        NULL,
        EXTENSION,
        ENUM_ITEM,
        BOOLEAN,
        IS0646String,
        PrintableString,
        NumericString,
        BMPString,
        UniversalString,
        IA5String,
        VisibleString,
        Switch,
        Supplier;

    }

    public static class Builder {
        protected final BaseType baseType;
        protected ArrayList<Builder> children = new ArrayList();
        protected boolean explicit = true;
        protected String typeName;
        protected String label;
        protected BigInteger upperBound;
        protected BigInteger lowerBound;
        protected BigInteger enumValue;
        protected ASN1Encodable defaultValue;
        protected Builder placeholderValue;
        protected Boolean inScope;
        protected Switch aSwitch;
        protected ArrayList<ASN1Encodable> validSwitchValues = new ArrayList();
        protected ElementSupplier elementSupplier;
        protected boolean mayRecurse;
        protected Map<String, ElementSupplier> supplierMap = new HashMap<String, ElementSupplier>();
        protected int block;
        private final ItemProvider defaultItemProvider = new ItemProvider(){

            @Override
            public Builder existingChild(int n, Builder builder2) {
                return builder2.copy(defaultItemProvider);
            }
        };

        public Builder(BaseType baseType) {
            this.baseType = baseType;
        }

        private Builder copy(ItemProvider itemProvider) {
            Builder builder2 = new Builder(this.baseType);
            int n = 0;
            for (Builder builder3 : this.children) {
                builder2.children.add(itemProvider.existingChild(n++, builder3));
            }
            builder2.explicit = this.explicit;
            builder2.label = this.label;
            builder2.upperBound = this.upperBound;
            builder2.lowerBound = this.lowerBound;
            builder2.defaultValue = this.defaultValue;
            builder2.enumValue = this.enumValue;
            builder2.inScope = this.inScope;
            builder2.aSwitch = this.aSwitch;
            builder2.validSwitchValues = new ArrayList<ASN1Encodable>(this.validSwitchValues);
            builder2.elementSupplier = this.elementSupplier;
            builder2.mayRecurse = this.mayRecurse;
            builder2.typeName = this.typeName;
            builder2.supplierMap = new HashMap<String, ElementSupplier>(this.supplierMap);
            builder2.block = this.block;
            return builder2;
        }

        protected Builder block(int n) {
            Builder builder2 = this.copy();
            builder2.block = n;
            return builder2;
        }

        public Builder copy() {
            return this.copy(this.defaultItemProvider);
        }

        public Builder elementSupplier(ElementSupplier elementSupplier) {
            Builder builder2 = this.copy();
            builder2.elementSupplier = elementSupplier;
            return builder2;
        }

        public Builder validSwitchValue(ASN1Encodable ... aSN1EncodableArray) {
            Builder builder2 = this.copy();
            builder2.validSwitchValues.addAll(Arrays.asList(aSN1EncodableArray));
            return builder2;
        }

        public Builder inScope(boolean bl) {
            Builder builder2 = this.copy();
            builder2.inScope = bl;
            return builder2;
        }

        public Builder limitScopeTo(String ... stringArray) {
            Builder builder2 = this.copy();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList(stringArray));
            ArrayList<Builder> arrayList = new ArrayList<Builder>();
            for (Builder builder3 : this.children) {
                arrayList.add(builder3.copy().inScope(hashSet.contains(builder3.label)));
            }
            builder2.children = arrayList;
            return builder2;
        }

        public Builder typeName(String string) {
            Builder builder2 = this.copy();
            builder2.typeName = string;
            if (builder2.label == null) {
                builder2.label = string;
            }
            return builder2;
        }

        public Builder unbounded() {
            Builder builder2 = this.copy();
            builder2.lowerBound = null;
            builder2.upperBound = null;
            return builder2;
        }

        public Builder decodeSwitch(Switch switch_) {
            Builder builder2 = this.copy();
            builder2.aSwitch = switch_;
            return builder2;
        }

        public Builder labelPrefix(String string) {
            Builder builder2 = this.copy();
            builder2.label = string + " " + this.label;
            return builder2;
        }

        public Builder explicit(boolean bl) {
            Builder builder2 = this.copy();
            builder2.explicit = bl;
            return builder2;
        }

        public Builder defaultValue(ASN1Encodable aSN1Encodable) {
            Builder builder2 = this.copy();
            builder2.defaultValue = aSN1Encodable;
            return builder2;
        }

        protected Builder wrap(boolean bl, Object object) {
            if (object instanceof Builder) {
                return ((Builder)object).explicit(bl);
            }
            if (object instanceof BaseType) {
                return new Builder((BaseType)((Object)object)).explicit(bl);
            }
            if (object instanceof String) {
                return OERDefinition.enumItem((String)object);
            }
            throw new IllegalStateException("Unable to wrap item in builder");
        }

        protected void addExtensions(Builder builder2, ExtensionList extensionList) {
            if (extensionList.isEmpty()) {
                Builder builder3 = new Builder(BaseType.EXTENSION);
                builder3.block = extensionList.block;
                builder2.children.add(builder3);
                return;
            }
            for (Object e : extensionList) {
                if (e instanceof OptionalList) {
                    this.addOptionals(builder2, extensionList.block, (OptionalList)e);
                    continue;
                }
                Builder builder4 = this.wrap(true, e);
                builder4.block = extensionList.block;
                builder2.children.add(builder4);
            }
        }

        protected void addOptionals(Builder builder2, int n, OptionalList optionalList) {
            for (Object e : optionalList) {
                if (e instanceof ExtensionList) {
                    this.addExtensions(builder2, (ExtensionList)e);
                    continue;
                }
                Builder builder3 = this.wrap(false, e);
                builder3.block = n;
                builder2.children.add(builder3);
            }
        }

        public Builder items(Object ... objectArray) {
            Builder builder2 = this.copy();
            for (int i = 0; i != objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof ExtensionList) {
                    this.addExtensions(builder2, (ExtensionList)object);
                    continue;
                }
                if (object instanceof OptionalList) {
                    this.addOptionals(builder2, builder2.block, (OptionalList)object);
                    continue;
                }
                if (object.getClass().isArray()) {
                    for (int j = 0; j < ((Object[])object).length; ++j) {
                        builder2.children.add(this.wrap(true, ((Object[])object)[j]));
                    }
                    continue;
                }
                builder2.children.add(this.wrap(true, object));
            }
            return builder2;
        }

        public Builder label(String string) {
            Builder builder2 = this.copy();
            builder2.label = string;
            return builder2;
        }

        public Builder mayRecurse(boolean bl) {
            Builder builder2 = this.copy();
            builder2.mayRecurse = bl;
            return builder2;
        }

        public Element build() {
            int n;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            boolean bl = false;
            if (this.baseType == BaseType.ENUM) {
                n = 0;
                HashSet<BigInteger> hashSet = new HashSet<BigInteger>();
                for (int i = 0; i < this.children.size(); ++i) {
                    Builder builder2 = this.children.get(i);
                    if (builder2.enumValue == null) {
                        builder2.enumValue = BigInteger.valueOf(n);
                        ++n;
                    }
                    if (hashSet.contains(builder2.enumValue)) {
                        throw new IllegalStateException("duplicate enum value at index " + i);
                    }
                    hashSet.add(builder2.enumValue);
                }
            }
            n = 0;
            boolean bl2 = false;
            for (Builder builder2 : this.children) {
                if (!bl && builder2.block > 0) {
                    bl = true;
                }
                if (!builder2.explicit) {
                    ++n;
                }
                if (!bl2 && builder2.defaultValue != null) {
                    bl2 = true;
                }
                arrayList.add(builder2.build());
            }
            return new Element(this.baseType, arrayList, this.defaultValue == null && this.explicit, this.label, this.lowerBound, this.upperBound, bl, this.enumValue, this.defaultValue, this.aSwitch, this.validSwitchValues.isEmpty() ? null : this.validSwitchValues, this.elementSupplier, this.mayRecurse, this.typeName, this.supplierMap.isEmpty() ? null : this.supplierMap, this.block, n, bl2);
        }

        public Builder range(BigInteger bigInteger, BigInteger bigInteger2) {
            Builder builder2 = this.copy();
            builder2.lowerBound = bigInteger;
            builder2.upperBound = bigInteger2;
            return builder2;
        }

        public Builder rangeToMAXFrom(long l) {
            Builder builder2 = this.copy();
            builder2.lowerBound = BigInteger.valueOf(l);
            builder2.upperBound = null;
            return builder2;
        }

        public Builder rangeZeroTo(long l) {
            Builder builder2 = this.copy();
            builder2.upperBound = BigInteger.valueOf(l);
            builder2.lowerBound = BigInteger.ZERO;
            return builder2;
        }

        public Builder fixedSize(long l) {
            Builder builder2 = this.copy();
            builder2.upperBound = BigInteger.valueOf(l);
            builder2.lowerBound = BigInteger.valueOf(l);
            return builder2;
        }

        public Builder range(long l, long l2, ASN1Encodable aSN1Encodable) {
            Builder builder2 = this.copy();
            builder2.lowerBound = BigInteger.valueOf(l);
            builder2.upperBound = BigInteger.valueOf(l2);
            builder2.defaultValue = aSN1Encodable;
            return builder2;
        }

        public Builder enumValue(BigInteger bigInteger) {
            Builder builder2 = this.copy();
            this.enumValue = bigInteger;
            return builder2;
        }

        public Builder replaceChild(final int n, final Builder builder2) {
            return this.copy(new ItemProvider(){

                @Override
                public Builder existingChild(int n2, Builder builder22) {
                    return n == n2 ? builder2 : builder22;
                }
            });
        }
    }

    private static class ExtensionList
    extends ArrayList<Object> {
        protected final int block;

        public ExtensionList(int n, List<Object> list) {
            this.block = n;
            this.addAll(list);
        }
    }

    public static interface ItemProvider {
        public Builder existingChild(int var1, Builder var2);
    }

    public static class MutableBuilder
    extends Builder {
        private boolean frozen = false;

        public MutableBuilder(BaseType baseType) {
            super(baseType);
        }

        @Override
        public MutableBuilder label(String string) {
            this.label = string;
            return this;
        }

        public MutableBuilder addItemsAndFreeze(Builder ... builderArray) {
            if (this.frozen) {
                throw new IllegalStateException("build cannot be modified and must be copied only");
            }
            for (int i = 0; i != builderArray.length; ++i) {
                Builder builder2 = builderArray[i];
                if (builder2 instanceof OptionalList) {
                    Object[] objectArray = ((List)((Object)builder2)).iterator();
                    while (objectArray.hasNext()) {
                        this.children.add(this.wrap(false, objectArray.next()));
                    }
                    continue;
                }
                if (builder2.getClass().isArray()) {
                    for (Object object : (Object[])builder2) {
                        this.children.add(this.wrap(true, object));
                    }
                    continue;
                }
                this.children.add(this.wrap(true, builder2));
            }
            this.frozen = true;
            return this;
        }
    }

    private static class OptionalList
    extends ArrayList<Object> {
        public OptionalList(List<Object> list) {
            this.addAll(list);
        }
    }
}

