/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.app.Outproxy;
import net.i2p.client.naming.NamingService;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnelHTTPServer;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSUDPTunnel;
import net.i2p.i2ptunnel.socks.SocketWrapper;
import net.i2p.socks.SOCKS5Client;
import net.i2p.socks.SOCKSException;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;
import net.i2p.util.LHMCache;
import net.i2p.util.PasswordManager;
import net.i2p.util.SipHash;

class SOCKS5Server
extends SOCKSServer {
    private boolean setupCompleted;
    private final boolean authRequired;
    private static final Map<String, String> _torCache = new LHMCache<String, String>(256);
    private static final String[] _skipHeaders = new String[0];
    private static SOCKSUDPTunnel _tunnel;
    private static final Object _startLock;
    private static final byte[] dummyIP;

    public SOCKS5Server(I2PAppContext ctx, Socket clientSock, Properties props) {
        super(ctx, clientSock, props);
        this.authRequired = Boolean.parseBoolean(props.getProperty("proxyAuth"));
    }

    @Override
    public Socket getClientSocket() throws SOCKSException {
        this.setupServer();
        return this.clientSock;
    }

    @Override
    protected void setupServer() throws SOCKSException {
        if (this.setupCompleted) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(this.clientSock.getInputStream());
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.init(in, out, this.clientSock.getInetAddress());
            if (this.manageRequest(in, out) == 3) {
                this.handleUDP(in, out);
            }
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error", e);
        }
        this.setupCompleted = true;
    }

    private void init(DataInputStream in, DataOutputStream out, InetAddress client) throws IOException {
        int nMethods = in.readUnsignedByte();
        int method = 255;
        for (int i = 0; i < nMethods; ++i) {
            int meth = in.readUnsignedByte();
            if ((this.authRequired || meth != 0) && meth != 2) continue;
            method = meth;
            break;
        }
        switch (method) {
            case 2: {
                this._log.debug("username/password authentication required");
                this.sendInitReply(2, out);
                this.verifyPassword(in, out, client);
                return;
            }
            case 0: {
                this._log.debug("no authentication required");
                this.sendInitReply(0, out);
                return;
            }
        }
        this._log.debug("no suitable authentication methods found (" + Integer.toHexString(method) + ")");
        this.sendInitReply(255, out);
        throw new SOCKSException("Unsupported authentication method");
    }

    private void verifyPassword(DataInputStream in, DataOutputStream out, InetAddress client) throws IOException {
        int c = in.readUnsignedByte();
        if (c != 1) {
            this._log.logAlways(30, "SOCKS proxy authentication failed");
            throw new SOCKSException("Unsupported authentication version");
        }
        c = in.readUnsignedByte();
        if (c <= 0) {
            this._log.logAlways(30, "SOCKS proxy authentication failed");
            throw new SOCKSException("Bad authentication");
        }
        byte[] user = new byte[c];
        in.readFully(user);
        String u = DataHelper.getUTF8(user);
        c = in.readUnsignedByte();
        if (c <= 0) {
            this._log.logAlways(30, "SOCKS proxy authentication failed, user: " + u + " IP: " + client);
            throw new SOCKSException("Bad authentication");
        }
        byte[] pw = new byte[c];
        in.readFully(pw);
        if (this.authRequired) {
            String p = DataHelper.getUTF8(pw);
            String psha256 = "proxy.auth." + u + ".sha256";
            String configPW = this.props.getProperty(psha256);
            String hex = PasswordManager.sha256Hex("I2P SOCKS Proxy", u, p);
            if (configPW == null || !configPW.equals(hex)) {
                this._log.logAlways(30, "SOCKS proxy authentication failed, user: " + u + " IP: " + client);
                this.sendAuthReply(1, out);
                throw new SOCKSException("SOCKS authorization failure");
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("SOCKS authorization success, user: \"" + u + '\"');
        }
        this.sendAuthReply(0, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int manageRequest(DataInputStream in, DataOutputStream out) throws IOException {
        int socksVer = in.readUnsignedByte();
        if (socksVer != 5) {
            if (this._log.shouldDebug()) {
                this._log.debug("error in SOCKS5 request (protocol != 5?)");
            }
            throw new SOCKSException("Invalid protocol version in request: " + socksVer);
        }
        int command = in.readUnsignedByte();
        switch (command) {
            case 1: {
                break;
            }
            case 2: {
                if (this._log.shouldDebug()) {
                    this._log.debug("BIND command is not supported!");
                }
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("BIND command not supported");
            }
            case 3: {
                break;
            }
            case 240: {
                break;
            }
            case 241: 
            case 242: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Tor command unsupported (" + Integer.toHexString(command) + ")");
                }
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("Unsupported command in request");
            }
            default: {
                if (this._log.shouldDebug()) {
                    this._log.debug("unknown command in request (" + Integer.toHexString(command) + ")");
                }
                this.sendRequestReply(7, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("Unsupported command in request");
            }
        }
        in.readByte();
        this.addressType = in.readUnsignedByte();
        switch (this.addressType) {
            case 1: {
                byte[] ip = new byte[4];
                in.readFully(ip);
                this.connHostName = Addresses.toString(ip);
                String mappedDomainName = this.getMappedDomainNameForIP(this.connHostName);
                if (mappedDomainName != null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("IPV4 address " + this.connHostName + " was mapped to domain name " + mappedDomainName);
                    }
                    this.addressType = 3;
                    this.connHostName = mappedDomainName;
                    break;
                }
                if (command == 3 || !this._log.shouldWarn()) break;
                this._log.warn("IPV4 address type in request: " + this.connHostName + ". Is your client secure?");
                break;
            }
            case 3: {
                int addrLen = in.readUnsignedByte();
                if (addrLen == 0) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("0-sized address length?");
                    }
                    throw new SOCKSException("Illegal DOMAINNAME length");
                }
                byte[] addr = new byte[addrLen];
                in.readFully(addr);
                String host = DataHelper.getUTF8(addr);
                if (command == 240) {
                    String old;
                    int hash = SipHash.hashCode(addr) & 0xFFFFFF;
                    byte[] fake = new byte[4];
                    fake[0] = -1;
                    DataHelper.toLong(fake, 1, 3, hash);
                    String fakeIP = Addresses.toString(fake);
                    Map<String, String> map = _torCache;
                    synchronized (map) {
                        old = _torCache.put(fakeIP, host);
                    }
                    if (old != null && !old.equals(host) && this._log.shouldWarn()) {
                        this._log.warn("Hash collision " + old + " and " + host);
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Cached host " + host + " at address " + fakeIP);
                    }
                    this.sendRequestReply(0, 1, InetAddress.getByName(fakeIP), null, 1, out);
                    throw new SOCKSException("ignore");
                }
                if (host.startsWith("255.")) {
                    Map<String, String> map = _torCache;
                    synchronized (map) {
                        this.connHostName = _torCache.get(host);
                    }
                    if (this.connHostName == null) {
                        this.sendRequestReply(8, 3, null, "0.0.0.0", 0, out);
                        throw new SOCKSException("No cache entry found for Tor IP " + host);
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Using hostname from previous RESOLVE: " + this.connHostName);
                    }
                } else {
                    this.connHostName = host;
                }
                if (!this._log.shouldDebug()) break;
                this._log.debug("DOMAINNAME address type in request: " + this.connHostName);
                break;
            }
            case 4: {
                if (command == 3) break;
                byte[] ip = new byte[16];
                in.readFully(ip);
                this.connHostName = Addresses.toString(ip);
                if (!this._log.shouldWarn()) break;
                this._log.warn("IPV6 address type in request! Is your client secure?");
                break;
            }
            default: {
                if (this._log.shouldDebug()) {
                    this._log.debug("unknown address type in request (" + Integer.toHexString(command) + ")");
                }
                this.sendRequestReply(8, 3, null, "0.0.0.0", 0, out);
                throw new SOCKSException("Invalid addresses type in request");
            }
        }
        this.connPort = in.readUnsignedShort();
        if (this.connPort == 0) {
            if (this._log.shouldDebug()) {
                this._log.debug("trying to connect to TCP port 0?  Dropping!");
            }
            this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
            throw new SOCKSException("Invalid port number in request");
        }
        return command;
    }

    @Override
    protected void confirmConnection() throws SOCKSException {
        try {
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.sendRequestReply(0, 1, InetAddress.getByName("127.0.0.1"), null, 1, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error", e);
        }
    }

    private void sendInitReply(int replyCode, DataOutputStream out) throws IOException {
        byte[] reply = new byte[]{5, (byte)replyCode};
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending init reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    private void sendAuthReply(int replyCode, DataOutputStream out) throws IOException {
        byte[] reply = new byte[]{1, (byte)replyCode};
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending auth reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    private void sendRequestReply(int replyCode, int addressType, InetAddress inetAddr, String domainName, int bindPort, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        DataOutputStream dreps = new DataOutputStream(reps);
        dreps.write(5);
        dreps.write(replyCode);
        dreps.write(0);
        dreps.write(addressType);
        switch (addressType) {
            case 1: 
            case 4: {
                dreps.write(inetAddr.getAddress());
                break;
            }
            case 3: {
                dreps.writeByte(domainName.length());
                dreps.writeBytes(domainName);
                break;
            }
            default: {
                this._log.error("unknown address type passed to sendReply() (" + Integer.toHexString(addressType) + ")!");
                return;
            }
        }
        dreps.writeShort(bindPort);
        byte[] reply = reps.toByteArray();
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending request reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    @Override
    public I2PSocket getDestinationI2PSocket(I2PSOCKSTunnel t) throws SOCKSException {
        I2PSocket destSock;
        DataOutputStream out;
        this.setupServer();
        if (this.connHostName == null) {
            this._log.error("BUG: destination hostname has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        if (this.connPort == 0) {
            this._log.error("BUG: destination port has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        try {
            out = new DataOutputStream(this.clientSock.getOutputStream());
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error", e);
        }
        try {
            String hostLowerCase = this.connHostName.toLowerCase(Locale.US);
            if (NamingService.isI2PHost(hostLowerCase)) {
                I2PSocketOptions sktOpts;
                Destination dest = this._context.namingService().lookup(this.connHostName);
                if (dest == null) {
                    try {
                        this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new SOCKSException("Host not found");
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("connecting to " + this.connHostName + "...");
                }
                Properties overrides = new Properties();
                try {
                    sktOpts = t.buildOptions(overrides);
                }
                catch (RuntimeException re) {
                    this._log.error("socks error", re);
                    try {
                        this.sendRequestReply(1, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw re;
                }
                sktOpts.setPort(this.connPort);
                destSock = t.createI2PSocket(dest, sktOpts);
            } else {
                if (hostLowerCase.equals("localhost") || this.connHostName.equals("127.0.0.1") || hostLowerCase.endsWith(".localhost") || this.connHostName.startsWith("192.168.") || this.connHostName.equals("[::1]")) {
                    String err = "No localhost accesses allowed through the Socks Proxy";
                    this._log.error(err);
                    try {
                        this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException overrides) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                Outproxy outproxy = this.getOutproxyPlugin();
                if (outproxy != null) {
                    try {
                        destSock = new SocketWrapper(outproxy.connect(this.connHostName, this.connPort));
                    }
                    catch (IOException ioe) {
                        try {
                            this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
                        }
                        catch (IOException sktOpts) {
                            // empty catch block
                        }
                        throw new SOCKSException("connect failed via outproxy plugin", ioe);
                    }
                }
                List<String> proxies = t.getProxies(this.connPort);
                if (proxies == null || proxies.isEmpty()) {
                    String err = "No outproxy configured for port " + this.connPort + " and no default configured either";
                    this._log.error(err);
                    try {
                        this.sendRequestReply(2, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException re) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                int p = this._context.random().nextInt(proxies.size());
                String proxy = proxies.get(p);
                try {
                    destSock = this.outproxyConnect(t, proxy);
                }
                catch (RuntimeException re) {
                    this._log.error("socks error", re);
                    try {
                        this.sendRequestReply(1, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw re;
                }
                catch (SOCKSException se) {
                    try {
                        this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw se;
                }
            }
            this.confirmConnection();
            this._log.debug("connection confirmed - exchanging data...");
        }
        catch (DataFormatException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("socks error", e);
            }
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SOCKSException("Error in destination format");
        }
        catch (IOException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("socks error", e);
            }
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SOCKSException("Connection error", e);
        }
        catch (I2PException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("socks error", e);
            }
            try {
                this.sendRequestReply(4, 3, null, "0.0.0.0", 0, out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SOCKSException("Connection error", e);
        }
        return destSock;
    }

    private I2PSocket outproxyConnect(I2PSOCKSTunnel tun, String proxy) throws IOException, I2PException {
        Destination dest;
        Properties overrides = new Properties();
        overrides.setProperty("option.i2p.streaming.connectDelay", "200");
        I2PSocketOptions proxyOpts = tun.buildOptions(overrides);
        int proxyPort = 0;
        int colon = proxy.indexOf(58);
        if (colon > 0) {
            try {
                proxyPort = Integer.parseInt(proxy.substring(colon + 1));
                if (proxyPort > 0) {
                    proxyOpts.setPort(proxyPort);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            proxy = proxy.substring(0, colon);
        }
        if ((dest = this._context.namingService().lookup(proxy)) == null) {
            throw new SOCKSException("Outproxy not found");
        }
        I2PSocket destSock = tun.createI2PSocket(dest, proxyOpts);
        OutputStream out = null;
        InputStream in = null;
        try {
            out = destSock.getOutputStream();
            boolean authAvail = Boolean.parseBoolean(this.props.getProperty("outproxyAuth"));
            String configUser = null;
            String configPW = null;
            if (authAvail) {
                configUser = this.props.getProperty("outproxyUsername." + proxy);
                configPW = this.props.getProperty("outproxyPassword." + proxy);
                if (configUser == null || configPW == null) {
                    configUser = this.props.getProperty("outproxyUsername");
                    configPW = this.props.getProperty("outproxyPassword");
                }
            }
            boolean https = "connect".equals(this.props.getProperty("outproxyType"));
            if (this._log.shouldLog(10)) {
                this._log.debug("connecting to " + (https ? "HTTPS" : "SOCKS") + " outproxy " + proxy + " for " + this.connHostName + " port " + this.connPort);
            }
            if (https) {
                this.httpsConnect(destSock, out, this.connHostName, this.connPort, configUser, configPW);
            } else {
                in = destSock.getInputStream();
                SOCKS5Client.connect(in, out, this.connHostName, this.connPort, configUser, configPW);
            }
        }
        catch (IOException e) {
            try {
                destSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
        return destSock;
    }

    public void httpsConnect(I2PSocket destSock, OutputStream pout, String connHostName, int connPort, String configUser, String configPW) throws IOException {
        StringBuilder buf = new StringBuilder(64);
        buf.append("CONNECT ");
        boolean v6 = connHostName.contains(":");
        if (v6) {
            buf.append('[');
        }
        buf.append(connHostName);
        if (v6) {
            buf.append(']');
        }
        buf.append(':');
        buf.append(connPort);
        buf.append(" HTTP/1.1\r\n\r\n");
        if (this._log.shouldDebug()) {
            this._log.debug("Request to outproxy: " + buf);
        }
        pout.write(DataHelper.getASCII(buf.toString()));
        pout.flush();
        buf.setLength(0);
        I2PTunnelHTTPServer.readHeaders(destSock, null, buf, _skipHeaders, this._context, 15000L);
        String[] f = DataHelper.split(buf.toString(), " ", 2);
        if (f.length < 2) {
            throw new IOException("Bad response from proxy");
        }
        if (!f[1].startsWith("200 ")) {
            throw new IOException("Error from proxy: " + f[1]);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Response from proxy: " + buf);
        }
    }

    /*
     * Exception decompiling
     */
    private void handleUDP(DataInputStream in, DataOutputStream out) throws SOCKSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        _startLock = new Object();
        dummyIP = new byte[4];
    }
}

