/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.dnd.DropTargetGlassPane;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.openide.windows.TopComponent;

final class KeyboardDnd
implements AWTEventListener,
PropertyChangeListener {
    private static KeyboardDnd currentDnd;
    private final WindowDnDManager dndManager;
    private final TopComponentDraggable draggable;
    private final WindowDnDManager.ViewAccessor viewAccessor;
    private final ArrayList<TopComponentDroppable> targets = new ArrayList(30);
    private int currentIndex;
    private ComponentSide currentSide = new ComponentSide(Side.center);
    private DropTargetGlassPane lastGlass = null;

    private KeyboardDnd(WindowDnDManager windowDnDManager, TopComponentDraggable topComponentDraggable, WindowDnDManager.ViewAccessor viewAccessor) {
        this.dndManager = windowDnDManager;
        this.draggable = topComponentDraggable;
        this.viewAccessor = viewAccessor;
    }

    static void start(WindowDnDManager windowDnDManager, TopComponentDraggable topComponentDraggable, WindowDnDManager.ViewAccessor viewAccessor) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called from EDT.");
        }
        if (null != currentDnd) {
            currentDnd.stop(false);
            currentDnd = null;
        }
        currentDnd = new KeyboardDnd(windowDnDManager, topComponentDraggable, viewAccessor);
        currentDnd.start();
    }

    private void start() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.dndManager.dragStarting(null, new Point(0, 0), this.draggable);
        for (Component component : this.viewAccessor.getModeComponents()) {
            TopComponentDroppable topComponentDroppable;
            TopComponent topComponent;
            ModeComponent modeComponent;
            ModeView modeView;
            if (!(component instanceof ModeComponent) || !(component instanceof TopComponentDroppable) || (modeView = (modeComponent = (ModeComponent)((Object)component)).getModeView()) instanceof SlidingView || null == (topComponent = modeView.getSelectedTopComponent()) || !(topComponentDroppable = (TopComponentDroppable)((Object)component)).supportsKind(this.draggable)) continue;
            this.targets.add(topComponentDroppable);
        }
        this.targets.sort(new Comparator<TopComponentDroppable>(){

            @Override
            public int compare(TopComponentDroppable topComponentDroppable, TopComponentDroppable topComponentDroppable2) {
                boolean bl = KeyboardDnd.isDroppableFloating(topComponentDroppable);
                boolean bl2 = KeyboardDnd.isDroppableFloating(topComponentDroppable2);
                if (bl && !bl2) {
                    return 1;
                }
                if (!bl && bl2) {
                    return -1;
                }
                if (!topComponentDroppable.getDropComponent().isShowing() || !topComponentDroppable2.getDropComponent().isShowing()) {
                    return 0;
                }
                Point point = topComponentDroppable.getDropComponent().getLocationOnScreen();
                Point point2 = topComponentDroppable2.getDropComponent().getLocationOnScreen();
                int n = point.x - point2.x;
                if (n == 0) {
                    n = point.y - point2.y;
                }
                return n;
            }
        });
        this.targets.add(this.dndManager.getCenterPanelDroppable());
        this.currentIndex = 0;
        this.refresh();
    }

    static void abort() {
        if (null != currentDnd) {
            currentDnd.stop(false);
        }
    }

    private void refresh() {
        TopComponentDroppable topComponentDroppable = this.targets.get(this.currentIndex);
        DropTargetGlassPane dropTargetGlassPane = this.findGlassPane(topComponentDroppable);
        if (null == dropTargetGlassPane) {
            return;
        }
        Point point = this.currentSide.getDropLocation(topComponentDroppable);
        point = SwingUtilities.convertPoint(topComponentDroppable.getDropComponent(), point, dropTargetGlassPane);
        dropTargetGlassPane.dragOver(point, topComponentDroppable);
        if (null != this.lastGlass && this.lastGlass != dropTargetGlassPane) {
            this.lastGlass.clearIndications();
        }
        this.lastGlass = dropTargetGlassPane;
    }

    private DropTargetGlassPane findGlassPane(TopComponentDroppable topComponentDroppable) {
        Component component;
        Component component2 = topComponentDroppable.getDropComponent();
        if (component2 instanceof JComponent && (component = ((JComponent)component2).getRootPane().getGlassPane()) instanceof DropTargetGlassPane) {
            return (DropTargetGlassPane)component;
        }
        return null;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        keyEvent.consume();
        if (aWTEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    do {
                        this.currentSide = this.currentSide.moveLeft();
                    } while (!this.checkDropLocation());
                    this.refresh();
                    break;
                }
                case 39: {
                    do {
                        this.currentSide = this.currentSide.moveRight();
                    } while (!this.checkDropLocation());
                    this.refresh();
                    break;
                }
                case 38: {
                    do {
                        this.currentSide = this.currentSide.moveUp();
                    } while (!this.checkDropLocation());
                    this.refresh();
                    break;
                }
                case 40: {
                    do {
                        this.currentSide = this.currentSide.moveDown();
                    } while (!this.checkDropLocation());
                    this.refresh();
                    break;
                }
                case 10: {
                    this.stop(true);
                    break;
                }
                case 27: {
                    KeyboardDnd.abort();
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName()) || "opened".equals(propertyChangeEvent.getPropertyName())) {
            KeyboardDnd.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean bl) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        try {
            Point point;
            TopComponentDroppable topComponentDroppable;
            if (bl && (topComponentDroppable = this.targets.get(this.currentIndex)).canDrop(this.draggable, point = this.currentSide.getDropLocation(topComponentDroppable))) {
                WindowDnDManager.performDrop(this.dndManager.getController(), topComponentDroppable, this.draggable, point);
            }
        }
        finally {
            this.dndManager.dragFinished();
            this.dndManager.dragFinishedEx();
            if (currentDnd == this) {
                currentDnd = null;
            }
        }
    }

    private boolean checkDropLocation() {
        TopComponentDroppable topComponentDroppable = this.targets.get(this.currentIndex);
        DropTargetGlassPane dropTargetGlassPane = this.findGlassPane(topComponentDroppable);
        if (null == dropTargetGlassPane) {
            return false;
        }
        Point point = this.currentSide.getDropLocation(topComponentDroppable);
        if (!topComponentDroppable.canDrop(this.draggable, point)) {
            return false;
        }
        return topComponentDroppable.getIndicationForLocation(point) != null;
    }

    private void decrementIndex() {
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = this.targets.size() - 1;
        }
    }

    private void incrementIndex() {
        ++this.currentIndex;
        if (this.currentIndex > this.targets.size() - 1) {
            this.currentIndex = 0;
        }
    }

    private boolean isCurrentDroppableFloating() {
        TopComponentDroppable topComponentDroppable = this.targets.get(this.currentIndex);
        return KeyboardDnd.isDroppableFloating(topComponentDroppable);
    }

    private static boolean isDroppableFloating(TopComponentDroppable topComponentDroppable) {
        return topComponentDroppable instanceof JDialog;
    }

    private static enum Side {
        left,
        right,
        top,
        bottom,
        center;

    }

    private class ComponentSide {
        private final Side side;

        public ComponentSide(Side side) {
            this.side = side;
        }

        ComponentSide moveLeft() {
            if (KeyboardDnd.this.isCurrentDroppableFloating()) {
                KeyboardDnd.this.decrementIndex();
                return new ComponentSide(Side.center);
            }
            switch (this.side) {
                case right: {
                    return new ComponentSide(Side.center);
                }
                case left: {
                    KeyboardDnd.this.decrementIndex();
                    return new ComponentSide(Side.right);
                }
            }
            return new ComponentSide(Side.left);
        }

        ComponentSide moveRight() {
            if (KeyboardDnd.this.isCurrentDroppableFloating()) {
                KeyboardDnd.this.incrementIndex();
                return new ComponentSide(Side.center);
            }
            switch (this.side) {
                case right: {
                    KeyboardDnd.this.incrementIndex();
                    return new ComponentSide(Side.left);
                }
                case left: {
                    return new ComponentSide(Side.center);
                }
            }
            return new ComponentSide(Side.right);
        }

        ComponentSide moveDown() {
            if (KeyboardDnd.this.isCurrentDroppableFloating()) {
                KeyboardDnd.this.incrementIndex();
                return new ComponentSide(Side.center);
            }
            switch (this.side) {
                case bottom: {
                    KeyboardDnd.this.incrementIndex();
                    return new ComponentSide(Side.top);
                }
                case top: {
                    return new ComponentSide(Side.center);
                }
            }
            return new ComponentSide(Side.bottom);
        }

        ComponentSide moveUp() {
            if (KeyboardDnd.this.isCurrentDroppableFloating()) {
                KeyboardDnd.this.decrementIndex();
                return new ComponentSide(Side.center);
            }
            switch (this.side) {
                case top: {
                    KeyboardDnd.this.decrementIndex();
                    return new ComponentSide(Side.top);
                }
                case bottom: {
                    return new ComponentSide(Side.center);
                }
            }
            return new ComponentSide(Side.top);
        }

        Point getDropLocation(TopComponentDroppable topComponentDroppable) {
            Point point = this.getDropLocation(topComponentDroppable, 30);
            Shape shape = topComponentDroppable.getIndicationForLocation(point);
            if (null == shape) {
                point = this.getDropLocation(topComponentDroppable, 5);
            }
            return point;
        }

        Point getDropLocation(TopComponentDroppable topComponentDroppable, int n) {
            Dimension dimension = topComponentDroppable.getDropComponent().getSize();
            Point point = new Point();
            switch (this.side) {
                case center: {
                    point.x = dimension.width / 2;
                    point.y = dimension.height / 2;
                    break;
                }
                case top: {
                    point.x = dimension.width / 2;
                    point.y = n;
                    break;
                }
                case bottom: {
                    point.x = dimension.width / 2;
                    point.y = dimension.height - n;
                    break;
                }
                case left: {
                    point.x = n;
                    point.y = dimension.height / 2;
                    break;
                }
                case right: {
                    point.x = dimension.width - n;
                    point.y = dimension.height / 2;
                }
            }
            return point;
        }
    }
}

