/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.client.oauth2;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public final class DeviceCodeResponseDTO
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4261783375996959200L;
    private String deviceCode;
    private long expiresIn;
    private Long interval;
    private String userCode;
    private String verificationUri;
    private String verificationUriComplete;
    private Instant createdOn;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("not possible", e);
        }
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public Long getInterval() {
        return this.interval;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getVerificationUri() {
        return this.verificationUri;
    }

    public String getVerificationUriComplete() {
        return this.verificationUriComplete;
    }

    public boolean isExpired(Instant givenTime, int tokenExpiresInBuffer) {
        return this.createdOn == null || this.createdOn.plusSeconds(this.expiresIn).minusSeconds(tokenExpiresInBuffer).isBefore(givenTime);
    }

    public void setCreatedOn(Instant createdOn) {
        this.createdOn = createdOn;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setVerificationUri(String verificationUri) {
        this.verificationUri = verificationUri;
    }

    public void setVerificationUriComplete(String verificationUriComplete) {
        this.verificationUriComplete = verificationUriComplete;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceCodeResponseDTO other = (DeviceCodeResponseDTO)obj;
        return Objects.equals(this.createdOn, other.createdOn) && Objects.equals(this.deviceCode, other.deviceCode) && this.expiresIn == other.expiresIn && Objects.equals(this.interval, other.interval) && Objects.equals(this.userCode, other.userCode) && Objects.equals(this.verificationUri, other.verificationUri) && Objects.equals(this.verificationUriComplete, other.verificationUriComplete);
    }

    public int hashCode() {
        return Objects.hash(this.createdOn, this.deviceCode, this.expiresIn, this.interval, this.userCode, this.verificationUri, this.verificationUriComplete);
    }

    public String toString() {
        return "DeviceCodeResponseDTO [deviceCode=" + this.deviceCode + ", expiresIn=" + this.expiresIn + ", interval=" + String.valueOf(this.interval) + ", userCode=" + this.userCode + ", verificationUri=" + this.verificationUri + ", verificationUriComplete=" + this.verificationUriComplete + ", createdOn=" + String.valueOf(this.createdOn) + "]";
    }
}

