/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ValueTypeDescriptor;

public class AttributeDescriptorImpl<T>
implements AttributeDescriptor<T> {
    private final String name;
    private final Method method;
    private final ValueTypeDescriptor<T> typeDescriptor;

    public AttributeDescriptorImpl(Class<? extends Annotation> annotationType, String name, ValueTypeDescriptor<T> typeDescriptor) {
        this.name = name;
        this.typeDescriptor = typeDescriptor;
        try {
            this.method = annotationType.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ModelsException("Could not locate annotation attribute method - " + name, e);
        }
    }

    public AttributeDescriptorImpl(Method method, ValueTypeDescriptor<T> typeDescriptor) {
        this.name = method.getName();
        this.method = method;
        this.typeDescriptor = typeDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValueTypeDescriptor<T> getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public Method getAttributeMethod() {
        return this.method;
    }

    public String toString() {
        return String.format(Locale.ROOT, "AttributeDescriptor(%s : %s)", this.name, this.getTypeDescriptor().getValueType().getName());
    }
}

