/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.mapviewer.MapViewer;
import net.sf.freecol.client.gui.mapviewer.MapViewerBounds;
import net.sf.freecol.client.gui.mapviewer.TileBounds;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.util.Utils;

public final class MapAsyncPainter {
    private static final Logger logger = Logger.getLogger(MapAsyncPainter.class.getName());
    private static final boolean DEBUG_ASYNC_EVENTS_TO_STDOUT = false;
    private MapViewer mapViewer;
    private volatile Direction scrollDirection = null;
    private final MapRendererThread mapRendererThread;
    private final Object consumptionLock = new Object();
    private volatile boolean aborted = false;
    private volatile boolean consumed = true;
    private volatile boolean consumerIgnoresOldBuffer = true;
    private volatile long lastRenderTimestamp = System.currentTimeMillis();
    private boolean used = false;
    private Point mapFocusPointBackBuffer;
    private BufferedImage backBufferImage;
    private BufferedImage nextBackBufferImage;
    private final Dimension size;
    private final Dimension origSize;
    private final int scrollBufferSizeInPixels;
    private final int keepScrollPixelsForChangingDirection;

    public MapAsyncPainter(MapViewer mapViewer) {
        MapViewerBounds mvb = mapViewer.getMapViewerBounds();
        TileBounds tb = mvb.getTileBounds();
        this.mapViewer = mapViewer;
        this.origSize = mvb.getSize();
        this.scrollBufferSizeInPixels = tb.getWidth() * 2;
        this.size = new Dimension(this.origSize.width + this.scrollBufferSizeInPixels * 2, this.origSize.height + this.scrollBufferSizeInPixels * 2);
        this.keepScrollPixelsForChangingDirection = tb.getWidth();
        this.mapFocusPointBackBuffer = mvb.getFocusMapPoint();
        this.backBufferImage = Utils.getGoodGraphicsDevice().getDefaultConfiguration().createCompatibleImage(this.size.width, this.size.height, 1);
        this.nextBackBufferImage = Utils.getGoodGraphicsDevice().getDefaultConfiguration().createCompatibleImage(this.size.width, this.size.height, 1);
        this.mapRendererThread = new MapRendererThread(this.size, tb, mvb.getFocus(), this.mapFocusPointBackBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getBackBufferImage() {
        while (true) {
            Object object = this.consumptionLock;
            synchronized (object) {
                try {
                    while (this.consumed) {
                        if (this.aborted) {
                            return null;
                        }
                        this.consumptionLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.aborted) {
                return null;
            }
            long now = System.currentTimeMillis();
            Point newFocus = this.getNewFocusPoint(now);
            int xDiff = newFocus.x - this.mapFocusPointBackBuffer.x;
            int yDiff = newFocus.y - this.mapFocusPointBackBuffer.y;
            int focusInBufferX = this.size.width / 2 + xDiff;
            int focusInBufferY = this.size.height / 2 + yDiff;
            int x = focusInBufferX - this.origSize.width / 2;
            int y = focusInBufferY - this.origSize.height / 2;
            if (x >= 0 && y >= 0 && x + this.origSize.width <= this.size.width && y + this.origSize.height <= this.size.height) {
                this.used = true;
                this.lastRenderTimestamp = now;
                this.mapViewer.getMapViewerBounds().setFocusMapPoint(newFocus);
                this.consumerIgnoresOldBuffer = false;
                return this.backBufferImage.getSubimage(x, y, this.origSize.width, this.origSize.height);
            }
            if (!this.used) {
                this.consumerIgnoresOldBuffer = true;
            }
            this.consumed = true;
            LockSupport.unpark(this.mapRendererThread);
        }
    }

    public void setScrollDirection(Direction scrollDirection) {
        Objects.requireNonNull(scrollDirection, "scrollDirection");
        boolean initialized = this.scrollDirection != null;
        this.scrollDirection = scrollDirection;
        if (!initialized) {
            this.mapRendererThread.start();
        }
        LockSupport.unpark(this.mapRendererThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.aborted = true;
        LockSupport.unpark(this.mapRendererThread);
        Object object = this.consumptionLock;
        synchronized (object) {
            this.consumptionLock.notifyAll();
        }
    }

    public boolean isStopped() {
        return this.aborted;
    }

    private Point getNewFocusPoint(long now) {
        Point newFocus = this.consumerIgnoresOldBuffer ? this.mapViewer.getMapViewerBounds().getFocusMapPoint() : this.determineMapFocusPointOnRender(now);
        return newFocus;
    }

    private static Point plusOffsets(Point point, Direction direction, int offsetX, int offsetY) {
        switch (direction) {
            case N: {
                return new Point(point.x, point.y - offsetY);
            }
            case S: {
                return new Point(point.x, point.y + offsetY);
            }
            case E: {
                return new Point(point.x + offsetX, point.y);
            }
            case W: {
                return new Point(point.x - offsetX, point.y);
            }
            case NW: {
                return new Point(point.x - offsetX, point.y - offsetY);
            }
            case NE: {
                return new Point(point.x + offsetX, point.y - offsetY);
            }
            case SW: {
                return new Point(point.x - offsetX, point.y + offsetY);
            }
            case SE: {
                return new Point(point.x + offsetX, point.y + offsetY);
            }
        }
        throw new IllegalStateException("Unknown direction: " + direction);
    }

    private Point scrollFocusOnOriginalSize(Point point, Direction direction) {
        int offset = this.scrollBufferSizeInPixels - 1 - this.keepScrollPixelsForChangingDirection / 2;
        return MapAsyncPainter.plusOffsets(point, direction, offset, offset);
    }

    private Point scrollFocusOnBufferSize(Point point, Direction direction) {
        int offset = this.scrollBufferSizeInPixels * 2 - 2 - this.keepScrollPixelsForChangingDirection;
        return MapAsyncPainter.plusOffsets(point, direction, offset, offset);
    }

    private Point determineMapFocusPointOnRender(long now) {
        long timeElapsed = now - this.lastRenderTimestamp;
        int divisor = 2;
        int pixelsMoved = (int)(timeElapsed / 2L) + (timeElapsed % 2L >= 1L ? 1 : 0);
        Point newFocus = MapAsyncPainter.plusOffsets(this.mapViewer.getMapViewerBounds().getFocusMapPoint(), this.scrollDirection, pixelsMoved, pixelsMoved);
        return newFocus;
    }

    private final class MapRendererThread
    extends Thread {
        private final MapViewerBounds internalRenderMapViewerBounds = new MapViewerBounds();
        private boolean ignoreOldBuffer = false;

        private MapRendererThread(Dimension size, TileBounds tileBounds, Tile focusTile, Point initialFocus) {
            this.internalRenderMapViewerBounds.changeSize(size, tileBounds);
            this.internalRenderMapViewerBounds.setFocus(focusTile);
            this.internalRenderMapViewerBounds.setFocusMapPoint(initialFocus);
        }

        @Override
        public void run() {
            int MAX_EXCEPTIONS = 100;
            int reportedExceptions = 0;
            while (!MapAsyncPainter.this.aborted) {
                try {
                    this.paint();
                }
                catch (Exception e) {
                    if (reportedExceptions < 100) {
                        logger.log(Level.WARNING, "Unhandled exception while painting.", e);
                        if (++reportedExceptions == 100) {
                            logger.severe("Stopped logging exceptions from the async painting thread since there have been produced too many.");
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private void paint() {
            if (MapAsyncPainter.this.aborted) {
                return;
            }
            long now = System.currentTimeMillis();
            Point newFocus = MapAsyncPainter.this.getNewFocusPoint(now);
            Direction direction = MapAsyncPainter.this.scrollDirection;
            Point nextMapFocusPointBackBuffer = this.produceRenderedImage(newFocus, direction);
            this.ignoreOldBuffer = false;
            while (!MapAsyncPainter.this.consumed && !MapAsyncPainter.this.aborted) {
                if (direction != MapAsyncPainter.this.scrollDirection) {
                    this.ignoreOldBuffer = true;
                    return;
                }
                LockSupport.park();
            }
            if (MapAsyncPainter.this.aborted) {
                return;
            }
            this.deliverRenderedImage(nextMapFocusPointBackBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Point produceRenderedImage(Point newFocus, Direction direction) {
            Point nextMapFocusPointBackBuffer;
            Graphics2D g2d = MapAsyncPainter.this.nextBackBufferImage.createGraphics();
            try {
                nextMapFocusPointBackBuffer = MapAsyncPainter.this.consumerIgnoresOldBuffer || this.ignoreOldBuffer || MapAsyncPainter.this.consumed ? MapAsyncPainter.this.scrollFocusOnOriginalSize(newFocus, direction) : MapAsyncPainter.this.scrollFocusOnBufferSize(MapAsyncPainter.this.mapFocusPointBackBuffer, direction);
                this.internalRenderMapViewerBounds.setFocusMapPoint(nextMapFocusPointBackBuffer);
                MapAsyncPainter.this.mapViewer.paintMap(g2d, MapAsyncPainter.this.size, this.internalRenderMapViewerBounds);
            }
            finally {
                g2d.dispose();
            }
            return nextMapFocusPointBackBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverRenderedImage(Point nextMapFocusPointBackBuffer) {
            BufferedImage next = MapAsyncPainter.this.backBufferImage;
            MapAsyncPainter.this.backBufferImage = MapAsyncPainter.this.nextBackBufferImage;
            MapAsyncPainter.this.nextBackBufferImage = next;
            MapAsyncPainter.this.mapFocusPointBackBuffer = nextMapFocusPointBackBuffer;
            Object object = MapAsyncPainter.this.consumptionLock;
            synchronized (object) {
                this.ignoreOldBuffer = false;
                MapAsyncPainter.this.used = false;
                MapAsyncPainter.this.consumed = false;
                MapAsyncPainter.this.consumptionLock.notifyAll();
            }
        }
    }
}

