/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.exceptions.AndrolibException;
import brut.common.BrutException;
import brut.util.Jar;
import brut.util.OSDetection;
import java.io.File;

public abstract class AaptManager {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getAaptBinary(int n) {
        File file;
        StringBuilder stringBuilder;
        CharSequence charSequence;
        String string = n != 2 ? "aapt" : "aapt2";
        if (!OSDetection.is64Bit() && ((String)(charSequence = OSDetection.OS)).contains("mac")) {
            throw new AndrolibException(string + " binary is not available for 32-bit platform: " + (String)charSequence);
        }
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder("/prebuilt/");
        String string2 = OSDetection.OS;
        if (!(string2.contains("nix") || string2.contains("nux") || string2.contains("aix") || string2.contains("sunos"))) {
            if (string2.contains("mac")) {
                ((StringBuilder)charSequence).append("macosx");
            } else {
                if (!string2.contains("win")) throw new AndrolibException("Could not identify platform: ".concat(string2));
                ((StringBuilder)charSequence).append("windows");
            }
        } else {
            ((StringBuilder)charSequence).append("linux");
        }
        ((StringBuilder)charSequence).append("/");
        ((StringBuilder)charSequence).append(string);
        if (OSDetection.is64Bit()) {
            ((StringBuilder)charSequence).append("_64");
        }
        if (string2.contains("win")) {
            ((StringBuilder)charSequence).append(".exe");
        }
        try {
            file = Jar.getResourceAsFile(((StringBuilder)charSequence).toString());
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
        AaptManager.setAaptBinaryExecutable(file);
        return file;
    }

    public static void setAaptBinaryExecutable(File file) {
        if (file.isFile() && file.canRead()) {
            if (file.setExecutable(true)) {
                return;
            }
            throw new AndrolibException("Could not set aapt binary as executable: " + file.getPath());
        }
        throw new AndrolibException("Could not read aapt binary: " + file.getPath());
    }
}

