/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.encoder;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.encoder.encodingoptions.Asn1EncodingOptions;
import de.rub.nds.asn1.encoder.typeprocessors.Asn1TypeProcessor;
import de.rub.nds.asn1.encoder.typeprocessors.DefaultAsn1TypeProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class Asn1TypeRegister {
    private static Asn1TypeRegister instance = null;
    private Map<String, TypeRegistration> registrations = new HashMap<String, TypeRegistration>();
    private Class<? extends Asn1TypeProcessor> defaultTypeProcessorClass = DefaultAsn1TypeProcessor.class;

    private Asn1TypeRegister() {
    }

    public static Asn1TypeRegister getInstance() {
        if (instance == null) {
            instance = new Asn1TypeRegister();
        }
        return instance;
    }

    public Class<? extends Asn1TypeProcessor> getDefaultTypeProcessorClass() {
        return this.defaultTypeProcessorClass;
    }

    public void setDefaultTypeProcessorClass(Class<? extends Asn1TypeProcessor> defaultTypeEncoderClass) {
        this.defaultTypeProcessorClass = defaultTypeEncoderClass;
    }

    public Object clone() {
        return this;
    }

    public void register(String type, Class<? extends Asn1TypeProcessor> typeEncoder) {
        if (type != null & !type.isEmpty() && typeEncoder != null) {
            String lowerType = type.toLowerCase();
            this.registrations.put(lowerType, new TypeRegistration(lowerType, typeEncoder));
        }
    }

    public Asn1TypeProcessor createTypeProcessor(Asn1EncodingOptions asn1EncodingOptions, Asn1Encodable asn1Encodable) {
        String lowerType = asn1Encodable.getType().toLowerCase();
        Class<? extends Asn1TypeProcessor> typeEncoderClass = this.defaultTypeProcessorClass;
        if (this.registrations.containsKey(lowerType)) {
            typeEncoderClass = this.registrations.get((Object)lowerType).typeEncoderClass;
        }
        return this.invokeTypeProcessor(typeEncoderClass, asn1EncodingOptions, asn1Encodable);
    }

    private Asn1TypeProcessor invokeTypeProcessor(Class<? extends Asn1TypeProcessor> typeEncoderClass, Asn1EncodingOptions asn1EncodingOptions, Asn1Encodable asn1Encodable) {
        Asn1TypeProcessor asn1TypeProcessor = null;
        try {
            Constructor<? extends Asn1TypeProcessor> typeEncoderConstructor = typeEncoderClass.getDeclaredConstructor(Asn1EncodingOptions.class, Asn1Encodable.class);
            asn1TypeProcessor = typeEncoderConstructor.newInstance(asn1EncodingOptions, asn1Encodable);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        return asn1TypeProcessor;
    }

    private static class TypeRegistration {
        public final String type;
        public final Class<? extends Asn1TypeProcessor> typeEncoderClass;

        public TypeRegistration(String type, Class<? extends Asn1TypeProcessor> typeEncoderClass) {
            this.type = type;
            this.typeEncoderClass = typeEncoderClass;
        }
    }
}

