/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialization;

import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.gradle.internal.Try;
import org.gradle.internal.evaluation.EvaluationContext;
import org.gradle.internal.evaluation.EvaluationOwner;

public abstract class Cached<T> {
    public static <T> Cached<T> of(Callable<T> computation) {
        return new Deferred<T>(computation);
    }

    public abstract T get();

    private static class Deferred<T>
    extends Cached<T>
    implements Serializable,
    EvaluationOwner {
        private volatile Callable<T> computation;
        private volatile Try<T> result;

        public Deferred(Callable<T> computation) {
            this.computation = computation;
        }

        @Override
        public T get() {
            return this.result().get();
        }

        private Try<T> result() {
            Callable<T> toCompute = this.computation;
            if (this.result == null) {
                this.result = this.tryComputation(toCompute);
                this.computation = null;
            }
            return this.result;
        }

        @Nonnull
        private Try<T> tryComputation(Callable<T> toCompute) {
            return EvaluationContext.current().evaluate(this, () -> Try.ofFailable(toCompute));
        }

        private Object writeReplace() {
            return new Fixed<T>(this.result());
        }
    }

    private static class Fixed<T>
    extends Cached<T> {
        private final Try<T> result;

        public Fixed(Try<T> result) {
            this.result = result;
        }

        @Override
        public T get() {
            return this.result.get();
        }
    }
}

