/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import javax.imageio.ImageIO;

public class ForestMaker {
    private static final String DESTDIR = "data/rules/classic/resources/images/forest";
    private static final int BASE_WIDTH = 128;
    private static final int BASE_HEIGHT = 64;
    private static final int MARGIN = 20;
    private static final int TREES = 60;
    private static final int RIVER_HEIGHT = 8;
    private static final int RIVER_WIDTH = 16;
    private static final int HALF_WIDTH = 64;
    private static final int HALF_HEIGHT = 32;
    private static final int[] LIMIT = new int[]{64, 64, -64, -64};
    private static final double[] SLOPE = new double[]{-0.5, 0.5, -0.5, 0.5};
    private static final int[] POWERS_OF_TWO = new int[]{1, 2, 4, 8};
    private static final boolean drawBorders = true;
    private static final boolean drawTrees = true;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: ForestMaker <directory>...");
            System.out.println("Directory name should match a directory in");
            System.out.println("   data/rules/classic/resources/images/forest");
            System.exit(1);
        }
        String riverName = "data/rules/classic/resources/images/terrain/ocean/center0.png";
        BufferedImage river = ImageIO.read(new File(riverName));
        river = river.getSubimage(44, 22, 40, 20);
        Rectangle rectangle = new Rectangle(0, 0, river.getWidth(), river.getHeight());
        TexturePaint texture = new TexturePaint(river, rectangle);
        for (String arg : args) {
            File sourceDirectory = new File(arg);
            if (!sourceDirectory.exists()) {
                System.out.println("Source directory " + arg + " does not exist.");
                continue;
            }
            String baseName = sourceDirectory.getName();
            File destinationDirectory = new File(DESTDIR, baseName);
            if (!destinationDirectory.exists()) {
                System.out.println("Destination directory " + destinationDirectory.getPath() + " does not exist.");
                continue;
            }
            File[] imageFiles = sourceDirectory.listFiles();
            if (imageFiles == null) {
                System.out.println("No images found in source directory " + arg + ".");
                continue;
            }
            System.out.println(imageFiles.length + " images found in source directory " + arg + ".");
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(imageFiles.length);
            int maximumHeight = 0;
            for (File imageFile : imageFiles) {
                if (!imageFile.isFile() || !imageFile.canRead()) continue;
                try {
                    BufferedImage image = ImageIO.read(imageFile);
                    images.add(image);
                    maximumHeight = Math.min(image.getHeight(), maximumHeight);
                }
                catch (IOException e) {
                    System.err.println("Unable to load image " + imageFile.getName() + ":\n" + e);
                }
            }
            int numberOfImages = images.size();
            Random random = new Random(1492L);
            for (int index = 0; index < 16; ++index) {
                BufferedImage base = new BufferedImage(128, 84, 2);
                Graphics2D g = base.createGraphics();
                g.translate(64, 84);
                g.setPaint(texture);
                boolean[] branches = new boolean[4];
                String counter = "";
                if (index > 0) {
                    StringBuilder sb = new StringBuilder(POWERS_OF_TWO.length);
                    for (int i = 0; i < POWERS_OF_TWO.length; ++i) {
                        if ((index & POWERS_OF_TWO[i]) == POWERS_OF_TWO[i]) {
                            branches[i] = true;
                            sb.append('1');
                            continue;
                        }
                        sb.append('0');
                    }
                    counter = sb.toString();
                }
                Point right = new Point(64, -32);
                Point left = new Point(-64, -32);
                int treeCount = 0;
                if (branches[0] || branches[2]) {
                    left.translate(16, 8);
                    ++treeCount;
                }
                if (branches[1] || branches[3]) {
                    right.translate(-16, 8);
                    ++treeCount;
                }
                int dx = right.x + left.x;
                int dy = right.y + left.y;
                g.setColor(Color.RED);
                g.drawLine(0, 0, right.x, right.y);
                g.drawLine(right.x, right.y, dx, dy);
                g.drawLine(dx, dy, left.x, left.y);
                g.drawLine(left.x, left.y, 0, 0);
                ArrayList<ImageLocation> trees = new ArrayList<ImageLocation>(60);
                int numberOfTrees = (6 - treeCount) * 60 / 6;
                int count = 0;
                while (count < numberOfTrees) {
                    BufferedImage image = (BufferedImage)images.get(random.nextInt(numberOfImages));
                    int width = image.getWidth();
                    int height = image.getHeight();
                    int halfWidth = width / 2;
                    float a = random.nextFloat();
                    float b = random.nextFloat();
                    int x = (int)(a * (float)right.x + b * (float)left.x);
                    int y = (int)(a * (float)right.y + b * (float)left.y);
                    if (x - halfWidth < -64) {
                        x = -64 + halfWidth;
                    }
                    if (x + halfWidth > 64) {
                        x = 64 - halfWidth;
                    }
                    int crown = Math.max(y - height, -84);
                    if ((branches[1] || branches[3]) && crown < -56 + (x + halfWidth) / 2 || (branches[0] || branches[2]) && crown < -56 - (x - halfWidth) / 2) continue;
                    trees.add(new ImageLocation(image, x - halfWidth, crown));
                    ++count;
                }
                trees.sort(Comparator.naturalOrder());
                for (ImageLocation imageLocation : trees) {
                    g.drawImage((Image)imageLocation.image, imageLocation.x, imageLocation.y, null);
                }
                g.dispose();
                ImageIO.write((RenderedImage)base, "png", new File(destinationDirectory, sourceDirectory.getName() + counter + ".png"));
            }
        }
    }

    private static class ImageLocation
    implements Comparable<ImageLocation> {
        final BufferedImage image;
        final int x;
        final int y;

        public ImageLocation(BufferedImage image, int x, int y) {
            this.image = image;
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(ImageLocation other) {
            int dy = other.y - this.y;
            return dy == 0 ? other.x - this.x : dy;
        }

        public boolean equals(Object other) {
            if (other instanceof ImageLocation) {
                return this.compareTo((ImageLocation)other) == 0 && super.equals(other);
            }
            return false;
        }

        public int hashCode() {
            int hash = super.hashCode();
            hash = 37 * hash + this.x;
            hash = 37 * hash + this.y;
            return 37 * hash + this.image.hashCode();
        }
    }
}

