/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.opf.PublicationType;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

final class PackageDocumentData {
    private final EPUBVersion version;
    private final Set<PublicationType> types;
    private final String uniqueId;

    private PackageDocumentData(Builder builder) throws InvalidVersionException {
        if (builder.error != null) {
            throw new InvalidVersionException(builder.error);
        }
        if (builder.version == null) {
            throw new InvalidVersionException("Version not found");
        }
        this.version = builder.version;
        this.uniqueId = builder.uniqueId;
        this.types = Sets.immutableEnumSet((Iterable)builder.types);
    }

    public EPUBVersion getVersion() {
        return this.version;
    }

    public Set<PublicationType> getTypes() {
        return this.types;
    }

    public String getUniqueIdentifier() {
        return this.uniqueId;
    }

    static class Builder {
        private EPUBVersion version;
        private Set<PublicationType> types = EnumSet.noneOf(PublicationType.class);
        private String uniqueId;
        private String error;

        Builder() {
        }

        public PackageDocumentData build() throws InvalidVersionException {
            return new PackageDocumentData(this);
        }

        public Builder withError(String error) {
            this.error = error;
            return this;
        }

        public Builder withUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder withVersion(EPUBVersion version) {
            this.version = version;
            return this;
        }

        public Builder withType(String type) {
            try {
                if (type != null) {
                    this.types.add(PublicationType.valueOf(type.toUpperCase(Locale.ROOT)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }
}

