/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.dao;

import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnDefinition;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;

public class ServerPrepareResult
implements PrepareResult {
    private final ColumnDefinition[] columns;
    private final ColumnDefinition[] parameters;
    private final String sql;
    private int statementId;
    private ColumnType[] parameterTypeHeader;
    private Protocol unProxiedProtocol;
    private volatile int shareCounter = 1;
    private volatile boolean isBeingDeallocate;
    private volatile boolean inCache;

    public ServerPrepareResult(String sql, int statementId, ColumnDefinition[] columns, ColumnDefinition[] parameters, Protocol unProxiedProtocol) {
        this.sql = sql;
        this.statementId = statementId;
        this.columns = columns;
        this.parameters = parameters;
        this.unProxiedProtocol = unProxiedProtocol;
        this.parameterTypeHeader = new ColumnType[parameters.length];
    }

    public void resetParameterTypeHeader() {
        this.parameterTypeHeader = new ColumnType[this.parameters.length];
    }

    public void failover(int statementId, Protocol unProxiedProtocol) {
        this.statementId = statementId;
        this.unProxiedProtocol = unProxiedProtocol;
        this.parameterTypeHeader = new ColumnType[this.parameters.length];
        this.shareCounter = 1;
        this.isBeingDeallocate = false;
    }

    public void setAddToCache() {
        this.inCache = true;
    }

    public void setRemoveFromCache() {
        this.inCache = false;
    }

    public synchronized boolean incrementShareCounter() {
        if (this.isBeingDeallocate) {
            return false;
        }
        ++this.shareCounter;
        return true;
    }

    public synchronized void decrementShareCounter() {
        --this.shareCounter;
    }

    public synchronized boolean canBeDeallocate() {
        if (this.shareCounter > 0 || this.isBeingDeallocate) {
            return false;
        }
        if (!this.inCache) {
            this.isBeingDeallocate = true;
            return true;
        }
        return false;
    }

    @Override
    public int getParamCount() {
        return this.parameters.length;
    }

    public synchronized int getShareCounter() {
        return this.shareCounter;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ColumnDefinition[] getColumns() {
        return this.columns;
    }

    public ColumnDefinition[] getParameters() {
        return this.parameters;
    }

    public Protocol getUnProxiedProtocol() {
        return this.unProxiedProtocol;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public ColumnType[] getParameterTypeHeader() {
        return this.parameterTypeHeader;
    }
}

