/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage;

import java.util.List;
import java.util.stream.Stream;
import org.traccar.model.BaseModel;
import org.traccar.model.Permission;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Request;

public abstract class Storage {
    public abstract <T> List<T> getObjects(Class<T> var1, Request var2) throws StorageException;

    public abstract <T> Stream<T> getObjectsStream(Class<T> var1, Request var2) throws StorageException;

    public abstract <T> long addObject(T var1, Request var2) throws StorageException;

    public abstract <T> void updateObject(T var1, Request var2) throws StorageException;

    public abstract void removeObject(Class<?> var1, Request var2) throws StorageException;

    public abstract List<Permission> getPermissions(Class<? extends BaseModel> var1, long var2, Class<? extends BaseModel> var4, long var5) throws StorageException;

    public abstract void addPermission(Permission var1) throws StorageException;

    public abstract void removePermission(Permission var1) throws StorageException;

    public List<Permission> getPermissions(Class<? extends BaseModel> ownerClass, Class<? extends BaseModel> propertyClass) throws StorageException {
        return this.getPermissions(ownerClass, 0L, propertyClass, 0L);
    }

    public <T> T getObject(Class<T> clazz, Request request) throws StorageException {
        try (Stream<T> objects = this.getObjectsStream(clazz, request);){
            T t = objects.findFirst().orElse(null);
            return t;
        }
    }
}

