/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.actions;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.model.script.engine.action.ActionDoc;
import org.openhab.core.model.script.internal.engine.action.SemanticsActionService;
import org.openhab.core.semantics.Equipment;
import org.openhab.core.semantics.Location;
import org.openhab.core.semantics.Point;
import org.openhab.core.semantics.Property;
import org.openhab.core.semantics.SemanticTags;
import org.openhab.core.semantics.Tag;

@NonNullByDefault
public class Semantics {
    @ActionDoc(text="checks if the given Item is is a Location")
    public static boolean isLocation(Item item) {
        return SemanticsActionService.isLocation(item);
    }

    @ActionDoc(text="checks if the given Item is is an Equipment")
    public static boolean isEquipment(Item item) {
        return SemanticsActionService.isEquipment(item);
    }

    @ActionDoc(text="checks if the given Item is is a Point")
    public static boolean isPoint(Item item) {
        return SemanticsActionService.isPoint(item);
    }

    @ActionDoc(text="gets the Location Item of the Item")
    public static @Nullable Item getLocation(Item item) {
        return SemanticsActionService.getLocationItemFromGroupNames(item.getGroupNames());
    }

    @ActionDoc(text="gets the Location type of the Item")
    public static @Nullable Class<? extends Location> getLocationType(Item item) {
        Item locationItem = Semantics.isLocation(item) ? item : Semantics.getLocation(item);
        return locationItem != null ? SemanticTags.getLocation((Item)locationItem) : null;
    }

    @ActionDoc(text="gets the Equipment Item an Item belongs to")
    public static @Nullable Item getEquipment(Item item) {
        return SemanticsActionService.getEquipmentItemFromGroupNames(item.getGroupNames());
    }

    @ActionDoc(text="gets the Equipment type an Item belongs to")
    public static @Nullable Class<? extends Equipment> getEquipmentType(Item item) {
        Item equipmentItem = Semantics.isEquipment(item) ? item : Semantics.getEquipment(item);
        return equipmentItem != null ? SemanticTags.getEquipment((Item)equipmentItem) : null;
    }

    @ActionDoc(text="gets the Point type of an Item")
    public static @Nullable Class<? extends Point> getPointType(Item item) {
        return Semantics.isPoint(item) ? SemanticTags.getPoint((Item)item) : null;
    }

    @ActionDoc(text="gets the Property type an Item relates to")
    public static @Nullable Class<? extends Property> getPropertyType(Item item) {
        return Semantics.isPoint(item) ? SemanticTags.getProperty((Item)item) : null;
    }

    @ActionDoc(text="gets the semantic type of an Item")
    public static @Nullable Class<? extends Tag> getSemanticType(Item item) {
        return SemanticTags.getSemanticType((Item)item);
    }
}

