/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh.keygenerator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyPairLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyPairLoader.class);

    private KeyPairLoader() {
    }

    public static KeyPair getKeyPair(InputStream is) throws GeneralSecurityException, IOException {
        return KeyPairLoader.getKeyPair(is, null);
    }

    public static KeyPair getKeyPair(InputStream is, String password) throws GeneralSecurityException, IOException {
        try (PEMParser parser = new PEMParser((Reader)new InputStreamReader(is));){
            PrivateKey privateKey;
            PublicKey publicKey;
            Object jce;
            Object o = parser.readObject();
            JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
            if (o instanceof PEMEncryptedKeyPair) {
                if (password == null) {
                    throw new GeneralSecurityException("A password must be supplied to read an encrypted key pair");
                }
                JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(password.toCharArray());
                o = pemConverter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor));
            } else if (o instanceof PKCS8EncryptedPrivateKeyInfo) {
                if (password == null) {
                    throw new GeneralSecurityException("A password must be supplied to read an encrypted key pair");
                }
                jce = new JceOpenSSLPKCS8DecryptorProviderBuilder();
                try {
                    InputDecryptorProvider decProv = jce.build(password.toCharArray());
                    o = ((PKCS8EncryptedPrivateKeyInfo)o).decryptPrivateKeyInfo(decProv);
                }
                catch (OperatorCreationException | PKCSException ex) {
                    LOGGER.debug("Error decrypting key pair", ex);
                    throw new GeneralSecurityException("Error decrypting key pair", ex);
                }
            }
            if (o instanceof PEMKeyPair) {
                jce = pemConverter.getKeyPair((PEMKeyPair)o);
                return jce;
            }
            if (o instanceof KeyPair) {
                jce = (KeyPair)o;
                return jce;
            }
            if (o instanceof PrivateKeyInfo && (publicKey = KeyPairLoader.convertPrivateToPublicKey(privateKey = pemConverter.getPrivateKey((PrivateKeyInfo)o))) != null) {
                KeyPair keyPair = new KeyPair(publicKey, privateKey);
                return keyPair;
            }
        }
        throw new GeneralSecurityException("Failed to parse input stream");
    }

    private static PublicKey convertPrivateToPublicKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(((RSAPrivateCrtKey)privateKey).getModulus(), ((RSAPrivateCrtKey)privateKey).getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
            org.bouncycastle.jce.spec.ECParameterSpec paramSpec = EC5Util.convertSpec((ECParameterSpec)ecPrivateKey.getParams());
            ECPoint q = paramSpec.getG().multiply(ecPrivateKey.getS());
            ECPublicKeySpec keySpec = new ECPublicKeySpec(q, paramSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic((KeySpec)keySpec);
        }
        if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dsaPrivateKey = (DSAPrivateKey)privateKey;
            BigInteger q = dsaPrivateKey.getParams().getQ();
            BigInteger p = dsaPrivateKey.getParams().getP();
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(q.modPow(dsaPrivateKey.getX(), p), p, q, dsaPrivateKey.getParams().getG());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(keySpec);
        }
        LOGGER.warn("Unable to convert private key to public key. Only RSA, DSA + ECDSA supported");
        return null;
    }
}

