/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.ClangIndex;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ClangBuildSystem {
    protected ClangBuildSystem() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="unsigned long long")
    public static long clang_getBuildSessionTimestamp() {
        long __functionAddress = Functions.getBuildSessionTimestamp;
        return JNI.invokeJ((long)__functionAddress);
    }

    @NativeType(value="CXVirtualFileOverlay")
    public static long clang_VirtualFileOverlay_create(@NativeType(value="unsigned int") int options) {
        long __functionAddress = Functions.VirtualFileOverlay_create;
        return JNI.invokeP((int)options, (long)__functionAddress);
    }

    public static int nclang_VirtualFileOverlay_addFileMapping(long overlay, long virtualPath, long realPath) {
        long __functionAddress = Functions.VirtualFileOverlay_addFileMapping;
        if (Checks.CHECKS) {
            Checks.check((long)overlay);
        }
        return JNI.invokePPPI((long)overlay, (long)virtualPath, (long)realPath, (long)__functionAddress);
    }

    @NativeType(value="enum CXErrorCode")
    public static int clang_VirtualFileOverlay_addFileMapping(@NativeType(value="CXVirtualFileOverlay") long overlay, @NativeType(value="char const *") ByteBuffer virtualPath, @NativeType(value="char const *") ByteBuffer realPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)virtualPath);
            Checks.checkNT1((ByteBuffer)realPath);
        }
        return ClangBuildSystem.nclang_VirtualFileOverlay_addFileMapping(overlay, MemoryUtil.memAddress((ByteBuffer)virtualPath), MemoryUtil.memAddress((ByteBuffer)realPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="enum CXErrorCode")
    public static int clang_VirtualFileOverlay_addFileMapping(@NativeType(value="CXVirtualFileOverlay") long overlay, @NativeType(value="char const *") CharSequence virtualPath, @NativeType(value="char const *") CharSequence realPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(virtualPath, true);
            long virtualPathEncoded = stack.getPointerAddress();
            stack.nASCII(realPath, true);
            long realPathEncoded = stack.getPointerAddress();
            int n = ClangBuildSystem.nclang_VirtualFileOverlay_addFileMapping(overlay, virtualPathEncoded, realPathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="enum CXErrorCode")
    public static int clang_VirtualFileOverlay_setCaseSensitivity(@NativeType(value="CXVirtualFileOverlay") long overlay, int caseSensitive) {
        long __functionAddress = Functions.VirtualFileOverlay_setCaseSensitivity;
        if (Checks.CHECKS) {
            Checks.check((long)overlay);
        }
        return JNI.invokePI((long)overlay, (int)caseSensitive, (long)__functionAddress);
    }

    public static int nclang_VirtualFileOverlay_writeToBuffer(long overlay, int options, long out_buffer_ptr, long out_buffer_size) {
        long __functionAddress = Functions.VirtualFileOverlay_writeToBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)overlay);
        }
        return JNI.invokePPPI((long)overlay, (int)options, (long)out_buffer_ptr, (long)out_buffer_size, (long)__functionAddress);
    }

    @NativeType(value="enum CXErrorCode")
    public static int clang_VirtualFileOverlay_writeToBuffer(@NativeType(value="CXVirtualFileOverlay") long overlay, @NativeType(value="unsigned int") int options, @NativeType(value="char **") PointerBuffer out_buffer_ptr, @NativeType(value="unsigned int *") IntBuffer out_buffer_size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)out_buffer_ptr, (int)1);
            Checks.check((Buffer)out_buffer_size, (int)1);
        }
        return ClangBuildSystem.nclang_VirtualFileOverlay_writeToBuffer(overlay, options, MemoryUtil.memAddress((CustomBuffer)out_buffer_ptr), MemoryUtil.memAddress((IntBuffer)out_buffer_size));
    }

    public static void nclang_free(long buffer) {
        long __functionAddress = Functions.free;
        JNI.invokePV((long)buffer, (long)__functionAddress);
    }

    public static void clang_free(@NativeType(value="void *") ByteBuffer buffer) {
        ClangBuildSystem.nclang_free(MemoryUtil.memAddress((ByteBuffer)buffer));
    }

    public static void clang_VirtualFileOverlay_dispose(@NativeType(value="CXVirtualFileOverlay") long overlay) {
        long __functionAddress = Functions.VirtualFileOverlay_dispose;
        if (Checks.CHECKS) {
            Checks.check((long)overlay);
        }
        JNI.invokePV((long)overlay, (long)__functionAddress);
    }

    @NativeType(value="CXModuleMapDescriptor")
    public static long clang_ModuleMapDescriptor_create(@NativeType(value="unsigned int") int options) {
        long __functionAddress = Functions.ModuleMapDescriptor_create;
        return JNI.invokeP((int)options, (long)__functionAddress);
    }

    public static int nclang_ModuleMapDescriptor_setFrameworkModuleName(long descriptor, long name) {
        long __functionAddress = Functions.ModuleMapDescriptor_setFrameworkModuleName;
        if (Checks.CHECKS) {
            Checks.check((long)descriptor);
        }
        return JNI.invokePPI((long)descriptor, (long)name, (long)__functionAddress);
    }

    @NativeType(value="enum CXErrorCode")
    public static int clang_ModuleMapDescriptor_setFrameworkModuleName(@NativeType(value="CXModuleMapDescriptor") long descriptor, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return ClangBuildSystem.nclang_ModuleMapDescriptor_setFrameworkModuleName(descriptor, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="enum CXErrorCode")
    public static int clang_ModuleMapDescriptor_setFrameworkModuleName(@NativeType(value="CXModuleMapDescriptor") long descriptor, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = ClangBuildSystem.nclang_ModuleMapDescriptor_setFrameworkModuleName(descriptor, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclang_ModuleMapDescriptor_setUmbrellaHeader(long descriptor, long name) {
        long __functionAddress = Functions.ModuleMapDescriptor_setUmbrellaHeader;
        if (Checks.CHECKS) {
            Checks.check((long)descriptor);
        }
        return JNI.invokePPI((long)descriptor, (long)name, (long)__functionAddress);
    }

    @NativeType(value="enum CXErrorCode")
    public static int clang_ModuleMapDescriptor_setUmbrellaHeader(@NativeType(value="CXModuleMapDescriptor") long descriptor, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return ClangBuildSystem.nclang_ModuleMapDescriptor_setUmbrellaHeader(descriptor, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="enum CXErrorCode")
    public static int clang_ModuleMapDescriptor_setUmbrellaHeader(@NativeType(value="CXModuleMapDescriptor") long descriptor, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = ClangBuildSystem.nclang_ModuleMapDescriptor_setUmbrellaHeader(descriptor, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclang_ModuleMapDescriptor_writeToBuffer(long descriptor, int options, long out_buffer_ptr, long out_buffer_size) {
        long __functionAddress = Functions.ModuleMapDescriptor_writeToBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)descriptor);
        }
        return JNI.invokePPPI((long)descriptor, (int)options, (long)out_buffer_ptr, (long)out_buffer_size, (long)__functionAddress);
    }

    @NativeType(value="enum CXErrorCode")
    public static int clang_ModuleMapDescriptor_writeToBuffer(@NativeType(value="CXModuleMapDescriptor") long descriptor, @NativeType(value="unsigned int") int options, @NativeType(value="char **") PointerBuffer out_buffer_ptr, @NativeType(value="unsigned int *") IntBuffer out_buffer_size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)out_buffer_ptr, (int)1);
            Checks.check((Buffer)out_buffer_size, (int)1);
        }
        return ClangBuildSystem.nclang_ModuleMapDescriptor_writeToBuffer(descriptor, options, MemoryUtil.memAddress((CustomBuffer)out_buffer_ptr), MemoryUtil.memAddress((IntBuffer)out_buffer_size));
    }

    public static void clang_ModuleMapDescriptor_dispose(@NativeType(value="CXModuleMapDescriptor") long descriptor) {
        long __functionAddress = Functions.ModuleMapDescriptor_dispose;
        if (Checks.CHECKS) {
            Checks.check((long)descriptor);
        }
        JNI.invokePV((long)descriptor, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long getBuildSessionTimestamp = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_getBuildSessionTimestamp");
        public static final long VirtualFileOverlay_create = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_VirtualFileOverlay_create");
        public static final long VirtualFileOverlay_addFileMapping = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_VirtualFileOverlay_addFileMapping");
        public static final long VirtualFileOverlay_setCaseSensitivity = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_VirtualFileOverlay_setCaseSensitivity");
        public static final long VirtualFileOverlay_writeToBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_VirtualFileOverlay_writeToBuffer");
        public static final long free = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_free");
        public static final long VirtualFileOverlay_dispose = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_VirtualFileOverlay_dispose");
        public static final long ModuleMapDescriptor_create = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_ModuleMapDescriptor_create");
        public static final long ModuleMapDescriptor_setFrameworkModuleName = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_ModuleMapDescriptor_setFrameworkModuleName");
        public static final long ModuleMapDescriptor_setUmbrellaHeader = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_ModuleMapDescriptor_setUmbrellaHeader");
        public static final long ModuleMapDescriptor_writeToBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_ModuleMapDescriptor_writeToBuffer");
        public static final long ModuleMapDescriptor_dispose = APIUtil.apiGetFunctionAddress((FunctionProvider)ClangIndex.getLibrary(), (String)"clang_ModuleMapDescriptor_dispose");

        private Functions() {
        }
    }
}

