/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkPluginCopy;
import org.lwjgl.nuklear.NkPluginCopyI;
import org.lwjgl.nuklear.NkPluginPaste;
import org.lwjgl.nuklear.NkPluginPasteI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_clipboard")
public class NkClipboard
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int PASTE;
    public static final int COPY;

    public NkClipboard(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkClipboard.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkClipboard.nuserdata(this.address());
    }

    @Nullable
    @NativeType(value="nk_plugin_paste")
    public NkPluginPaste paste() {
        return NkClipboard.npaste(this.address());
    }

    @Nullable
    @NativeType(value="nk_plugin_copy")
    public NkPluginCopy copy() {
        return NkClipboard.ncopy(this.address());
    }

    public NkClipboard userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkClipboard.nuserdata(this.address(), value);
        return this;
    }

    public NkClipboard userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkClipboard paste(@Nullable @NativeType(value="nk_plugin_paste") NkPluginPasteI value) {
        NkClipboard.npaste(this.address(), value);
        return this;
    }

    public NkClipboard copy(@Nullable @NativeType(value="nk_plugin_copy") NkPluginCopyI value) {
        NkClipboard.ncopy(this.address(), value);
        return this;
    }

    public NkClipboard set(NkHandle userdata, NkPluginPasteI paste, NkPluginCopyI copy) {
        this.userdata(userdata);
        this.paste(paste);
        this.copy(copy);
        return this;
    }

    public NkClipboard set(NkClipboard src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkClipboard malloc() {
        return (NkClipboard)NkClipboard.wrap(NkClipboard.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkClipboard calloc() {
        return (NkClipboard)NkClipboard.wrap(NkClipboard.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkClipboard create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkClipboard)NkClipboard.wrap(NkClipboard.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkClipboard create(long address) {
        return (NkClipboard)NkClipboard.wrap(NkClipboard.class, (long)address);
    }

    @Nullable
    public static NkClipboard createSafe(long address) {
        return address == 0L ? null : (NkClipboard)NkClipboard.wrap(NkClipboard.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkClipboard.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkClipboard.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkClipboard.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkClipboard.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkClipboard.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkClipboard.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkClipboard.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkClipboard mallocStack() {
        return NkClipboard.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkClipboard callocStack() {
        return NkClipboard.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkClipboard mallocStack(MemoryStack stack) {
        return NkClipboard.malloc(stack);
    }

    @Deprecated
    public static NkClipboard callocStack(MemoryStack stack) {
        return NkClipboard.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkClipboard.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkClipboard.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkClipboard.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkClipboard.calloc(capacity, stack);
    }

    public static NkClipboard malloc(MemoryStack stack) {
        return (NkClipboard)NkClipboard.wrap(NkClipboard.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkClipboard calloc(MemoryStack stack) {
        return (NkClipboard)NkClipboard.wrap(NkClipboard.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkClipboard.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkClipboard.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    @Nullable
    public static NkPluginPaste npaste(long struct) {
        return NkPluginPaste.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PASTE)));
    }

    @Nullable
    public static NkPluginCopy ncopy(long struct) {
        return NkPluginCopy.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)COPY)));
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void npaste(long struct, @Nullable NkPluginPasteI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PASTE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ncopy(long struct, @Nullable NkPluginCopyI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COPY), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkClipboard.__struct((Struct.Member[])new Struct.Member[]{NkClipboard.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkClipboard.__member((int)POINTER_SIZE), NkClipboard.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        PASTE = layout.offsetof(1);
        COPY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkClipboard, Buffer>
    implements NativeResource {
        private static final NkClipboard ELEMENT_FACTORY = NkClipboard.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkClipboard getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkClipboard.nuserdata(this.address());
        }

        @Nullable
        @NativeType(value="nk_plugin_paste")
        public NkPluginPaste paste() {
            return NkClipboard.npaste(this.address());
        }

        @Nullable
        @NativeType(value="nk_plugin_copy")
        public NkPluginCopy copy() {
            return NkClipboard.ncopy(this.address());
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkClipboard.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer paste(@Nullable @NativeType(value="nk_plugin_paste") NkPluginPasteI value) {
            NkClipboard.npaste(this.address(), value);
            return this;
        }

        public Buffer copy(@Nullable @NativeType(value="nk_plugin_copy") NkPluginCopyI value) {
            NkClipboard.ncopy(this.address(), value);
            return this;
        }
    }
}

