/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.ECDSAAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.loader.PublicKeyStorageManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;

public class ClientECDSASignatureVerifierContext
extends AsymmetricSignatureVerifierContext {
    public ClientECDSASignatureVerifierContext(KeycloakSession session, ClientModel client, JWSInput input) throws VerificationException {
        super(ClientECDSASignatureVerifierContext.getKey(session, client, input));
    }

    private static KeyWrapper getKey(KeycloakSession session, ClientModel client, JWSInput input) throws VerificationException {
        KeyWrapper key = PublicKeyStorageManager.getClientPublicKeyWrapper(session, client, input);
        if (key == null) {
            throw new VerificationException("Key not found");
        }
        if (!"EC".equals(key.getType())) {
            throw new VerificationException("Key Type is not EC: " + key.getType());
        }
        if (key.getAlgorithm() == null) {
            key.setAlgorithm(input.getHeader().getRawAlgorithm());
        } else if (!key.getAlgorithm().equals(input.getHeader().getRawAlgorithm())) {
            throw new VerificationException("Key Algorithms are different, key-algorithm=" + key.getAlgorithm() + " jwt-algorithm=" + input.getHeader().getRawAlgorithm());
        }
        return key;
    }

    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        try {
            int expectedSize = ECDSAAlgorithm.getSignatureLength((String)this.getAlgorithm());
            byte[] derSignature = ECDSAAlgorithm.concatenatedRSToASN1DER((byte[])signature, (int)expectedSize);
            return super.verify(data, derSignature);
        }
        catch (Exception e) {
            throw new VerificationException("Signing failed", (Throwable)e);
        }
    }
}

