/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.function.BiFunction;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class ScalarDomainResultBuilder<T>
implements ResultBuilder {
    private final JavaType<T> typeDescriptor;

    public ScalarDomainResultBuilder(JavaType<T> typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
    }

    @Override
    public Class<?> getJavaType() {
        return this.typeDescriptor.getJavaTypeClass();
    }

    public DomainResult<T> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(Integer.toString(resultPosition + 1)), processingState -> {
            BasicType<T> basicType = jdbcResultsMetadata.resolveType(resultPosition + 1, this.typeDescriptor, processingState.getSqlAstCreationState().getCreationContext().getSessionFactory());
            return new ResultSetMappingSqlSelection(resultPosition, basicType);
        }), this.typeDescriptor, null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, (BasicType)sqlSelection.getExpressionType(), null, false, false);
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarDomainResultBuilder that = (ScalarDomainResultBuilder)o;
        return this.typeDescriptor.equals(that.typeDescriptor);
    }

    public int hashCode() {
        return this.typeDescriptor.hashCode();
    }
}

