/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.av1.Av1DDFrame;
import org.jitsi.videobridge.cc.av1.FrameHistory;
import org.jitsi.videobridge.cc.av1.PacketInsertionResult;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\nJ$\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\n2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\nJ$\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\n2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u001cJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDFrameMap;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "frameHistory", "Lorg/jitsi/videobridge/cc/av1/FrameHistory;", "logger", "findFrame", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "packet", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "size", "", "isLargeJump", "", "insertPacket", "Lorg/jitsi/videobridge/cc/av1/PacketInsertionResult;", "insertFrame", "", "frame", "insertFrame$jitsi_videobridge", "getIndex", "frameIndex", "nextFrame", "nextFrameWith", "pred", "Lkotlin/Function1;", "prevFrame", "prevFrameWith", "findPrevAcceptedFrame", "findNextAcceptedFrame", "Companion", "jitsi-videobridge"})
public final class Av1DDFrameMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FrameHistory frameHistory;
    @NotNull
    private final Logger logger;
    public static final int FRAME_MAP_SIZE = 500;

    public Av1DDFrameMap(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.frameHistory = new FrameHistory(500);
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @Nullable
    public final synchronized Av1DDFrame findFrame(@NotNull Av1DDPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return this.frameHistory.get(packet.getFrameNumber());
    }

    public final int size() {
        return this.frameHistory.getNumCached();
    }

    private final boolean isLargeJump(Av1DDPacket packet) {
        Av1DDFrame av1DDFrame = this.frameHistory.getLatestFrame();
        if (av1DDFrame == null) {
            return false;
        }
        Av1DDFrame latestFrame = av1DDFrame;
        int picDelta = RtpUtils.Companion.getSequenceNumberDelta(packet.getFrameNumber(), latestFrame.getFrameNumber());
        if (picDelta > 500) {
            return true;
        }
        long tsDelta = RtpUtils.Companion.getTimestampDiff(packet.getTimestamp(), latestFrame.getTimestamp());
        if (picDelta < 0) {
            if (tsDelta > 0L) {
                return true;
            }
            if (RtpUtilsKt.isNewerThan(packet.getSequenceNumber(), latestFrame.getLatestKnownSequenceNumber())) {
                return true;
            }
        }
        return tsDelta > 90000000L;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized PacketInsertionResult insertPacket(@NotNull Av1DDPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        int frameNumber = packet.getFrameNumber();
        if (this.isLargeJump(packet)) {
            this.frameHistory.getIndexTracker().resetAt(frameNumber);
            Av1DDFrame av1DDFrame = this.frameHistory.insert(packet);
            if (av1DDFrame == null) {
                return null;
            }
            Av1DDFrame frame = av1DDFrame;
            return new PacketInsertionResult(frame, true, true);
        }
        Av1DDFrame frame = this.frameHistory.get(frameNumber);
        if (frame != null) {
            if (!frame.matchesFrame(packet)) {
                void $this$insertPacket_u24lambda_u242;
                if (!(frame.getFrameNumber() == frameNumber)) {
                    boolean $i$a$-check-Av1DDFrameMap$insertPacket$22 = false;
                    String cfr_ignored_0 = "frame map returned frame with frame number " + frame.getFrameNumber() + " ";
                    String $i$a$-check-Av1DDFrameMap$insertPacket$22 = "when asked for frame with frame ID " + frameNumber;
                    throw new IllegalStateException($i$a$-check-Av1DDFrameMap$insertPacket$22.toString());
                }
                Av1DDFrame av1DDFrame = frame;
                Logger logger = this.logger;
                boolean bl = false;
                Av1DDPacket $this$insertPacket_u24lambda_u241 = packet;
                String string = "frame with ssrc " + ((Av1DDFrame)((Object)$this$insertPacket_u24lambda_u241)).getSsrc() + ", timestamp " + ((Av1DDFrame)((Object)$this$insertPacket_u24lambda_u241)).getTimestamp() + ", and sequence number range " + ((Av1DDFrame)((Object)$this$insertPacket_u24lambda_u241)).getEarliestKnownSequenceNumber() + "-" + ((Av1DDFrame)((Object)$this$insertPacket_u24lambda_u241)).getLatestKnownSequenceNumber() + ", ";
                boolean bl2 = false;
                String string2 = "and packet " + $this$insertPacket_u24lambda_u242.getSequenceNumber() + " with ssrc " + $this$insertPacket_u24lambda_u242.getSsrc() + ", timestamp " + $this$insertPacket_u24lambda_u242.getTimestamp() + ", and sequence number " + $this$insertPacket_u24lambda_u242.getSequenceNumber();
                logger.warn("Cannot insert packet in frame map: " + string + string2 + " both have frame ID " + frameNumber);
                return null;
            }
            try {
                frame.validateConsistency(packet);
            }
            catch (Exception e) {
                this.logger.warn(e);
            }
            frame.addPacket(packet);
            return new PacketInsertionResult(frame, false, false, 4, null);
        }
        Av1DDFrame av1DDFrame = this.frameHistory.insert(packet);
        if (av1DDFrame == null) {
            return null;
        }
        Av1DDFrame newframe = av1DDFrame;
        return new PacketInsertionResult(newframe, true, false, 4, null);
    }

    public final synchronized void insertFrame$jitsi_videobridge(@NotNull Av1DDFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        this.frameHistory.insert(frame);
    }

    @Nullable
    public final synchronized Av1DDFrame getIndex(int frameIndex) {
        return this.frameHistory.getIndex(frameIndex);
    }

    @Nullable
    public final synchronized Av1DDFrame nextFrame(@NotNull Av1DDFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return this.frameHistory.findAfter(frame, Av1DDFrameMap::nextFrame$lambda$3);
    }

    @Nullable
    public final synchronized Av1DDFrame nextFrameWith(@NotNull Av1DDFrame frame, @NotNull Function1<? super Av1DDFrame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        return this.frameHistory.findAfter(frame, pred);
    }

    @Nullable
    public final synchronized Av1DDFrame prevFrame(@NotNull Av1DDFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return this.frameHistory.findBefore(frame, Av1DDFrameMap::prevFrame$lambda$4);
    }

    @Nullable
    public final synchronized Av1DDFrame prevFrameWith(@NotNull Av1DDFrame frame, @NotNull Function1<? super Av1DDFrame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        return this.frameHistory.findBefore(frame, pred);
    }

    @Nullable
    public final Av1DDFrame findPrevAcceptedFrame(@NotNull Av1DDFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return this.prevFrameWith(frame, Av1DDFrameMap::findPrevAcceptedFrame$lambda$5);
    }

    @Nullable
    public final Av1DDFrame findNextAcceptedFrame(@NotNull Av1DDFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return this.nextFrameWith(frame, Av1DDFrameMap::findNextAcceptedFrame$lambda$6);
    }

    private static final boolean nextFrame$lambda$3(Av1DDFrame it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean prevFrame$lambda$4(Av1DDFrame it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean findPrevAcceptedFrame$lambda$5(Av1DDFrame it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAccepted();
    }

    private static final boolean findNextAcceptedFrame$lambda$6(Av1DDFrame it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAccepted();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDFrameMap$Companion;", "", "<init>", "()V", "FRAME_MAP_SIZE", "", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

