/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DetachClassicLinkVpc
extends BaseCmd {
    private static final String VPC_DESC = "The ID of the VPC to which the instance is linked.";
    private static final String INSTANCE_DESC = "The ID of the instance to unlink from the VPC.";
    private String vpcId;
    private String instanceId;

    public DetachClassicLinkVpc(String[] args) {
        super("ec2detachcl", "ec2-detach-classic-link-vpc");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "-c VPC -i INSTANCE_ID";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)this.joinDescription(VPC_DESC));
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"INSTANCE");
        OptionBuilder.withDescription((String)this.joinDescription(INSTANCE_DESC));
        options.addOption(OptionBuilder.create((String)"i"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Unlinks (detaches) an EC2-Classic instance from a VPC. After the instance has been unlinked, the VPc's security groups are no longer associated with it.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc");
        this.printOption("instance");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpcId = this.getOptionValue("vpc");
        this.instanceId = this.getOptionValue("instance");
        RequestResultPair rsp = jec2.detachClassicLinkVpc(this.vpcId, this.instanceId);
        out.output(System.out, (Boolean)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.warnIfTooManyNonOptions();
        this.assertOptionSet("vpc");
        this.assertOptionSet("instance");
    }

    public static void main(String[] args) {
        new DetachClassicLinkVpc(args).invoke();
    }
}

