/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.sets;

import com.paterva.maltego.discovery.DiscoveryContext;
import com.paterva.maltego.discovery.DiscoveryProvider;
import com.paterva.maltego.json.discovery.JsonDiscoveryContext;
import com.paterva.maltego.json.discovery.JsonDiscoveryProvider;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetDiscoveryProvider;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetsDiscoveryItems;
import com.paterva.maltego.transform.protocol.v3.api.proxy.V3HttpProxy;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TransformSetJsonDiscoveryProvider
extends JsonDiscoveryProvider<TransformSetsDiscoveryItems>
implements DiscoveryProvider<TransformSetsDiscoveryItems> {
    TransformSetDiscoveryProvider delegate = new TransformSetDiscoveryProvider();
    private static final String PATERVA_PREFIX = "paterva.v2.";

    public TransformSetsDiscoveryItems fetch(JsonDiscoveryContext dc) {
        V3HttpProxy proxy = new V3HttpProxy(dc.getV3Url());
        List transformSets = proxy.listTransformSets(true);
        List<TransformSet> sets = transformSets.stream().map(s -> {
            TransformSet set = new TransformSet(s.getName());
            List transformsInSet = Arrays.stream(s.getTransforms()).map(t -> t.startsWith(PATERVA_PREFIX) ? t : PATERVA_PREFIX + t).collect(Collectors.toList());
            set.addAllTransforms(transformsInSet);
            set.setCustom(false);
            if (s.getDescription() != null) {
                set.setDescription(s.getDescription());
            } else {
                set.setDescription("");
            }
            return set;
        }).collect(Collectors.toList());
        this.delegate.printSets((DiscoveryContext)dc, "sets before", TransformSetRepository.getDefault().allSets());
        this.delegate.printSets((DiscoveryContext)dc, "sets read", sets);
        return new TransformSetsDiscoveryItems(this, sets, (DiscoveryContext)dc, false);
    }

    public void apply(TransformSetsDiscoveryItems sets) {
        this.delegate.apply(sets);
    }

    public TransformSetsDiscoveryItems getNewAndMerged(TransformSetsDiscoveryItems items) {
        return this.delegate.getNewAndMerged(items);
    }
}

