/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaSpinnerBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JSpinner spinner = (JSpinner)c;
        JFormattedTextField editor = UIUtil.findComponentOfType(spinner, JFormattedTextField.class);
        int x1 = x;
        int y1 = y;
        int width1 = width;
        int height1 = height;
        boolean focused = c.isEnabled() && c.isVisible() && editor != null && editor.hasFocus();
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g);
        if (c.isOpaque()) {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(x, y, width, height);
        }
        g.setColor(UIUtil.getTextFieldBackground());
        g.fillRoundRect(x1, y1, width1, height1, 0, 0);
        Color enabledButtonColor = UIManager.getLookAndFeelDefaults().getColor("Spinner.darcula.enabledButtonColor");
        Color disabledButtonColor = UIManager.getLookAndFeelDefaults().getColor("Spinner.darcula.disabledButtonColor");
        g.setColor(spinner.isEnabled() ? enabledButtonColor : disabledButtonColor);
        if (editor != null) {
            int off = editor.getBounds().x + editor.getWidth() + ((JSpinner)c).getInsets().left + 1;
            Area rect = new Area(new RoundRectangle2D.Double(x1, y1, width1, height1, 0.0, 0.0));
            Area blueRect = new Area(new Rectangle(off, y1, 22, height1));
            rect.intersect(blueRect);
            ((Graphics2D)g).fill(rect);
        }
        if (!c.isEnabled()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (focused) {
            g.setColor(UIManager.getLookAndFeelDefaults().getColor("Spinner.darculaMod.focusedBorderColor"));
            g.drawRoundRect(x1, y1, width1 - 1, height1 - 1, 0, 0);
        }
        config.restore();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(5, 7, 5, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

