/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.format;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.TableIODecorator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class EntityTableFormatter
extends TableIODecorator {
    private static EntityFactory entityFactory;
    private final MaltegoEntitySpec unknownEntitySpec = (MaltegoEntitySpec)EntityRegistry.getDefault().get("maltego.Unknown");

    public EntityTableFormatter(TableIO table) {
        super(table);
    }

    protected EntityFactory entityFactory() {
        if (entityFactory == null) {
            entityFactory = EntityFactory.getDefault();
        }
        return entityFactory;
    }

    protected MaltegoEntitySpec getEntitySpec(String entityType) {
        MaltegoEntitySpec entitySpec = (MaltegoEntitySpec)EntityRegistry.getDefault().get(entityType);
        if (entitySpec == null) {
            entitySpec = this.unknownEntitySpec;
        }
        return entitySpec;
    }

    public abstract void addEntity(MaltegoEntity var1);

    public void addEntities(Collection<MaltegoEntity> entities) {
        entities.forEach(entity -> this.addEntity((MaltegoEntity)entity));
    }

    public abstract Iterator<MaltegoEntity> entityIterator();

    protected abstract class Reader
    implements Iterator<MaltegoEntity> {
        protected Iterator<List<String>> rowIterator;
        protected List<String> propertyNames;

        protected Reader() {
            this.rowIterator = EntityTableFormatter.this.rowIterator();
            this.propertyNames = this.readHeader();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        @Override
        public abstract MaltegoEntity next();

        protected abstract List<String> readHeader();
    }
}

