/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.openide.util.Lookup;
import yguard.A.A.D;
import yguard.A.J.SA;

public abstract class EntityRegistry
extends SpecRegistry<MaltegoEntitySpec> {
    public static final String MALTEGO_ENTITIES_EXT = "entity";
    private static EntityRegistry _default;

    public static synchronized EntityRegistry getDefault() {
        if (_default == null && (_default = (EntityRegistry)((Object)Lookup.getDefault().lookup(EntityRegistry.class))) == null) {
            _default = new DefaultEntityRegistry();
        }
        return _default;
    }

    public static synchronized EntityRegistry forGraph(D graph) {
        return EntityRegistry.forGraphID(GraphIDProvider.forGraph((SA)((SA)graph)));
    }

    public static synchronized EntityRegistry forGraphID(GraphID graphID) {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = EntityRegistry.class.getName();
        return (EntityRegistry)((Object)gud.get((Object)key));
    }

    public static synchronized void associate(GraphID graphID, EntityRegistry registry) {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = EntityRegistry.class.getName();
        gud.put((Object)key, (Object)registry);
    }

    public static class Memory
    extends EntityRegistry {
        private static final String DEFAULT_FOLDER = "Miscellaneous";
        private final HashMap<String, MaltegoEntitySpec> _items = new HashMap();
        private final HashMap<String, String> _folders = new HashMap();

        public Memory() {
        }

        public Memory(MaltegoEntitySpec[] specs) {
            for (MaltegoEntitySpec t : specs) {
                this.put(t);
            }
        }

        public void reloadEntities() {
        }

        public MaltegoEntitySpec get(String typeName) {
            return this._items.get(typeName);
        }

        public Collection<MaltegoEntitySpec> getAll() {
            return this._items.values();
        }

        public void put(MaltegoEntitySpec spec) {
            this.put(spec, spec.getDefaultCategory());
        }

        public void put(MaltegoEntitySpec spec, String category) {
            if (category == null) {
                category = DEFAULT_FOLDER;
            }
            this._items.put(spec.getTypeName(), spec);
            this._folders.put(spec.getTypeName(), category);
            this.fireTypeAdded((TypeSpec)spec);
        }

        public void remove(String typeName) {
            MaltegoEntitySpec spec = this.get(typeName);
            if (spec != null) {
                this._items.remove(typeName);
                this.fireTypeRemoved((TypeSpec)spec);
            }
        }

        public boolean contains(String typeName) {
            return this._items.containsKey(typeName);
        }

        public String[] allCategories() {
            return this._folders.values().toArray(new String[this._folders.size()]);
        }
    }

    public static class Proxy
    extends EntityRegistry {
        private EntityRegistry[] _registries;
        private EntityRegistry _writeDelegate;

        public Proxy(EntityRegistry ... registries) {
            this._registries = registries;
        }

        public void reloadEntities() {
            for (EntityRegistry reg : this._registries) {
                reg.reloadEntities();
            }
        }

        public MaltegoEntitySpec get(String typeName) {
            for (EntityRegistry reg : this._registries) {
                MaltegoEntitySpec t = (MaltegoEntitySpec)reg.get(typeName);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        public Collection<MaltegoEntitySpec> getAll() {
            HashSet<MaltegoEntitySpec> set = new HashSet<MaltegoEntitySpec>();
            for (EntityRegistry reg : this._registries) {
                set.addAll(reg.getAll());
            }
            return set;
        }

        public void put(MaltegoEntitySpec spec) {
            if (this._writeDelegate == null) {
                throw new UnsupportedOperationException("Object is read-only");
            }
            this._writeDelegate.put((TypeSpec)spec);
        }

        public void put(MaltegoEntitySpec spec, String category) {
            if (this._writeDelegate == null) {
                throw new UnsupportedOperationException("Object is read-only");
            }
            this._writeDelegate.put((TypeSpec)spec, category);
        }

        public void remove(String typeName) {
            if (this._writeDelegate == null) {
                throw new UnsupportedOperationException("Object is read-only");
            }
            this._writeDelegate.remove(typeName);
        }

        public boolean contains(String typeName) {
            for (EntityRegistry reg : this._registries) {
                if (!reg.contains(typeName)) continue;
                return true;
            }
            return false;
        }

        public String[] allCategories() {
            TreeSet<String> set = new TreeSet<String>();
            for (EntityRegistry reg : this._registries) {
                for (String s : reg.allCategories()) {
                    set.add(s);
                }
            }
            return set.toArray(new String[set.size()]);
        }

        public EntityRegistry getWriteDelegate() {
            return this._writeDelegate;
        }

        public void setWriteDelegate(EntityRegistry writeDelegate) {
            this._writeDelegate = writeDelegate;
        }
    }

    private static class DefaultEntityRegistry
    extends EntityRegistry {
        private DefaultEntityRegistry() {
        }

        public void reloadEntities() {
        }

        public MaltegoEntitySpec get(String typeName) {
            return null;
        }

        public Collection<MaltegoEntitySpec> getAll() {
            return new ArrayList<MaltegoEntitySpec>();
        }

        public void put(MaltegoEntitySpec spec, String category) {
        }

        public void remove(String typeName) {
        }

        public boolean contains(String typeName) {
            return false;
        }

        public String[] allCategories() {
            return new String[0];
        }

        public void put(MaltegoEntitySpec spec) {
        }
    }
}

