/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.CompilationException;
import com.paterva.maltego.automation.MachineCompilation;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.impl.FileSystemMachineRepository;
import com.paterva.maltego.automation.view.MachineDetailsController;
import com.paterva.maltego.automation.view.MachineTemplateController;
import com.paterva.maltego.automation.view.editor.MachineEditorControl;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;

public class MachineActions {
    private MachineActions() {
    }

    public static void delete(MachineDescriptor machine) {
        try {
            MachineRepository.getDefault().remove(machine);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static MachineDescriptor newMachine() {
        boolean cancelled;
        ArrayList<ValidatingController> panels = new ArrayList<ValidatingController>();
        MachineTemplateController type = new MachineTemplateController();
        type.setName("Choose type");
        type.setDescription("Select the type of the new machine.");
        MachineDetailsController details = new MachineDetailsController();
        details.setName("Configure details");
        details.setDescription("Specify the fields for the new machine.");
        details.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/RobotAdd.png".replace(".png", "48.png")));
        panels.add(details);
        panels.add(type);
        WizardDescriptor.Panel[] panelArray = panels.toArray(new WizardDescriptor.Panel[panels.size()]);
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panelArray);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panelArray));
        wizardDescriptor.setTitle("New Machine");
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("repository", (Object)MachineRepository.getDefault());
        wizardDescriptor.putProperty("template", (Object)"macro-template");
        wizardDescriptor.setTitleFormat(new MessageFormat("New Machine - {0} ({1})"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            try {
                MachineRepository repository = (MachineRepository)((Object)wizardDescriptor.getProperty("repository"));
                MachineDescriptor machine = new MachineDescriptor((String)wizardDescriptor.getProperty("id"), (String)wizardDescriptor.getProperty("displayName"), (String)wizardDescriptor.getProperty("description"));
                machine.setAuthor((String)wizardDescriptor.getProperty("author"));
                machine.setEnabled(true);
                machine.setData(MachineActions.applyTemplate((String)wizardDescriptor.getProperty("template"), machine));
                repository.add(machine);
                MachineActions.editMachine(machine);
                return machine;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static boolean editMachine(String machineName) {
        return MachineActions.editMachine(MachineRepository.getDefault(), machineName);
    }

    public static boolean editMachine(MachineRepository repository, String machineName) {
        MachineDescriptor machine = null;
        try {
            machine = repository.get(machineName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (machine != null) {
            return MachineActions.editMachine(machine);
        }
        return machine != null ? MachineActions.editMachine(machine) : false;
    }

    private static boolean editMachine(MachineDescriptor machine) {
        Object defaultOption;
        Object[] buttons;
        MachineEditorControl control = new MachineEditorControl();
        control.setText((String)machine.getData());
        control.setReadOnly(machine.isReadOnly());
        Object[] result = new Object[1];
        JButton okButton = new JButton("Save");
        String title = String.format("Machine Editor - %s", machine.getDisplayName());
        if (machine.isReadOnly()) {
            title = title + " (Read-only)";
            buttons = new Object[]{DialogDescriptor.CANCEL_OPTION};
            defaultOption = DialogDescriptor.CANCEL_OPTION;
        } else {
            buttons = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
            defaultOption = okButton;
        }
        PanelWithMatteBorderAllSides outerPanel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
        outerPanel.add(control);
        DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, title, true, buttons, defaultOption, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new EmptyActionListener());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        if (!machine.isReadOnly()) {
            ActionListener listener = e -> {
                if (e.getSource() == okButton) {
                    try {
                        MachineCompilation compilation = control.compileMachine();
                        String error = MachineActions.getNextError(machine, compilation);
                        if (error == null) {
                            result[0] = compilation;
                            dialog.setVisible(false);
                        } else {
                            MachineActions.showError(error);
                        }
                    }
                    catch (CompilationException compilationException) {
                        // empty catch block
                    }
                }
            };
            dd.setButtonListener(listener);
        }
        dialog.setVisible(true);
        MachineCompilation compilation = (MachineCompilation)result[0];
        if (compilation != null) {
            try {
                machine.setData(control.getText());
                machine.setAuthor(compilation.getAuthor());
                machine.setDescription(compilation.getDescription());
                machine.setDisplayName(compilation.getDisplayName());
                String oldName = machine.getName();
                String newName = compilation.getName();
                MachineRepository repo = MachineRepository.getDefault();
                if (oldName.equals(newName)) {
                    repo.update(machine);
                } else {
                    repo.remove(machine);
                    machine.setName(newName);
                    repo.add(machine);
                }
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    private static void showError(String message) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, "Machine Error", -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    private static String getNextError(MachineDescriptor descriptor, MachineCompilation compilation) {
        if (compilation.getName() == null || compilation.getName().isEmpty()) {
            return "Machine must have a unique name";
        }
        if (TypeNameValidator.checkName((String)compilation.getName()) != null) {
            return String.format("'%s' is not a valid machine name", compilation.getName());
        }
        if (!compilation.getName().equals(descriptor.getName())) {
            try {
                if (MachineRepository.getDefault().exists(compilation.getName())) {
                    return String.format("The name '%s' is already in use by another machine.", compilation.getName());
                }
            }
            catch (IOException ex) {
                return "An error occurred when accessing the repository: " + ex.getMessage();
            }
        }
        return null;
    }

    private static String applyTemplate(String name, MachineDescriptor machine) throws IOException {
        FileSystemMachineRepository templates = new FileSystemMachineRepository("MachineTemplates");
        MachineDescriptor template = ((MachineRepository)templates).get(name);
        if (template == null) {
            return "";
        }
        String text = (String)template.getData();
        text = MachineActions.replace(text, "author", machine.getAuthor());
        text = MachineActions.replace(text, "name", machine.getName());
        text = MachineActions.replace(text, "displayName", machine.getDisplayName());
        return MachineActions.replace(text, "description", machine.getDescription());
    }

    private static String replace(String text, String name, String value) {
        if (value == null) {
            value = "";
        }
        return text.replace("$" + name, value);
    }

    private static class EmptyActionListener
    implements ActionListener {
        private EmptyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

