/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.types;

import com.pinkmatter.types.Coordinate;
import com.pinkmatter.types.Geography;
import com.pinkmatter.types.LineString;
import com.pinkmatter.types.MultiPolygon;
import com.pinkmatter.types.Polygon;
import com.pinkmatter.types.SpatialException;
import com.pinkmatter.types.SpatialFactory;
import com.pinkmatter.types.Tetragon;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Converter {
    public static JtsSpatialContext getSpatialContext() {
        return SpatialFactory.getDefault().getContext();
    }

    public static Geography read(String wkt) throws SpatialException {
        try {
            if (wkt.startsWith("TETRAGON")) {
                return Converter.readTetragon(wkt);
            }
            Geometry geometry = Converter.wktReader().read(wkt);
            return Converter.fromJts(geometry);
        }
        catch (ParseException ex) {
            throw new SpatialException(ex.getMessage());
        }
    }

    public static Tetragon readTetragon(String wkt) throws SpatialException {
        String coordString;
        if (!wkt.startsWith("TETRAGON")) {
            throw new SpatialException("Error while reading tetragon from WKT: " + wkt + ". This is not a tetragon.");
        }
        int start = wkt.lastIndexOf("(");
        int separator = wkt.indexOf(",", start + 1);
        Coordinate[] coords = new Coordinate[4];
        int i = 0;
        while (separator >= 1) {
            coordString = wkt.substring(start + 1, separator).trim();
            coords[i] = Converter.parseCoordinate(coordString);
            start = separator;
            separator = wkt.indexOf(",", start + 1);
            ++i;
        }
        separator = wkt.indexOf(")");
        coordString = wkt.substring(start + 1, separator).trim();
        coords[3] = Converter.parseCoordinate(coordString);
        return new Tetragon(coords[0], coords[1], coords[2], coords[3]);
    }

    private static Coordinate parseCoordinate(String coordText) {
        int separator = coordText.indexOf(" ");
        String lonString = coordText.substring(0, separator).trim();
        String latString = coordText.substring(separator + 1).trim();
        double lat = Double.parseDouble(latString);
        double lon = Double.parseDouble(lonString);
        return new Coordinate(lat, lon);
    }

    public static Polygon readPolygon(String wkt) throws SpatialException {
        try {
            return Converter.fromJts((com.vividsolutions.jts.geom.Polygon)Converter.wktReader().read(wkt));
        }
        catch (ParseException ex) {
            throw new SpatialException(ex.getMessage());
        }
    }

    public static MultiPolygon readMultiPolygon(String wkt) throws SpatialException {
        try {
            return Converter.fromJts((com.vividsolutions.jts.geom.MultiPolygon)Converter.wktReader().read(wkt));
        }
        catch (ParseException ex) {
            throw new SpatialException(ex.getMessage());
        }
    }

    public static Coordinate readCoordinate(String wkt) throws SpatialException {
        try {
            Point point = (Point)Converter.wktReader().read(wkt);
            return Converter.fromJts(point.getCoordinate());
        }
        catch (ParseException ex) {
            throw new SpatialException(ex.getMessage());
        }
    }

    public static Tetragon toTetragon(Polygon polygon) throws SpatialException {
        if (Converter.isTetragon(polygon)) {
            Coordinate[] outline = polygon.getOutline();
            return new Tetragon(outline[0], outline[1], outline[2], outline[3]);
        }
        throw new SpatialException(String.format("Polygon %s is not a Tetragon", polygon));
    }

    public static boolean isTetragon(Polygon polygon) {
        return polygon.getOutline().length == 5 && polygon.getHoles().length == 0;
    }

    public static String write(Coordinate coordinate) {
        return WKTWriter.toPoint((com.vividsolutions.jts.geom.Coordinate)Converter.toJts(coordinate));
    }

    public static String write(Geography geography) {
        if (geography instanceof Tetragon) {
            return Converter.write((Tetragon)geography);
        }
        return Converter.wktWriter().write(Converter.toJts(geography));
    }

    public static String write(Tetragon tetragon) {
        Coordinate[] outline = tetragon.getOutline();
        StringBuilder buffer = new StringBuilder("TETRAGON ((");
        DecimalFormat formatter = new DecimalFormat("#.###############");
        for (int i = 0; i < 4; ++i) {
            buffer.append(formatter.format(outline[i].getLongitude()));
            buffer.append(" ");
            buffer.append(formatter.format(outline[i].getLatitude()));
            if (i == 3) continue;
            buffer.append(", ");
        }
        buffer.append("))");
        return buffer.toString();
    }

    private static WKTWriter wktWriter() {
        return new WKTWriter();
    }

    private static WKTReader wktReader() {
        return new WKTReader();
    }

    public static Coordinate[] getCoordinates(com.vividsolutions.jts.geom.LineString line) {
        return Converter.fromJts(line.getCoordinates());
    }

    public static Geometry toJts(Geography geography) {
        return geography.getGeometry();
    }

    public static com.vividsolutions.jts.geom.Polygon toJts(Polygon polygon) {
        return polygon.getJtsPolygon();
    }

    public static com.vividsolutions.jts.geom.MultiPolygon toJts(MultiPolygon polygon) {
        return polygon.getJtsMultiPolygon();
    }

    public static com.vividsolutions.jts.geom.Coordinate[] toJts(Coordinate ... from) {
        return Converter.toJts(false, from);
    }

    public static com.vividsolutions.jts.geom.Coordinate[] toClosedJts(Coordinate ... from) {
        return Converter.toJts(true, from);
    }

    public static com.vividsolutions.jts.geom.Coordinate[] toJts(boolean close, Coordinate ... from) {
        boolean doClose;
        if (from == null) {
            return null;
        }
        if (from.length == 0) {
            return new com.vividsolutions.jts.geom.Coordinate[0];
        }
        int size = from.length;
        boolean bl = doClose = close && !from[0].equals(from[from.length - 1]);
        if (doClose) {
            ++size;
        }
        com.vividsolutions.jts.geom.Coordinate[] to = new com.vividsolutions.jts.geom.Coordinate[size];
        for (int i = 0; i < from.length; ++i) {
            to[i] = Converter.toJts(from[i]);
        }
        if (doClose) {
            to[size - 1] = Converter.toJts(from[0]);
        }
        return to;
    }

    public static Coordinate[] fromJts(com.vividsolutions.jts.geom.Coordinate ... from) {
        if (from == null) {
            return null;
        }
        Coordinate[] to = new Coordinate[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = Converter.fromJts(from[i]);
        }
        return to;
    }

    public static com.vividsolutions.jts.geom.Coordinate toJts(Coordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        return new com.vividsolutions.jts.geom.Coordinate(coordinate.getLongitude(), coordinate.getLatitude());
    }

    public static Coordinate fromJts(com.vividsolutions.jts.geom.Coordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        return new Coordinate(coordinate.y, coordinate.x);
    }

    public static Polygon fromJts(com.vividsolutions.jts.geom.Polygon polygon) {
        return new Polygon(polygon);
    }

    public static MultiPolygon fromJts(com.vividsolutions.jts.geom.MultiPolygon polygon) {
        return new MultiPolygon(polygon);
    }

    public static Geography fromJts(Geometry geometry) throws SpatialException {
        switch (geometry.getGeometryType()) {
            case "Point": {
                return Converter.fromJts(geometry.getCoordinate());
            }
            case "Polygon": {
                return new Polygon((com.vividsolutions.jts.geom.Polygon)geometry);
            }
            case "MultiPolygon": {
                return new MultiPolygon((com.vividsolutions.jts.geom.MultiPolygon)geometry);
            }
            case "LineString": {
                return new LineString((com.vividsolutions.jts.geom.LineString)geometry);
            }
        }
        throw new SpatialException("Unknown JTS type: " + geometry.getGeometryType());
    }

    public static com.spatial4j.core.shape.Point toShape(Coordinate from) {
        return SpatialContext.GEO.makePoint(from.getLongitude(), from.getLatitude());
    }

    public static Shape toShape(Geography from) {
        Geometry geom = Converter.toJts(from);
        Geometry norm = geom.norm();
        norm = (Geometry)norm.clone();
        return new JtsGeometry(norm, Converter.getSpatialContext(), true, false);
    }

    public static Shape toShape(Geography ... from) {
        if (from.length == 1) {
            return Converter.toShape(from[0]);
        }
        ArrayList<Shape> shapes = new ArrayList<Shape>(from.length);
        for (Geography value : from) {
            shapes.add(Converter.toShape(value));
        }
        return new ShapeCollection(shapes, (SpatialContext)Converter.getSpatialContext());
    }

    private static Geometry[] getChildren(GeometryCollection from) {
        Geometry[] children = new Geometry[from.getNumGeometries()];
        for (int i = 0; i < from.getNumGeometries(); ++i) {
            children[i] = from.getGeometryN(i);
        }
        return children;
    }

    private static Shape toShape(Geometry ... from) {
        if (from.length == 1) {
            return Converter.toShape(from[0]);
        }
        ArrayList<Shape> shapes = new ArrayList<Shape>(from.length);
        for (Geometry value : from) {
            shapes.add(Converter.toShape(value));
        }
        return new ShapeCollection(shapes, (SpatialContext)Converter.getSpatialContext());
    }

    private static Shape toShape(Geometry value) {
        return new JtsGeometry((Geometry)value.clone(), Converter.getSpatialContext(), true, false);
    }
}

