/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.manager;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.ui.manager.CertificateDeleteAction;
import com.paterva.maltego.util.ui.outline.NodePropertySupport;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class CertificateNode
extends AbstractNode
implements CheckableNode {
    protected static final ImageIcon EMPTY_ICON = new ImageIcon();

    public CertificateNode(CertificateDefinition item) {
        this(item, new InstanceContent());
    }

    protected CertificateNode(CertificateDefinition item, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)item);
        content.add((Object)this);
    }

    public String getDisplayName() {
        return this.getDescriptor().getDisplayName();
    }

    public String getShortDescription() {
        return this.getDescriptor().getDescription();
    }

    private CertificateDefinition getDescriptor() {
        return (CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class);
    }

    public Action getPreferredAction() {
        return null;
    }

    public boolean isCheckable() {
        return true;
    }

    public boolean isCheckEnabled() {
        return true;
    }

    public Boolean isSelected() {
        boolean isTrusted = false;
        X509Certificate cert = ((CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class)).getCertificate();
        isTrusted = CertificateRepository.getDefault().contains(cert, true);
        return isTrusted;
    }

    public void setSelected(Boolean value) {
        Boolean oldValue = this.isSelected();
        if (!oldValue.equals(value)) {
            CertificateDefinition cert = (CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class);
            CertificateRepository.getDefault().update(cert.getCertificate(), value.booleanValue(), null);
            this.firePropertyChange("status", oldValue, value);
            this.onEnabledChange(value);
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new IsCa((Node)this));
        set.put((Node.Property)new Status((Node)this));
        set.put((Node.Property)new Subject((Node)this));
        set.put((Node.Property)new Issuer((Node)this));
        set.put((Node.Property)new Expires((Node)this));
        set.put((Node.Property)new Hostnames((Node)this));
        set.put((Node.Property)new Purposes((Node)this));
        sheet.put(set);
        return sheet;
    }

    protected void onEnabledChange(boolean enabled) {
    }

    public Image getIcon(int type) {
        boolean enabled = this.isSelected();
        if (enabled) {
            return ImageUtilities.loadImage((String)"com/paterva/maltego/certificates/ui/resources/Certificate.png");
        }
        return ImageUtilities.loadImage((String)"com/paterva/maltego/certificates/ui/resources/Certificate_untrusted.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        Runnable runnable = () -> {
            CertificateRepository.getDefault().remove(this.getDescriptor().getCertificate());
            this.fireNodeDestroyed();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(CertificateDeleteAction.class)};
    }

    public static Node.Property isca() {
        return new IsCa(Node.EMPTY);
    }

    public static Node.Property subject() {
        return new Subject(Node.EMPTY);
    }

    public static Node.Property issuer() {
        return new Issuer(Node.EMPTY);
    }

    public static Node.Property expires() {
        return new Expires(Node.EMPTY);
    }

    public static Node.Property purposes() {
        return new Purposes(Node.EMPTY);
    }

    public static Node.Property status() {
        return new Status(Node.EMPTY);
    }

    public static Node.Property hostnames() {
        return new Hostnames(Node.EMPTY);
    }

    private static class Hostnames
    extends NodePropertySupport.ReadOnly<String> {
        public Hostnames(Node node) {
            super(node, "hostnames", String.class, "Hostnames", "The hostnames associated with the certificate.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String desc = String.join((CharSequence)", ", ((CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class)).getHostnames());
            return CertificateUtils.getDisplayString((String)desc);
        }
    }

    private static class IsCa
    extends NodePropertySupport.ReadOnly<String> {
        public IsCa(Node node) {
            super(node, "isca", String.class, "CA?", "Indicates whether this certificate is a CA certificate or not.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            CertificateDefinition certDef = (CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class);
            return certDef.isCaCertificate() ? "Yes" : "No";
        }
    }

    private static class Status
    extends NodePropertySupport.ReadOnly<String> {
        public Status(Node node) {
            super(node, "status", String.class, "Status", "Indicates whether this certificate is trusted or not.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            boolean isTrusted = false;
            boolean isUnTrusted = false;
            X509Certificate cert = ((CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class)).getCertificate();
            CertificateRepository certRepo = CertificateRepository.getDefault();
            isTrusted = certRepo.contains(cert, true);
            isUnTrusted = certRepo.contains(cert, false);
            return isTrusted ? "Trusted" : (isUnTrusted ? "Untrusted" : "Deleted");
        }
    }

    private static class Purposes
    extends NodePropertySupport.ReadOnly<String> {
        public Purposes(Node node) {
            super(node, "purposes", String.class, "Purposes", "The intended usage of the certificate.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String desc = String.join((CharSequence)", ", ((CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class)).getKeyUsage());
            return CertificateUtils.getDisplayString((String)desc);
        }
    }

    public static class Expires
    extends NodePropertySupport.ReadOnly<String> {
        public Expires(Node node) {
            super(node, "expires", String.class, "Expires", "Date when the certificate expires.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            Date desc = ((CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class)).getCertificate().getNotAfter();
            return CertificateUtils.getDisplayString((String)CertificateUtils.toDateString((Date)desc));
        }
    }

    private static class Issuer
    extends NodePropertySupport.ReadOnly<String> {
        public Issuer(Node node) {
            super(node, "issuer", String.class, "Issuer", "Name of the organisation the certificate was issued by.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String desc = ((CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class)).getIssuerName();
            return CertificateUtils.getDisplayString((String)desc);
        }
    }

    private static class Subject
    extends NodePropertySupport.ReadOnly<String> {
        public Subject(Node node) {
            super(node, "subject", String.class, "Subject", "Name of the organisation the certificate was issued to.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String desc = ((CertificateDefinition)this.getLookup().lookup(CertificateDefinition.class)).getSubjectName();
            return CertificateUtils.getDisplayString((String)desc);
        }
    }
}

