/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.state.AbstractConnectionState;
import com.paterva.maltego.collab.graph.state.SignalMessage;

public class StateBlocked
extends AbstractConnectionState {
    public StateBlocked() {
        super(ConnectionStatus.Blocked, true);
    }

    @Override
    protected void run() {
        this.debug("blocked");
    }

    @Override
    public void sendPayload(String to, String xml) throws CollaborationException {
        this.tx().sendPayload(to, xml);
    }

    @Override
    public void payloadsReceived(PayloadCollection payloads) {
        Payload signalPayload = payloads.first("signal", false);
        if (signalPayload != null) {
            try {
                SignalMessage signal = SignalMessage.parse(signalPayload.getBody());
                this.signalReceived(signalPayload.getFrom(), signal);
            }
            catch (CollaborationException ex) {
                this.handleError("Cannot parse signal message", (Exception)((Object)ex));
            }
        } else {
            for (Payload payload : payloads) {
                if (payload.isType("signal")) continue;
                this.debug(String.format("queueing live: %s - %s", payload.getType(), payload.getID()));
                this.liveQueue().add(payload);
            }
        }
    }

    private void signalReceived(Participant from, SignalMessage signal) {
        if ("getgraph".equals(signal.getAction()) && signal.getType() == SignalMessage.Type.Request) {
            this.debug("Received graph request from " + from.getName());
            this.sendBusyResponse(from);
        }
    }

    private void sendBusyResponse(Participant to) {
        try {
            this.tx().sendPayload(to.getID(), SignalMessage.createErrorResponse("getgraph", 503, "busy").toXml());
        }
        catch (CollaborationException ex) {
            this.handleError("Failed to send busy response", (Exception)((Object)ex));
        }
    }

    @Override
    public void updateStatus(ParticipantPresence presence, String message) throws CollaborationException {
        this.tx().updateStatus(presence, message);
    }
}

