/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xlightweb.BadMessageException;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.RequestHandlerInfo;
import org.xlightweb.server.HttpServer;
import org.xlightweb.server.HttpServerConnection;
import org.xlightweb.server.HttpSession;
import org.xlightweb.server.ISessionManager;
import org.xlightweb.server.ServerUtils;
import org.xlightweb.server.SessionManager;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.Resource;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;

@Execution(value=0)
public final class HttpProtocolAdapter
implements IConnectHandler,
ILifeCycle,
MBeanRegistration {
    private static final Logger LOG = Logger.getLogger(HttpProtocolAdapter.class.getName());
    private static final boolean DEFAULT_CLOSE_ON_SENDING_ERROR = true;
    private static final NullRequestHandler NULL_REQUESTHANDLER = new NullRequestHandler();
    @Resource
    private IServer server;
    private ISessionManager sessionManager = new SessionManager();
    private boolean useCookies = true;
    private IHttpRequestHandler requestHandler;
    private RequestHandlerInfo requestHandlerInfo;
    private final List<IHttpConnectionHandler> connectionHandlers = new ArrayList<IHttpConnectionHandler>();
    private Long requestTimeoutMillis;
    private Long bodyDataReceiveTimeoutMillis;
    private boolean isCloseOnSendingError = true;
    private Integer maxTransactions;
    private int sessionMaxInactiveIntervalSec = Integer.MAX_VALUE;

    public HttpProtocolAdapter(IHttpRequestHandler requestHandler) {
        if (requestHandler == null) {
            requestHandler = NULL_REQUESTHANDLER;
        }
        this.requestHandler = requestHandler;
        this.requestHandlerInfo = HttpServerConnection.getRequestHandlerInfo(requestHandler);
    }

    public void setSessionManager(ISessionManager sessionManager) {
        block2: {
            try {
                this.sessionManager.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing session manager " + ioe.toString());
            }
        }
        this.sessionManager = sessionManager;
    }

    public void setUsingCookies(boolean useCookies) {
        this.useCookies = useCookies;
    }

    public boolean isUsingCookies() {
        return this.useCookies;
    }

    public ISessionManager getSessionManager() {
        return this.sessionManager;
    }

    public ObjectName preRegister(MBeanServer mbeanServer, ObjectName name) throws Exception {
        ISessionManager sessionManager = ((HttpServer)this.server).getSessionManager();
        ObjectName objectName = new ObjectName(name.getDomain() + ":type=" + "sessionManager" + ",name=" + sessionManager.hashCode());
        mbeanServer.registerMBean(new SessionManagerInfo(sessionManager), objectName);
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.preRegister(mbeanServer, name);
        }
        return ServerUtils.exportMbean(mbeanServer, name, this.requestHandler);
    }

    public void postRegister(Boolean registrationDone) {
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.postRegister(registrationDone);
        }
    }

    public void preDeregister() throws Exception {
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.preDeregister();
        }
    }

    public void postDeregister() {
        if (this.requestHandler instanceof MBeanRegistration) {
            MBeanRegistration mbeanRegistration = (MBeanRegistration)((Object)this.requestHandler);
            mbeanRegistration.postDeregister();
        }
    }

    public void setRequestTimeoutMillis(long requesttimeout) {
        if (requesttimeout < 1000L) {
            LOG.warning("try to set request timeout with " + requesttimeout + ". This will be ignored because the value is smaller than the min request timout " + 1000 + " millis");
            return;
        }
        this.requestTimeoutMillis = requesttimeout;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
    }

    public void setCloseOnSendingError(boolean isCloseOnSendingError) {
        this.isCloseOnSendingError = isCloseOnSendingError;
    }

    public boolean isCloseOnSendingError() {
        return this.isCloseOnSendingError;
    }

    public void setMaxTransactions(int maxTransactions) {
        this.maxTransactions = maxTransactions;
    }

    public int getMaxTransactions() {
        return this.maxTransactions;
    }

    public void setSessionMaxInactiveIntervalSec(int sessionMaxInactiveIntervalSec) {
        this.sessionMaxInactiveIntervalSec = sessionMaxInactiveIntervalSec;
    }

    public int getSessionMaxInactiveIntervalSec() {
        return this.sessionMaxInactiveIntervalSec;
    }

    public void addConnectionHandler(IHttpConnectionHandler connectionHandler) {
        this.connectionHandlers.add(connectionHandler);
    }

    public String getImplementationVersion() {
        return HttpUtils.getImplementationVersion();
    }

    public void onInit() {
        this.server.setStartUpLogMessage("xLightweb " + HttpUtils.getImplementationVersion() + "/" + this.server.getStartUpLogMessage());
        ServerUtils.injectServerField(this.requestHandler, this.server);
        ServerUtils.injectProtocolAdapter(this.requestHandler, this);
        if (this.requestHandler instanceof ILifeCycle) {
            ((ILifeCycle)this.requestHandler).onInit();
        }
    }

    public void onDestroy() throws IOException {
        block3: {
            if (this.requestHandler instanceof ILifeCycle) {
                try {
                    ((ILifeCycle)this.requestHandler).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + this.requestHandler + " " + ioe.toString());
                }
            }
        }
        this.sessionManager.close();
        this.connectionHandlers.clear();
        this.server = null;
        this.sessionManager = null;
        this.requestHandler = null;
        this.requestHandlerInfo = null;
    }

    public boolean onConnect(INonBlockingConnection connection) throws IOException {
        HttpServerConnection httpCon = new HttpServerConnection(this.sessionManager, this.sessionMaxInactiveIntervalSec, connection, this.requestHandler, this.requestHandlerInfo, this.isCloseOnSendingError, this.connectionHandlers, this.useCookies);
        if (this.maxTransactions != null) {
            httpCon.setMaxTransactions(this.maxTransactions);
        }
        if (this.requestTimeoutMillis != null) {
            httpCon.setRequestTimeoutMillis(this.requestTimeoutMillis);
        }
        if (this.bodyDataReceiveTimeoutMillis != null) {
            httpCon.setBodyDataReceiveTimeoutMillis(this.bodyDataReceiveTimeoutMillis);
        }
        return true;
    }

    private static final class SessionManagerInfo
    implements SessionManagerInfoMBean {
        private final ISessionManager sessionManager;
        private boolean isShowDetailedInfo = false;

        public SessionManagerInfo(ISessionManager sessionManager) {
            this.sessionManager = sessionManager;
        }

        public Integer getNumCreatedSessions() {
            if (this.sessionManager instanceof SessionManager) {
                return ((SessionManager)this.sessionManager).getNumCreatedSessions();
            }
            return null;
        }

        public Integer getNumExpiredSessions() {
            if (this.sessionManager instanceof SessionManager) {
                return ((SessionManager)this.sessionManager).getNumExpiredSessions();
            }
            return null;
        }

        public Integer getNumRemovedSessions() {
            if (this.sessionManager instanceof SessionManager) {
                return ((SessionManager)this.sessionManager).getNumExpiredSessions();
            }
            return null;
        }

        public boolean isShowDetailedInfo() {
            return this.isShowDetailedInfo;
        }

        public void setShowDetailedInfo(boolean isShowDetailedInfo) {
            this.isShowDetailedInfo = isShowDetailedInfo;
        }

        public int getNumSessions() {
            return this.sessionManager.getSessionMap().size();
        }

        public String[] getSessionsInfo() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.isShowDetailedInfo) {
                for (HttpSession session : this.sessionManager.getSessionMap().values()) {
                    result.add("[" + session.getId() + "; serSize=" + DataConverter.toFormatedBytesSize((long)this.determineSerializedSize(session)) + "] " + session.toString());
                }
            }
            return result.toArray(new String[result.size()]);
        }

        public Integer getTotalSessionStoreSize() {
            if (this.isShowDetailedInfo) {
                int size = 0;
                for (HttpSession session : this.sessionManager.getSessionMap().values()) {
                    size += this.determineSerializedSize(session);
                }
                return size;
            }
            return null;
        }

        private int determineSerializedSize(Serializable object) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(object);
                oos.close();
                return bos.toByteArray().length;
            }
            catch (IOException ioe) {
                return -1;
            }
        }
    }

    public static interface SessionManagerInfoMBean {
        public Integer getNumCreatedSessions();

        public Integer getNumRemovedSessions();

        public Integer getNumExpiredSessions();

        public String[] getSessionsInfo();

        public int getNumSessions();

        public Integer getTotalSessionStoreSize();

        public boolean isShowDetailedInfo();

        public void setShowDetailedInfo(boolean var1);
    }

    @Execution(value=0)
    private static final class NullRequestHandler
    implements IHttpRequestHandler {
        private NullRequestHandler() {
        }

        public void onRequest(IHttpExchange exchange) throws IOException, BadMessageException {
        }
    }
}

