/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.convert;

import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.typing.transforms.TransformMatcher;
import com.paterva.maltego.util.StringUtilities;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transformer;

public class DefaultStringConverter
implements StringConverter {
    private final Transformer _transformer;
    private static DefaultStringConverter _default;

    public DefaultStringConverter(Matcher matcher) {
        this._transformer = new Transformer(matcher);
    }

    public static DefaultStringConverter instance() {
        if (_default == null) {
            _default = new DefaultStringConverter(new TransformMatcher());
        }
        return _default;
    }

    @Override
    public Object convertFrom(String value, Class to) throws IllegalArgumentException {
        if (String.class.equals((Object)to)) {
            return value;
        }
        if (StringUtilities.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            return this._transformer.read(value, to);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert value \"" + value + "\" to type \"" + to.getSimpleName() + "\"", ex);
        }
    }

    @Override
    public String convertTo(Object value, Class from) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        try {
            return this._transformer.write(value, from);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert value \"" + value + "\" of type \"" + from.getSimpleName() + "\" to type \"string\"", ex);
        }
    }
}

