/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.analytics;

import com.maltego.analytics.api.AnalyticsClient;
import com.maltego.analytics.api.AnalyticsEvent;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class InstallHubItemEvent {
    private static final String TRIGGER_KEY = "trigger";

    private InstallHubItemEvent() {
    }

    public static void send(Trigger trigger, HubSeedDescriptor seed) {
        String hubItemName = seed.getName();
        List<String> hubItemUrl = seed.getGrantedHubSeedUrls().stream().filter(url -> url != null).map(url -> url.getUrl()).collect(Collectors.toList());
        if (seed.isCustom()) {
            hubItemName = InstallHubItemEvent.maskWithHash(hubItemName, "internal-hub-item");
            hubItemUrl = InstallHubItemEvent.maskList(hubItemUrl, "url");
        }
        InstallHubItemEvent.send(trigger, hubItemName, hubItemUrl);
    }

    private static String maskWithHash(String plain, String prefix) {
        String hash = Integer.toHexString(plain.hashCode());
        return prefix + "-" + hash;
    }

    private static List<String> maskList(List<String> plainList, String prefix) {
        ArrayList<String> maskedList = new ArrayList<String>(plainList.size());
        for (String plain : plainList) {
            String masked = InstallHubItemEvent.maskWithHash(plain, prefix);
            maskedList.add(masked);
        }
        return maskedList;
    }

    private static void send(Trigger trigger, String hubItemName, List<String> hubItemUrl) {
        AnalyticsEvent event = new AnalyticsEvent("install_hub_item", new AnalyticsEvent.Property[]{AnalyticsEvent.Property.of((String)TRIGGER_KEY, (Object)trigger.label), AnalyticsEvent.Property.of((String)"hub_item_name", (Object)hubItemName), AnalyticsEvent.Property.of((String)"hub_item_url", hubItemUrl)});
        AnalyticsClient.getDefault().send(event);
    }

    public static enum Trigger {
        WIZARD("installation_wizard"),
        MALTEGO_DATA_HUB("maltego_data_hub");

        String label;

        private Trigger(String label) {
            this.label = label;
        }
    }
}

