/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.UIManager;

class ExpandButton
extends JButton {
    private boolean _expanded = false;

    public ExpandButton(int sizeButton, Action action) {
        super(action);
        Dimension dmnsn = new Dimension(sizeButton, sizeButton);
        this.setPreferredSize(dmnsn);
        this.setMinimumSize(dmnsn);
        this.setMaximumSize(dmnsn);
        this.setRolloverEnabled(true);
        this.setOpaque(false);
        this.setFocusable(false);
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void setExpanded(boolean expanded) {
        if (this._expanded != expanded) {
            this._expanded = expanded;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics grphcs) {
        int[] yPoints;
        int[] xPoints;
        Graphics2D g2D = (Graphics2D)grphcs;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int margin = 10;
        int scaledSize = 140 + 2 * margin;
        AffineTransform transformOld = g2D.getTransform();
        g2D.scale((double)this.getWidth() / (double)scaledSize, (double)this.getHeight() / (double)scaledSize);
        int farEdge = scaledSize - margin;
        if (this._expanded) {
            xPoints = new int[]{farEdge, farEdge, 40 + margin};
            yPoints = new int[]{20 + margin, 120 + margin, 120 + margin};
        } else {
            int middle = scaledSize / 2;
            xPoints = new int[]{middle, farEdge, middle};
            yPoints = new int[]{margin, middle, farEdge};
        }
        g2D.setColor(this.getFillColor());
        g2D.fillPolygon(xPoints, yPoints, 3);
        g2D.setTransform(transformOld);
    }

    private Color getFillColor() {
        String colorProp = this.getModel().isRollover() ? "run-expand-button-hover" : (this._expanded ? "run-expand-button-is-expanded" : "run-expand-button-not-expanded");
        return UIManager.getLookAndFeelDefaults().getColor(colorProp);
    }
}

