/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.image;

import com.paterva.maltego.util.ui.image.ImageClickListener;
import com.paterva.maltego.util.ui.image.ImageStripModel;
import com.paterva.maltego.util.ui.image.ImageStripNavButton;
import com.paterva.maltego.util.ui.image.ImageStripRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ImageStrip
extends JComponent {
    private ImageStripModel _model;
    private ImageStripRenderer _renderer;
    private ImagesPanel _imagesPanel;
    private int _margin = 3;
    private JButton _leftButton;
    private JButton _rightButton;
    private ModelListener _modelListener;
    private Dimension[] _dimensions;
    private int _totalWidth;
    private int _scrollPosition;
    private Map<Integer, Rectangle> _visibleRects;
    private int _scrollSpeed = 0;
    private List<ImageClickListener> _listeners = new ArrayList<ImageClickListener>();
    private MyUpdater _updater = new MyUpdater();
    private Integer _hoverImage;

    public ImageStrip(ImageStripModel model, ImageStripRenderer renderer) {
        this._model = model;
        this._modelListener = new ModelListener();
        this._model.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._modelListener, (Object)this._model));
        this._renderer = renderer;
        this._renderer.setCallback(__ -> this._updater.update());
        this._imagesPanel = new ImagesPanel();
        this.setLayout(new BorderLayout());
        this._leftButton = new ImageStripNavButton(true);
        this._leftButton.setToolTipText("Scroll left");
        this._leftButton.addMouseListener(new ButtonDownListener(__ -> this.setScrollPosition(this._scrollPosition - this.getScrollSpeed())));
        JComponent leftButtonPanel = new JComponent(){};
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 2));
        leftButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButtonPanel.add(this._leftButton);
        this._rightButton = new ImageStripNavButton(false);
        this._rightButton.setToolTipText("Scroll right");
        this._rightButton.addMouseListener(new ButtonDownListener(__ -> this.setScrollPosition(this._scrollPosition + this.getScrollSpeed())));
        JComponent rightButtonPanel = new JComponent(){};
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 2));
        rightButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButtonPanel.add(this._rightButton);
        this.add((Component)leftButtonPanel, "West");
        this.add((Component)rightButtonPanel, "East");
        this.add(this._imagesPanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageStrip.this.recalculateDimensions();
                ImageStrip.this.recalculateVisibleImageRectangles();
                ImageStrip.this.updateButtons();
                ImageStrip.this.repaint();
            }
        });
        this._imagesPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                Integer index = ImageStrip.this.getImage(e.getX(), e.getY());
                if (index != null) {
                    ImageStrip.this.fireAction(index, e.getClickCount());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                ImageStrip.this.setHoverImage(null);
            }
        });
        this._imagesPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                Integer newHover = ImageStrip.this.getImage(e.getX(), e.getY());
                ImageStrip.this.setHoverImage(newHover);
            }
        });
    }

    private void setHoverImage(Integer newHover) {
        if (!Utilities.compareObjects((Object)newHover, (Object)this._hoverImage)) {
            this._hoverImage = newHover;
            this.repaint();
        }
    }

    private Integer getImage(int x, int y) {
        if (this._visibleRects != null) {
            for (Map.Entry<Integer, Rectangle> entry : this._visibleRects.entrySet()) {
                Rectangle rect = entry.getValue();
                if (!rect.contains(x, y)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void addListener(ImageClickListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(ImageClickListener listener) {
        this._listeners.remove(listener);
    }

    private void fireAction(int index, int clicks) {
        for (ImageClickListener listener : this._listeners) {
            listener.onClick(this._model.getImage(index), clicks);
        }
    }

    private int getScrollSpeed() {
        if (this._scrollSpeed < 40) {
            ++this._scrollSpeed;
        }
        return this._scrollSpeed / 4 + 1;
    }

    private void setScrollPosition(int position) {
        this._scrollPosition = position;
        this._scrollPosition = Math.min(this._scrollPosition, this._totalWidth - this._imagesPanel.getWidth());
        this._scrollPosition = Math.max(this._scrollPosition, 0);
        this.recalculateVisibleImageRectangles();
        this._imagesPanel.repaint();
        this.updateButtons();
    }

    private void updateButtons() {
        this._leftButton.setEnabled(this._scrollPosition > 0);
        this._rightButton.setEnabled(this._scrollPosition + this._imagesPanel.getWidth() < this._totalWidth);
    }

    private void recalculateDimensions() {
        if (this._imagesPanel.getWidth() <= 2 * this._margin && this._imagesPanel.getHeight() <= 2 * this._margin) {
            this._dimensions = null;
            return;
        }
        int stripHeight = this._imagesPanel.getHeight();
        int usableHeight = stripHeight - 2 * this._margin;
        this._totalWidth = 0;
        this._dimensions = new Dimension[this._model.getImageCount()];
        for (int i = 0; i < this._model.getImageCount(); ++i) {
            Dimension dim;
            int imgWidth = this._model.getWidth(i);
            int imgHeight = this._model.getHeight(i);
            this._dimensions[i] = dim = this.fitKeepRatio(imgWidth, imgHeight, 2 * usableHeight, usableHeight);
            this._totalWidth += dim.width + 2 * this._margin;
        }
    }

    private void recalculateVisibleImageRectangles() {
        if (this._dimensions == null || this._dimensions.length == 0) {
            this._visibleRects = null;
            return;
        }
        int visibleScrollEnd = this._scrollPosition + this._imagesPanel.getWidth();
        int width = 0;
        int firstVisibleIndex = -1;
        int firstVisibleWidth = 0;
        int lastVisibleIndex = -1;
        int lastVisibleWidth = 0;
        for (int i = 0; i < this._dimensions.length; ++i) {
            int newWidth = width + this._dimensions[i].width + 2 * this._margin;
            if (width <= this._scrollPosition && newWidth > this._scrollPosition) {
                firstVisibleIndex = i;
                firstVisibleWidth = newWidth - this._scrollPosition;
            }
            if (width <= visibleScrollEnd && newWidth > visibleScrollEnd) {
                lastVisibleIndex = i;
                lastVisibleWidth = visibleScrollEnd - width;
                break;
            }
            width = newWidth;
        }
        int usableHeight = this._imagesPanel.getHeight() - 2 * this._margin;
        this._visibleRects = new HashMap<Integer, Rectangle>();
        if (firstVisibleIndex == lastVisibleIndex) {
            Dimension dim = this.fitKeepRatio(firstVisibleIndex, this._imagesPanel.getWidth() - 2 * this._margin, usableHeight);
            this.addMargin(dim);
            int y = this.centerStart(dim.height, this._imagesPanel.getHeight());
            this._visibleRects.put(firstVisibleIndex, new Rectangle(0, y, dim.width, dim.height));
        } else {
            int x = 0;
            Dimension dim = this.fitKeepRatio(firstVisibleIndex, firstVisibleWidth - 2 * this._margin, usableHeight);
            this.addMargin(dim);
            int y = this.centerStart(dim.height, this._imagesPanel.getHeight());
            this._visibleRects.put(firstVisibleIndex, new Rectangle(x, y, dim.width, dim.height));
            x += dim.width;
            int lastMidIndex = lastVisibleIndex == -1 ? this._model.getImageCount() - 1 : lastVisibleIndex - 1;
            for (int i = firstVisibleIndex + 1; i <= lastMidIndex; ++i) {
                dim = new Dimension(this._dimensions[i]);
                this.addMargin(dim);
                y = this.centerStart(dim.height, this._imagesPanel.getHeight());
                this._visibleRects.put(i, new Rectangle(x, y, dim.width, dim.height));
                x += dim.width;
            }
            if (lastVisibleIndex != -1) {
                dim = this.fitKeepRatio(lastVisibleIndex, lastVisibleWidth - 2 * this._margin, usableHeight);
                this.addMargin(dim);
                y = this.centerStart(dim.height, this._imagesPanel.getHeight());
                this._visibleRects.put(lastVisibleIndex, new Rectangle(x, y, dim.width, dim.height));
            }
        }
    }

    private void addMargin(Dimension dim) {
        dim.setSize(dim.width + 2 * this._margin, dim.height + 2 * this._margin);
    }

    private int centerStart(int smallWidth, int largeWidth) {
        return (largeWidth - smallWidth) / 2;
    }

    private Dimension fitKeepRatio(int index, int maxWidth, int maxHeight) {
        int imgWidth = this._model.getWidth(index);
        int imgHeight = this._model.getHeight(index);
        return this.fitKeepRatio(imgWidth, imgHeight, maxWidth, maxHeight);
    }

    private Dimension fitKeepRatio(int width, int height, int maxWidth, int maxHeight) {
        if (height > maxHeight) {
            width = width * maxHeight / height;
            height = maxHeight;
        }
        if (width > maxWidth) {
            height = height * maxWidth / width;
            width = maxWidth;
        }
        return new Dimension(width, height);
    }

    private class MyUpdater {
        private boolean _cooldown = false;
        private boolean _mustUpdate = false;

        private MyUpdater() {
        }

        public void update() {
            if (!this._cooldown) {
                this._cooldown = true;
                this._mustUpdate = false;
                this.updateNow();
                Timer t = new Timer(500, __ -> {
                    this._cooldown = false;
                    if (this._mustUpdate) {
                        this.update();
                    }
                });
                t.setRepeats(false);
                t.start();
            } else {
                this._mustUpdate = true;
            }
        }

        private void updateNow() {
            ImageStrip.this.recalculateDimensions();
            ImageStrip.this.recalculateVisibleImageRectangles();
            ImageStrip.this._imagesPanel.repaint();
        }
    }

    private class ButtonDownListener
    extends MouseAdapter {
        private final ActionListener _listener;
        private Timer _timer;

        public ButtonDownListener(ActionListener listener) {
            this._listener = listener;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ImageStrip.this._scrollSpeed = 0;
            this._timer = new Timer(20, this._listener);
            this._timer.setInitialDelay(0);
            this._timer.start();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ImageStrip.this._updater.update();
            ImageStrip.this.updateButtons();
        }
    }

    private class ImagesPanel
    extends JComponent {
        private ImagesPanel() {
        }

        @Override
        public void paint(Graphics gfx) {
            if (ImageStrip.this._visibleRects != null && ImageStrip.this._visibleRects.size() > 0) {
                ImageStrip.this._renderer.paint(gfx, new LineBorder(Color.yellow), this.getWidth(), this.getHeight());
                for (Map.Entry entry : ImageStrip.this._visibleRects.entrySet()) {
                    int index = (Integer)entry.getKey();
                    Rectangle rect = (Rectangle)entry.getValue();
                    if (ImageStrip.this._hoverImage != null && index == ImageStrip.this._hoverImage) {
                        gfx.translate(rect.x, rect.y);
                        ImageStrip.this._renderer.paint(gfx, ImageStrip.this._model.getImage(index), rect.width, rect.height);
                        gfx.translate(-rect.x, -rect.y);
                        continue;
                    }
                    gfx.translate(rect.x, rect.y);
                    if (ImageStrip.this._model.isHighlight(index)) {
                        ImageStrip.this._renderer.paintHighlight(gfx, ImageStrip.this._model.getImage(index), rect.width, rect.height);
                    }
                    gfx.translate(ImageStrip.this._margin, ImageStrip.this._margin);
                    ImageStrip.this._renderer.paint(gfx, ImageStrip.this._model.getImage(index), rect.width - 2 * ImageStrip.this._margin, rect.height - 2 * ImageStrip.this._margin);
                    gfx.translate(-rect.x - ImageStrip.this._margin, -rect.y - ImageStrip.this._margin);
                }
            } else {
                ImageStrip.this._renderer.paintEmpty(gfx, this.getWidth(), this.getHeight());
            }
        }
    }
}

